/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.services;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ServiceInstanceType {
    MANAGED("managed_service_instance"),
    USER_PROVIDED("user_provided_service_instance");

    private final String value;

    private ServiceInstanceType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static ServiceInstanceType from(String s) {
        switch (s.toLowerCase()) {
            case "managed_service_instance": {
                return MANAGED;
            }
            case "user_provided_service_instance": {
                return USER_PROVIDED;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown service instance type: %s", s));
    }
}

