package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * A service instance
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ServiceInstance"})
public final class ServiceInstance extends org.cloudfoundry.operations.services._ServiceInstance {
  private final @Nullable String dashboardUrl;
  private final @Nullable String description;
  private final @Nullable String documentationUrl;
  private final @Nullable String lastOperation;
  private final @Nullable String message;
  private final @Nullable String startedAt;
  private final @Nullable String status;
  private final @Nullable List<String> tags;
  private final @Nullable String updatedAt;
  private final List<String> applications;
  private final String id;
  private final String name;
  private final @Nullable String plan;
  private final @Nullable String service;
  private final ServiceInstanceType type;

  private ServiceInstance(ServiceInstance.Builder builder) {
    this.dashboardUrl = builder.dashboardUrl;
    this.description = builder.description;
    this.documentationUrl = builder.documentationUrl;
    this.lastOperation = builder.lastOperation;
    this.message = builder.message;
    this.startedAt = builder.startedAt;
    this.status = builder.status;
    this.tags = builder.tags == null ? null : createUnmodifiableList(true, builder.tags);
    this.updatedAt = builder.updatedAt;
    this.applications = createUnmodifiableList(true, builder.applications);
    this.id = builder.id;
    this.name = builder.name;
    this.plan = builder.plan;
    this.service = builder.service;
    this.type = builder.type;
  }

  /**
   * The dashboard URL
   */
  @Override
  public @Nullable String getDashboardUrl() {
    return dashboardUrl;
  }

  /**
   * The service description
   */
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The documentation URL
   */
  @Override
  public @Nullable String getDocumentationUrl() {
    return documentationUrl;
  }

  /**
   * The last operation
   */
  @Override
  public @Nullable String getLastOperation() {
    return lastOperation;
  }

  /**
   * The message
   */
  @Override
  public @Nullable String getMessage() {
    return message;
  }

  /**
   * When the service was last started
   */
  @Override
  public @Nullable String getStartedAt() {
    return startedAt;
  }

  /**
   * The status of the last operation
   */
  @Override
  public @Nullable String getStatus() {
    return status;
  }

  /**
   * The tags for the service
   */
  @Override
  public @Nullable List<String> getTags() {
    return tags;
  }

  /**
   * When the service was last updated
   */
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * The bound applications
   */
  @Override
  public List<String> getApplications() {
    return applications;
  }

  /**
   * The service instance id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The service instance name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The managed service plan
   */
  @Override
  public @Nullable String getPlan() {
    return plan;
  }

  /**
   * The name of the managed service
   */
  @Override
  public @Nullable String getService() {
    return service;
  }

  /**
   * The type of the service instance
   */
  @Override
  public ServiceInstanceType getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code ServiceInstance} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceInstance
        && equalTo((ServiceInstance) another);
  }

  private boolean equalTo(ServiceInstance another) {
    return Objects.equals(dashboardUrl, another.dashboardUrl)
        && Objects.equals(description, another.description)
        && Objects.equals(documentationUrl, another.documentationUrl)
        && Objects.equals(lastOperation, another.lastOperation)
        && Objects.equals(message, another.message)
        && Objects.equals(startedAt, another.startedAt)
        && Objects.equals(status, another.status)
        && Objects.equals(tags, another.tags)
        && Objects.equals(updatedAt, another.updatedAt)
        && applications.equals(another.applications)
        && id.equals(another.id)
        && name.equals(another.name)
        && Objects.equals(plan, another.plan)
        && Objects.equals(service, another.service)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code dashboardUrl}, {@code description}, {@code documentationUrl}, {@code lastOperation}, {@code message}, {@code startedAt}, {@code status}, {@code tags}, {@code updatedAt}, {@code applications}, {@code id}, {@code name}, {@code plan}, {@code service}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(dashboardUrl);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(documentationUrl);
    h += (h << 5) + Objects.hashCode(lastOperation);
    h += (h << 5) + Objects.hashCode(message);
    h += (h << 5) + Objects.hashCode(startedAt);
    h += (h << 5) + Objects.hashCode(status);
    h += (h << 5) + Objects.hashCode(tags);
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + applications.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(plan);
    h += (h << 5) + Objects.hashCode(service);
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceInstance} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceInstance{"
        + "dashboardUrl=" + dashboardUrl
        + ", description=" + description
        + ", documentationUrl=" + documentationUrl
        + ", lastOperation=" + lastOperation
        + ", message=" + message
        + ", startedAt=" + startedAt
        + ", status=" + status
        + ", tags=" + tags
        + ", updatedAt=" + updatedAt
        + ", applications=" + applications
        + ", id=" + id
        + ", name=" + name
        + ", plan=" + plan
        + ", service=" + service
        + ", type=" + type
        + "}";
  }

  /**
   * Creates a builder for {@link ServiceInstance ServiceInstance}.
   * @return A new ServiceInstance builder
   */
  public static ServiceInstance.Builder builder() {
    return new ServiceInstance.Builder();
  }

  /**
   * Builds instances of type {@link ServiceInstance ServiceInstance}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private long initBits = 0x7L;

    private String dashboardUrl;
    private String description;
    private String documentationUrl;
    private String lastOperation;
    private String message;
    private String startedAt;
    private String status;
    private List<String> tags = null;
    private String updatedAt;
    private List<String> applications = new ArrayList<String>();
    private String id;
    private String name;
    private String plan;
    private String service;
    private ServiceInstanceType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceInstance} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceInstance instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ServiceInstance} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceInstance instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.operations.services.AbstractServiceInstanceSummary} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractServiceInstanceSummary instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof org.cloudfoundry.operations.services._ServiceInstance) {
        org.cloudfoundry.operations.services._ServiceInstance instance = (org.cloudfoundry.operations.services._ServiceInstance) object;
        String documentationUrlValue = instance.getDocumentationUrl();
        if (documentationUrlValue != null) {
          documentationUrl(documentationUrlValue);
        }
        String dashboardUrlValue = instance.getDashboardUrl();
        if (dashboardUrlValue != null) {
          dashboardUrl(dashboardUrlValue);
        }
        if ((bits & 0x1L) == 0) {
          String lastOperationValue = instance.getLastOperation();
          if (lastOperationValue != null) {
            lastOperation(lastOperationValue);
          }
          bits |= 0x1L;
        }
        String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        String startedAtValue = instance.getStartedAt();
        if (startedAtValue != null) {
          startedAt(startedAtValue);
        }
        String messageValue = instance.getMessage();
        if (messageValue != null) {
          message(messageValue);
        }
        List<String> tagsValue = instance.getTags();
        if (tagsValue != null) {
          addAllTags(tagsValue);
        }
        String statusValue = instance.getStatus();
        if (statusValue != null) {
          status(statusValue);
        }
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
      if (object instanceof AbstractServiceInstanceSummary) {
        AbstractServiceInstanceSummary instance = (AbstractServiceInstanceSummary) object;
        String serviceValue = instance.getService();
        if (serviceValue != null) {
          service(serviceValue);
        }
        if ((bits & 0x1L) == 0) {
          String lastOperationValue = instance.getLastOperation();
          if (lastOperationValue != null) {
            lastOperation(lastOperationValue);
          }
          bits |= 0x1L;
        }
        name(instance.getName());
        id(instance.getId());
        type(instance.getType());
        String planValue = instance.getPlan();
        if (planValue != null) {
          plan(planValue);
        }
        addAllApplications(instance.getApplications());
      }
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getDashboardUrl() dashboardUrl} attribute.
     * @param dashboardUrl The value for dashboardUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dashboardUrl(@Nullable String dashboardUrl) {
      this.dashboardUrl = dashboardUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getDocumentationUrl() documentationUrl} attribute.
     * @param documentationUrl The value for documentationUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder documentationUrl(@Nullable String documentationUrl) {
      this.documentationUrl = documentationUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getLastOperation() lastOperation} attribute.
     * @param lastOperation The value for lastOperation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lastOperation(@Nullable String lastOperation) {
      this.lastOperation = lastOperation;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getMessage() message} attribute.
     * @param message The value for message (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder message(@Nullable String message) {
      this.message = message;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getStartedAt() startedAt} attribute.
     * @param startedAt The value for startedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startedAt(@Nullable String startedAt) {
      this.startedAt = startedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getStatus() status} attribute.
     * @param status The value for status (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder status(@Nullable String status) {
      this.status = status;
      return this;
    }

    /**
     * Adds one element to {@link _ServiceInstance#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String element) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link _ServiceInstance#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String... elements) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ServiceInstance#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.tags = null;
        return this;
      }
      this.tags = new ArrayList<String>();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link _ServiceInstance#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      Objects.requireNonNull(elements, "tags element");
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Adds one element to {@link _ServiceInstance#getApplications() applications} list.
     * @param element A applications element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder application(String element) {
      this.applications.add(Objects.requireNonNull(element, "applications element"));
      return this;
    }

    /**
     * Adds elements to {@link _ServiceInstance#getApplications() applications} list.
     * @param elements An array of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder application(String... elements) {
      for (String element : elements) {
        this.applications.add(Objects.requireNonNull(element, "applications element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ServiceInstance#getApplications() applications} list.
     * @param elements An iterable of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applications(Iterable<String> elements) {
      this.applications.clear();
      return addAllApplications(elements);
    }

    /**
     * Adds elements to {@link _ServiceInstance#getApplications() applications} list.
     * @param elements An iterable of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplications(Iterable<String> elements) {
      for (String element : elements) {
        this.applications.add(Objects.requireNonNull(element, "applications element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getPlan() plan} attribute.
     * @param plan The value for plan (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder plan(@Nullable String plan) {
      this.plan = plan;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getService() service} attribute.
     * @param service The value for service (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder service(@Nullable String service) {
      this.service = service;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(ServiceInstanceType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ServiceInstance ServiceInstance}.
     * @return An immutable instance of ServiceInstance
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceInstance build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ServiceInstance(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build ServiceInstance, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
