package org.cloudfoundry.operations.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Represents a route
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Route"})
public final class Route extends org.cloudfoundry.operations.applications._Route {
  private final String route;

  private Route(Route.Builder builder) {
    this.route = builder.route;
  }

  /**
   * The route
   */
  @JsonProperty("route")
  @Override
  public String getRoute() {
    return route;
  }

  /**
   * This instance is equal to all instances of {@code Route} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Route
        && equalTo((Route) another);
  }

  private boolean equalTo(Route another) {
    return route.equals(another.route);
  }

  /**
   * Computes a hash code from attributes: {@code route}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + route.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Route} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Route{"
        + "route=" + route
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.operations.applications._Route {
    String route;
    @JsonProperty("route")
    public void setRoute(String route) {
      this.route = route;
    }
    @Override
    public String getRoute() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Route fromJson(Json json) {
    Route.Builder builder = Route.builder();
    if (json.route != null) {
      builder.route(json.route);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Route Route}.
   * @return A new Route builder
   */
  public static Route.Builder builder() {
    return new Route.Builder();
  }

  /**
   * Builds instances of type {@link Route Route}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ROUTE = 0x1L;
    private long initBits = 0x1L;

    private String route;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Route} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Route instance) {
      return from((_Route) instance);
    }

    /**
     * Copy abstract value type {@code _Route} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Route instance) {
      Objects.requireNonNull(instance, "instance");
      route(instance.getRoute());
      return this;
    }

    /**
     * Initializes the value for the {@link _Route#getRoute() route} attribute.
     * @param route The value for route 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("route")
    public final Builder route(String route) {
      this.route = Objects.requireNonNull(route, "route");
      initBits &= ~INIT_BIT_ROUTE;
      return this;
    }

    /**
     * Builds a new {@link Route Route}.
     * @return An immutable instance of Route
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Route build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Route(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ROUTE) != 0) attributes.add("route");
      return "Cannot build Route, some of required attributes are not set " + attributes;
    }
  }
}
