package org.cloudfoundry.operations.domains;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * A Router Group
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_RouterGroup"})
public final class RouterGroup extends org.cloudfoundry.operations.domains._RouterGroup {
  private final String id;
  private final String name;
  private final String type;

  private RouterGroup(RouterGroup.Builder builder) {
    this.id = builder.id;
    this.name = builder.name;
    this.type = builder.type;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The name of the router group
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * Type of the router group, e.g. tcp
   */
  @Override
  public String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code RouterGroup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RouterGroup
        && equalTo((RouterGroup) another);
  }

  private boolean equalTo(RouterGroup another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RouterGroup} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RouterGroup{"
        + "id=" + id
        + ", name=" + name
        + ", type=" + type
        + "}";
  }

  /**
   * Creates a builder for {@link RouterGroup RouterGroup}.
   * @return A new RouterGroup builder
   */
  public static RouterGroup.Builder builder() {
    return new RouterGroup.Builder();
  }

  /**
   * Builds instances of type {@link RouterGroup RouterGroup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private long initBits = 0x7L;

    private String id;
    private String name;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RouterGroup} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RouterGroup instance) {
      return from((_RouterGroup) instance);
    }

    /**
     * Copy abstract value type {@code _RouterGroup} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RouterGroup instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      name(instance.getName());
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link _RouterGroup#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _RouterGroup#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _RouterGroup#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link RouterGroup RouterGroup}.
     * @return An immutable instance of RouterGroup
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RouterGroup build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RouterGroup(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build RouterGroup, some of required attributes are not set " + attributes;
    }
  }
}
