package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request options for the terminate application task operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_TerminateApplicationTaskRequest"})
public final class TerminateApplicationTaskRequest
    extends org.cloudfoundry.operations.applications._TerminateApplicationTaskRequest {
  private final String applicationName;
  private final Integer sequenceId;

  private TerminateApplicationTaskRequest(TerminateApplicationTaskRequest.Builder builder) {
    this.applicationName = builder.applicationName;
    this.sequenceId = builder.sequenceId;
  }

  /**
   * The name of the application
   */
  @Override
  public String getApplicationName() {
    return applicationName;
  }

  /**
   * The sequence id of the task
   */
  @Override
  public Integer getSequenceId() {
    return sequenceId;
  }

  /**
   * This instance is equal to all instances of {@code TerminateApplicationTaskRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof TerminateApplicationTaskRequest
        && equalTo((TerminateApplicationTaskRequest) another);
  }

  private boolean equalTo(TerminateApplicationTaskRequest another) {
    return applicationName.equals(another.applicationName)
        && sequenceId.equals(another.sequenceId);
  }

  /**
   * Computes a hash code from attributes: {@code applicationName}, {@code sequenceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationName.hashCode();
    h += (h << 5) + sequenceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TerminateApplicationTaskRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TerminateApplicationTaskRequest{"
        + "applicationName=" + applicationName
        + ", sequenceId=" + sequenceId
        + "}";
  }

  /**
   * Creates a builder for {@link TerminateApplicationTaskRequest TerminateApplicationTaskRequest}.
   * @return A new TerminateApplicationTaskRequest builder
   */
  public static TerminateApplicationTaskRequest.Builder builder() {
    return new TerminateApplicationTaskRequest.Builder();
  }

  /**
   * Builds instances of type {@link TerminateApplicationTaskRequest TerminateApplicationTaskRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_NAME = 0x1L;
    private static final long INIT_BIT_SEQUENCE_ID = 0x2L;
    private long initBits = 0x3L;

    private String applicationName;
    private Integer sequenceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TerminateApplicationTaskRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TerminateApplicationTaskRequest instance) {
      return from((_TerminateApplicationTaskRequest) instance);
    }

    /**
     * Copy abstract value type {@code _TerminateApplicationTaskRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_TerminateApplicationTaskRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationName(instance.getApplicationName());
      sequenceId(instance.getSequenceId());
      return this;
    }

    /**
     * Initializes the value for the {@link _TerminateApplicationTaskRequest#getApplicationName() applicationName} attribute.
     * @param applicationName The value for applicationName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationName(String applicationName) {
      this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
      initBits &= ~INIT_BIT_APPLICATION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _TerminateApplicationTaskRequest#getSequenceId() sequenceId} attribute.
     * @param sequenceId The value for sequenceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sequenceId(Integer sequenceId) {
      this.sequenceId = Objects.requireNonNull(sequenceId, "sequenceId");
      initBits &= ~INIT_BIT_SEQUENCE_ID;
      return this;
    }

    /**
     * Builds a new {@link TerminateApplicationTaskRequest TerminateApplicationTaskRequest}.
     * @return An immutable instance of TerminateApplicationTaskRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public TerminateApplicationTaskRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new TerminateApplicationTaskRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_NAME) != 0) attributes.add("applicationName");
      if ((initBits & INIT_BIT_SEQUENCE_ID) != 0) attributes.add("sequenceId");
      return "Cannot build TerminateApplicationTaskRequest, some of required attributes are not set " + attributes;
    }
  }
}
