package org.cloudfoundry.operations.useradmin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The users for an organization
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_OrganizationUsers"})
public final class OrganizationUsers extends org.cloudfoundry.operations.useradmin._OrganizationUsers {
  private final List<String> auditors;
  private final List<String> billingManagers;
  private final List<String> managers;

  private OrganizationUsers(OrganizationUsers.Builder builder) {
    this.auditors = createUnmodifiableList(true, builder.auditors);
    this.billingManagers = createUnmodifiableList(true, builder.billingManagers);
    this.managers = createUnmodifiableList(true, builder.managers);
  }

  /**
   * The organization's auditors
   */
  @Override
  public List<String> getAuditors() {
    return auditors;
  }

  /**
   * The organization's developers
   */
  @Override
  public List<String> getBillingManagers() {
    return billingManagers;
  }

  /**
   * The organization's managers
   */
  @Override
  public List<String> getManagers() {
    return managers;
  }

  /**
   * This instance is equal to all instances of {@code OrganizationUsers} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OrganizationUsers
        && equalTo((OrganizationUsers) another);
  }

  private boolean equalTo(OrganizationUsers another) {
    return auditors.equals(another.auditors)
        && billingManagers.equals(another.billingManagers)
        && managers.equals(another.managers);
  }

  /**
   * Computes a hash code from attributes: {@code auditors}, {@code billingManagers}, {@code managers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + auditors.hashCode();
    h += (h << 5) + billingManagers.hashCode();
    h += (h << 5) + managers.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OrganizationUsers} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OrganizationUsers{"
        + "auditors=" + auditors
        + ", billingManagers=" + billingManagers
        + ", managers=" + managers
        + "}";
  }

  /**
   * Creates a builder for {@link OrganizationUsers OrganizationUsers}.
   * @return A new OrganizationUsers builder
   */
  public static OrganizationUsers.Builder builder() {
    return new OrganizationUsers.Builder();
  }

  /**
   * Builds instances of type {@link OrganizationUsers OrganizationUsers}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<String> auditors = new ArrayList<String>();
    private List<String> billingManagers = new ArrayList<String>();
    private List<String> managers = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OrganizationUsers} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OrganizationUsers instance) {
      return from((_OrganizationUsers) instance);
    }

    /**
     * Copy abstract value type {@code _OrganizationUsers} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_OrganizationUsers instance) {
      Objects.requireNonNull(instance, "instance");
      addAllAuditors(instance.getAuditors());
      addAllBillingManagers(instance.getBillingManagers());
      addAllManagers(instance.getManagers());
      return this;
    }

    /**
     * Adds one element to {@link _OrganizationUsers#getAuditors() auditors} list.
     * @param element A auditors element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditor(String element) {
      this.auditors.add(Objects.requireNonNull(element, "auditors element"));
      return this;
    }

    /**
     * Adds elements to {@link _OrganizationUsers#getAuditors() auditors} list.
     * @param elements An array of auditors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditor(String... elements) {
      for (String element : elements) {
        this.auditors.add(Objects.requireNonNull(element, "auditors element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _OrganizationUsers#getAuditors() auditors} list.
     * @param elements An iterable of auditors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditors(Iterable<String> elements) {
      this.auditors.clear();
      return addAllAuditors(elements);
    }

    /**
     * Adds elements to {@link _OrganizationUsers#getAuditors() auditors} list.
     * @param elements An iterable of auditors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuditors(Iterable<String> elements) {
      for (String element : elements) {
        this.auditors.add(Objects.requireNonNull(element, "auditors element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _OrganizationUsers#getBillingManagers() billingManagers} list.
     * @param element A billingManagers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManager(String element) {
      this.billingManagers.add(Objects.requireNonNull(element, "billingManagers element"));
      return this;
    }

    /**
     * Adds elements to {@link _OrganizationUsers#getBillingManagers() billingManagers} list.
     * @param elements An array of billingManagers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManager(String... elements) {
      for (String element : elements) {
        this.billingManagers.add(Objects.requireNonNull(element, "billingManagers element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _OrganizationUsers#getBillingManagers() billingManagers} list.
     * @param elements An iterable of billingManagers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManagers(Iterable<String> elements) {
      this.billingManagers.clear();
      return addAllBillingManagers(elements);
    }

    /**
     * Adds elements to {@link _OrganizationUsers#getBillingManagers() billingManagers} list.
     * @param elements An iterable of billingManagers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBillingManagers(Iterable<String> elements) {
      for (String element : elements) {
        this.billingManagers.add(Objects.requireNonNull(element, "billingManagers element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _OrganizationUsers#getManagers() managers} list.
     * @param element A managers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder manager(String element) {
      this.managers.add(Objects.requireNonNull(element, "managers element"));
      return this;
    }

    /**
     * Adds elements to {@link _OrganizationUsers#getManagers() managers} list.
     * @param elements An array of managers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder manager(String... elements) {
      for (String element : elements) {
        this.managers.add(Objects.requireNonNull(element, "managers element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _OrganizationUsers#getManagers() managers} list.
     * @param elements An iterable of managers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managers(Iterable<String> elements) {
      this.managers.clear();
      return addAllManagers(elements);
    }

    /**
     * Adds elements to {@link _OrganizationUsers#getManagers() managers} list.
     * @param elements An iterable of managers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllManagers(Iterable<String> elements) {
      for (String element : elements) {
        this.managers.add(Objects.requireNonNull(element, "managers element"));
      }
      return this;
    }

    /**
     * Builds a new {@link OrganizationUsers OrganizationUsers}.
     * @return An immutable instance of OrganizationUsers
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OrganizationUsers build() {
      return new OrganizationUsers(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
