/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.useradmin;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.useradmin._CreateUserRequest;

public final class CreateUserRequest
extends _CreateUserRequest {
    @Nullable
    private final String origin;
    @Nullable
    private final String password;
    private final String username;

    private CreateUserRequest(Builder builder) {
        this.origin = builder.origin;
        this.password = builder.password;
        this.username = builder.username;
    }

    @Override
    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    @Override
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateUserRequest && this.equalTo((CreateUserRequest)another);
    }

    private boolean equalTo(CreateUserRequest another) {
        return Objects.equals(this.origin, another.origin) && Objects.equals(this.password, another.password) && this.username.equals(another.username);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.origin);
        h += (h << 5) + Objects.hashCode(this.password);
        h += (h << 5) + this.username.hashCode();
        return h;
    }

    public String toString() {
        return "CreateUserRequest{origin=" + this.origin + ", password=" + this.password + ", username=" + this.username + "}";
    }

    private static CreateUserRequest validate(CreateUserRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USERNAME = 1L;
        private long initBits = 1L;
        private String origin;
        private String password;
        private String username;

        private Builder() {
        }

        public final Builder from(CreateUserRequest instance) {
            return this.from((_CreateUserRequest)instance);
        }

        final Builder from(_CreateUserRequest instance) {
            String passwordValue;
            Objects.requireNonNull(instance, "instance");
            String originValue = instance.getOrigin();
            if (originValue != null) {
                this.origin(originValue);
            }
            if ((passwordValue = instance.getPassword()) != null) {
                this.password(passwordValue);
            }
            this.username(instance.getUsername());
            return this;
        }

        public final Builder origin(@Nullable String origin) {
            this.origin = origin;
            return this;
        }

        public final Builder password(@Nullable String password) {
            this.password = password;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public CreateUserRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return CreateUserRequest.validate(new CreateUserRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("username");
            }
            return "Cannot build CreateUserRequest, some of required attributes are not set " + attributes;
        }
    }
}

