package org.cloudfoundry.operations.networkpolicies;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request options for the remove network policy operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_RemoveNetworkPolicyRequest"})
public final class RemoveNetworkPolicyRequest
    extends org.cloudfoundry.operations.networkpolicies._RemoveNetworkPolicyRequest {
  private final String destination;
  private final @Nullable Integer endPort;
  private final String protocol;
  private final String source;
  private final Integer startPort;

  private RemoveNetworkPolicyRequest(RemoveNetworkPolicyRequest.Builder builder) {
    this.destination = builder.destination;
    this.endPort = builder.endPort;
    this.protocol = builder.protocol;
    this.source = builder.source;
    this.startPort = builder.startPort;
  }

  /**
   * Name of the destination
   */
  @Override
  public String getDestination() {
    return destination;
  }

  /**
   * End of the port range
   */
  @Override
  public @Nullable Integer getEndPort() {
    return endPort;
  }

  /**
   * The protocol
   */
  @Override
  public String getProtocol() {
    return protocol;
  }

  /**
   * Name of the source
   */
  @Override
  public String getSource() {
    return source;
  }

  /**
   * Start of the port range
   */
  @Override
  public Integer getStartPort() {
    return startPort;
  }

  /**
   * This instance is equal to all instances of {@code RemoveNetworkPolicyRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveNetworkPolicyRequest
        && equalTo((RemoveNetworkPolicyRequest) another);
  }

  private boolean equalTo(RemoveNetworkPolicyRequest another) {
    return destination.equals(another.destination)
        && Objects.equals(endPort, another.endPort)
        && protocol.equals(another.protocol)
        && source.equals(another.source)
        && startPort.equals(another.startPort);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code endPort}, {@code protocol}, {@code source}, {@code startPort}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + Objects.hashCode(endPort);
    h += (h << 5) + protocol.hashCode();
    h += (h << 5) + source.hashCode();
    h += (h << 5) + startPort.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveNetworkPolicyRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveNetworkPolicyRequest{"
        + "destination=" + destination
        + ", endPort=" + endPort
        + ", protocol=" + protocol
        + ", source=" + source
        + ", startPort=" + startPort
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveNetworkPolicyRequest RemoveNetworkPolicyRequest}.
   * @return A new RemoveNetworkPolicyRequest builder
   */
  public static RemoveNetworkPolicyRequest.Builder builder() {
    return new RemoveNetworkPolicyRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveNetworkPolicyRequest RemoveNetworkPolicyRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DESTINATION = 0x1L;
    private static final long INIT_BIT_PROTOCOL = 0x2L;
    private static final long INIT_BIT_SOURCE = 0x4L;
    private static final long INIT_BIT_START_PORT = 0x8L;
    private long initBits = 0xfL;

    private String destination;
    private Integer endPort;
    private String protocol;
    private String source;
    private Integer startPort;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveNetworkPolicyRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveNetworkPolicyRequest instance) {
      return from((_RemoveNetworkPolicyRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveNetworkPolicyRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveNetworkPolicyRequest instance) {
      Objects.requireNonNull(instance, "instance");
      destination(instance.getDestination());
      Integer endPortValue = instance.getEndPort();
      if (endPortValue != null) {
        endPort(endPortValue);
      }
      protocol(instance.getProtocol());
      source(instance.getSource());
      startPort(instance.getStartPort());
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveNetworkPolicyRequest#getDestination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destination(String destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveNetworkPolicyRequest#getEndPort() endPort} attribute.
     * @param endPort The value for endPort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder endPort(@Nullable Integer endPort) {
      this.endPort = endPort;
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveNetworkPolicyRequest#getProtocol() protocol} attribute.
     * @param protocol The value for protocol 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder protocol(String protocol) {
      this.protocol = Objects.requireNonNull(protocol, "protocol");
      initBits &= ~INIT_BIT_PROTOCOL;
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveNetworkPolicyRequest#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder source(String source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveNetworkPolicyRequest#getStartPort() startPort} attribute.
     * @param startPort The value for startPort 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startPort(Integer startPort) {
      this.startPort = Objects.requireNonNull(startPort, "startPort");
      initBits &= ~INIT_BIT_START_PORT;
      return this;
    }

    /**
     * Builds a new {@link RemoveNetworkPolicyRequest RemoveNetworkPolicyRequest}.
     * @return An immutable instance of RemoveNetworkPolicyRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveNetworkPolicyRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveNetworkPolicyRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      if ((initBits & INIT_BIT_PROTOCOL) != 0) attributes.add("protocol");
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_START_PORT) != 0) attributes.add("startPort");
      return "Cannot build RemoveNetworkPolicyRequest, some of required attributes are not set " + attributes;
    }
  }
}
