package org.cloudfoundry.operations.domains;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request options for the create shared domain operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CreateSharedDomainRequest"})
public final class CreateSharedDomainRequest
    extends org.cloudfoundry.operations.domains._CreateSharedDomainRequest {
  private final String domain;

  private CreateSharedDomainRequest(CreateSharedDomainRequest.Builder builder) {
    this.domain = builder.domain;
  }

  /**
   * The domain name
   */
  @Override
  public String getDomain() {
    return domain;
  }

  /**
   * This instance is equal to all instances of {@code CreateSharedDomainRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateSharedDomainRequest
        && equalTo((CreateSharedDomainRequest) another);
  }

  private boolean equalTo(CreateSharedDomainRequest another) {
    return domain.equals(another.domain);
  }

  /**
   * Computes a hash code from attributes: {@code domain}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + domain.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateSharedDomainRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateSharedDomainRequest{"
        + "domain=" + domain
        + "}";
  }

  /**
   * Creates a builder for {@link CreateSharedDomainRequest CreateSharedDomainRequest}.
   * @return A new CreateSharedDomainRequest builder
   */
  public static CreateSharedDomainRequest.Builder builder() {
    return new CreateSharedDomainRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateSharedDomainRequest CreateSharedDomainRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN = 0x1L;
    private long initBits = 0x1L;

    private String domain;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateSharedDomainRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateSharedDomainRequest instance) {
      return from((_CreateSharedDomainRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateSharedDomainRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateSharedDomainRequest instance) {
      Objects.requireNonNull(instance, "instance");
      domain(instance.getDomain());
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateSharedDomainRequest#getDomain() domain} attribute.
     * @param domain The value for domain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String domain) {
      this.domain = Objects.requireNonNull(domain, "domain");
      initBits &= ~INIT_BIT_DOMAIN;
      return this;
    }

    /**
     * Builds a new {@link CreateSharedDomainRequest CreateSharedDomainRequest}.
     * @return An immutable instance of CreateSharedDomainRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateSharedDomainRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateSharedDomainRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DOMAIN) != 0) attributes.add("domain");
      return "Cannot build CreateSharedDomainRequest, some of required attributes are not set " + attributes;
    }
  }
}
