package org.cloudfoundry.operations.domains;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request options for the share domain operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ShareDomainRequest"})
public final class ShareDomainRequest extends org.cloudfoundry.operations.domains._ShareDomainRequest {
  private final String domain;
  private final String organization;

  private ShareDomainRequest(ShareDomainRequest.Builder builder) {
    this.domain = builder.domain;
    this.organization = builder.organization;
  }

  /**
   * The domain name
   */
  @Override
  public String getDomain() {
    return domain;
  }

  /**
   * The organization name of the domain
   */
  @Override
  public String getOrganization() {
    return organization;
  }

  /**
   * This instance is equal to all instances of {@code ShareDomainRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ShareDomainRequest
        && equalTo((ShareDomainRequest) another);
  }

  private boolean equalTo(ShareDomainRequest another) {
    return domain.equals(another.domain)
        && organization.equals(another.organization);
  }

  /**
   * Computes a hash code from attributes: {@code domain}, {@code organization}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + domain.hashCode();
    h = h * 17 + organization.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ShareDomainRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ShareDomainRequest{"
        + "domain=" + domain
        + ", organization=" + organization
        + "}";
  }

  /**
   * Creates a builder for {@link ShareDomainRequest ShareDomainRequest}.
   * @return A new ShareDomainRequest builder
   */
  public static ShareDomainRequest.Builder builder() {
    return new ShareDomainRequest.Builder();
  }

  /**
   * Builds instances of type {@link ShareDomainRequest ShareDomainRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN = 0x1L;
    private static final long INIT_BIT_ORGANIZATION = 0x2L;
    private long initBits = 0x3L;

    private String domain;
    private String organization;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ShareDomainRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ShareDomainRequest instance) {
      return from((_ShareDomainRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ShareDomainRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ShareDomainRequest instance) {
      Objects.requireNonNull(instance, "instance");
      domain(instance.getDomain());
      organization(instance.getOrganization());
      return this;
    }

    /**
     * Initializes the value for the {@link _ShareDomainRequest#getDomain() domain} attribute.
     * @param domain The value for domain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String domain) {
      this.domain = Objects.requireNonNull(domain, "domain");
      initBits &= ~INIT_BIT_DOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link _ShareDomainRequest#getOrganization() organization} attribute.
     * @param organization The value for organization 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organization(String organization) {
      this.organization = Objects.requireNonNull(organization, "organization");
      initBits &= ~INIT_BIT_ORGANIZATION;
      return this;
    }

    /**
     * Builds a new {@link ShareDomainRequest ShareDomainRequest}.
     * @return An immutable instance of ShareDomainRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ShareDomainRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ShareDomainRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DOMAIN) != 0) attributes.add("domain");
      if ((initBits & INIT_BIT_ORGANIZATION) != 0) attributes.add("organization");
      return "Cannot build ShareDomainRequest, some of required attributes are not set " + attributes;
    }
  }
}
