package org.cloudfoundry.operations.buildpacks;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request options for the create buildpack operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CreateBuildpackRequest"})
public final class CreateBuildpackRequest
    extends org.cloudfoundry.operations.buildpacks._CreateBuildpackRequest {
  private final Path buildpack;
  private final @Nullable Boolean enable;
  private final String fileName;
  private final String name;
  private final Integer position;

  private CreateBuildpackRequest(CreateBuildpackRequest.Builder builder) {
    this.buildpack = builder.buildpack;
    this.enable = builder.enable;
    this.fileName = builder.fileName;
    this.name = builder.name;
    this.position = builder.position;
  }

  /**
   * The path to the buildpack
   */
  @Override
  public Path getBuildpack() {
    return buildpack;
  }

  /**
   * Enables the buildpack to be used for staging
   */
  @Override
  public @Nullable Boolean getEnable() {
    return enable;
  }

  /**
   * The buildpack file name
   */
  @Override
  public String getFileName() {
    return fileName;
  }

  /**
   * The buildpack name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The buildpack position
   */
  @Override
  public Integer getPosition() {
    return position;
  }

  /**
   * This instance is equal to all instances of {@code CreateBuildpackRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateBuildpackRequest
        && equalTo((CreateBuildpackRequest) another);
  }

  private boolean equalTo(CreateBuildpackRequest another) {
    return buildpack.equals(another.buildpack)
        && Objects.equals(enable, another.enable)
        && fileName.equals(another.fileName)
        && name.equals(another.name)
        && position.equals(another.position);
  }

  /**
   * Computes a hash code from attributes: {@code buildpack}, {@code enable}, {@code fileName}, {@code name}, {@code position}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + buildpack.hashCode();
    h = h * 17 + Objects.hashCode(enable);
    h = h * 17 + fileName.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + position.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateBuildpackRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateBuildpackRequest{"
        + "buildpack=" + buildpack
        + ", enable=" + enable
        + ", fileName=" + fileName
        + ", name=" + name
        + ", position=" + position
        + "}";
  }

  /**
   * Creates a builder for {@link CreateBuildpackRequest CreateBuildpackRequest}.
   * @return A new CreateBuildpackRequest builder
   */
  public static CreateBuildpackRequest.Builder builder() {
    return new CreateBuildpackRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateBuildpackRequest CreateBuildpackRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_BUILDPACK = 0x1L;
    private static final long INIT_BIT_FILE_NAME = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private static final long INIT_BIT_POSITION = 0x8L;
    private long initBits = 0xfL;

    private Path buildpack;
    private Boolean enable;
    private String fileName;
    private String name;
    private Integer position;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateBuildpackRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateBuildpackRequest instance) {
      return from((_CreateBuildpackRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateBuildpackRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateBuildpackRequest instance) {
      Objects.requireNonNull(instance, "instance");
      buildpack(instance.getBuildpack());
      Boolean enableValue = instance.getEnable();
      if (enableValue != null) {
        enable(enableValue);
      }
      fileName(instance.getFileName());
      name(instance.getName());
      position(instance.getPosition());
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateBuildpackRequest#getBuildpack() buildpack} attribute.
     * @param buildpack The value for buildpack 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpack(Path buildpack) {
      this.buildpack = Objects.requireNonNull(buildpack, "buildpack");
      initBits &= ~INIT_BIT_BUILDPACK;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateBuildpackRequest#getEnable() enable} attribute.
     * @param enable The value for enable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enable(@Nullable Boolean enable) {
      this.enable = enable;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateBuildpackRequest#getFileName() fileName} attribute.
     * @param fileName The value for fileName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder fileName(String fileName) {
      this.fileName = Objects.requireNonNull(fileName, "fileName");
      initBits &= ~INIT_BIT_FILE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateBuildpackRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateBuildpackRequest#getPosition() position} attribute.
     * @param position The value for position 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder position(Integer position) {
      this.position = Objects.requireNonNull(position, "position");
      initBits &= ~INIT_BIT_POSITION;
      return this;
    }

    /**
     * Builds a new {@link CreateBuildpackRequest CreateBuildpackRequest}.
     * @return An immutable instance of CreateBuildpackRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateBuildpackRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateBuildpackRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_BUILDPACK) != 0) attributes.add("buildpack");
      if ((initBits & INIT_BIT_FILE_NAME) != 0) attributes.add("fileName");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_POSITION) != 0) attributes.add("position");
      return "Cannot build CreateBuildpackRequest, some of required attributes are not set " + attributes;
    }
  }
}
