package org.cloudfoundry.operations.domains;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Domain object representation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Domain"})
public final class Domain extends org.cloudfoundry.operations.domains._Domain {
  private final String id;
  private final String name;
  private final Status status;

  private Domain(Domain.Builder builder) {
    this.id = builder.id;
    this.name = builder.name;
    this.status = builder.status;
  }

  /**
   * The id of the domain
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The name of the domain
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The status of the domain indicating shared or private domain
   */
  @Override
  public Status getStatus() {
    return status;
  }

  /**
   * This instance is equal to all instances of {@code Domain} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Domain
        && equalTo((Domain) another);
  }

  private boolean equalTo(Domain another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && status.equals(another.status);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code status}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + status.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Domain} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Domain{"
        + "id=" + id
        + ", name=" + name
        + ", status=" + status
        + "}";
  }

  /**
   * Creates a builder for {@link Domain Domain}.
   * @return A new Domain builder
   */
  public static Domain.Builder builder() {
    return new Domain.Builder();
  }

  /**
   * Builds instances of type {@link Domain Domain}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_STATUS = 0x4L;
    private long initBits = 0x7L;

    private String id;
    private String name;
    private Status status;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Domain} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Domain instance) {
      return from((_Domain) instance);
    }

    /**
     * Copy abstract value type {@code _Domain} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Domain instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      name(instance.getName());
      status(instance.getStatus());
      return this;
    }

    /**
     * Initializes the value for the {@link _Domain#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _Domain#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _Domain#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder status(Status status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Builds a new {@link Domain Domain}.
     * @return An immutable instance of Domain
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Domain build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Domain(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build Domain, some of required attributes are not set " + attributes;
    }
  }
}
