package org.cloudfoundry.operations.spaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.client.v2.securitygroups.Protocol;

/**
 * Immutable implementation of {@link _Rule}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Rule.builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Rule"})
public final class Rule extends org.cloudfoundry.operations.spaces._Rule {
  private final String destination;
  private final String ports;
  private final Protocol protocol;

  private Rule(Rule.Builder builder) {
    this.destination = builder.destination;
    this.ports = builder.ports;
    this.protocol = builder.protocol;
  }

  /**
   * The destination
   */
  @Override
  public String getDestination() {
    return destination;
  }

  /**
   * The ports
   */
  @Override
  public String getPorts() {
    return ports;
  }

  /**
   * The protocol
   */
  @Override
  public Protocol getProtocol() {
    return protocol;
  }

  /**
   * This instance is equal to all instances of {@code Rule} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Rule
        && equalTo((Rule) another);
  }

  private boolean equalTo(Rule another) {
    return destination.equals(another.destination)
        && ports.equals(another.ports)
        && protocol.equals(another.protocol);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code ports}, {@code protocol}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + destination.hashCode();
    h = h * 17 + ports.hashCode();
    h = h * 17 + protocol.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Rule} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Rule{"
        + "destination=" + destination
        + ", ports=" + ports
        + ", protocol=" + protocol
        + "}";
  }

  /**
   * Creates a builder for {@link Rule Rule}.
   * @return A new Rule builder
   */
  public static Rule.Builder builder() {
    return new Rule.Builder();
  }

  /**
   * Builds instances of type {@link Rule Rule}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DESTINATION = 0x1L;
    private static final long INIT_BIT_PORTS = 0x2L;
    private static final long INIT_BIT_PROTOCOL = 0x4L;
    private long initBits = 0x7L;

    private String destination;
    private String ports;
    private Protocol protocol;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Rule} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Rule instance) {
      return from((_Rule) instance);
    }

    /**
     * Copy abstract value type {@code _Rule} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Rule instance) {
      Objects.requireNonNull(instance, "instance");
      destination(instance.getDestination());
      ports(instance.getPorts());
      protocol(instance.getProtocol());
      return this;
    }

    /**
     * Initializes the value for the {@link _Rule#getDestination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destination(String destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link _Rule#getPorts() ports} attribute.
     * @param ports The value for ports 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ports(String ports) {
      this.ports = Objects.requireNonNull(ports, "ports");
      initBits &= ~INIT_BIT_PORTS;
      return this;
    }

    /**
     * Initializes the value for the {@link _Rule#getProtocol() protocol} attribute.
     * @param protocol The value for protocol 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder protocol(Protocol protocol) {
      this.protocol = Objects.requireNonNull(protocol, "protocol");
      initBits &= ~INIT_BIT_PROTOCOL;
      return this;
    }

    /**
     * Builds a new {@link Rule Rule}.
     * @return An immutable instance of Rule
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Rule build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Rule(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      if ((initBits & INIT_BIT_PORTS) != 0) attributes.add("ports");
      if ((initBits & INIT_BIT_PROTOCOL) != 0) attributes.add("protocol");
      return "Cannot build Rule, some of required attributes are not set " + attributes;
    }
  }
}
