package org.cloudfoundry.operations.domains;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request options for the create domain operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_CreateDomainRequest", generator = "Immutables")
public final class CreateDomainRequest extends org.cloudfoundry.operations.domains._CreateDomainRequest {
  private final String domain;
  private final String organization;

  private CreateDomainRequest(CreateDomainRequest.Builder builder) {
    this.domain = builder.domain;
    this.organization = builder.organization;
  }

  /**
   * The domain name
   */
  @Override
  public String getDomain() {
    return domain;
  }

  /**
   * The organization name of the domain
   */
  @Override
  public String getOrganization() {
    return organization;
  }

  /**
   * This instance is equal to all instances of {@code CreateDomainRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateDomainRequest
        && equalTo((CreateDomainRequest) another);
  }

  private boolean equalTo(CreateDomainRequest another) {
    return domain.equals(another.domain)
        && organization.equals(another.organization);
  }

  /**
   * Computes a hash code from attributes: {@code domain}, {@code organization}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + domain.hashCode();
    h += (h << 5) + organization.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateDomainRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateDomainRequest{"
        + "domain=" + domain
        + ", organization=" + organization
        + "}";
  }

  /**
   * Creates a builder for {@link CreateDomainRequest CreateDomainRequest}.
   * @return A new CreateDomainRequest builder
   */
  public static CreateDomainRequest.Builder builder() {
    return new CreateDomainRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateDomainRequest CreateDomainRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN = 0x1L;
    private static final long INIT_BIT_ORGANIZATION = 0x2L;
    private long initBits = 0x3L;

    private String domain;
    private String organization;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateDomainRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateDomainRequest instance) {
      return from((_CreateDomainRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateDomainRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateDomainRequest instance) {
      Objects.requireNonNull(instance, "instance");
      domain(instance.getDomain());
      organization(instance.getOrganization());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateDomainRequest#getDomain() domain} attribute.
     * @param domain The value for domain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String domain) {
      this.domain = Objects.requireNonNull(domain, "domain");
      initBits &= ~INIT_BIT_DOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateDomainRequest#getOrganization() organization} attribute.
     * @param organization The value for organization 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organization(String organization) {
      this.organization = Objects.requireNonNull(organization, "organization");
      initBits &= ~INIT_BIT_ORGANIZATION;
      return this;
    }

    /**
     * Builds a new {@link CreateDomainRequest CreateDomainRequest}.
     * @return An immutable instance of CreateDomainRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateDomainRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateDomainRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOMAIN) != 0) attributes.add("domain");
      if ((initBits & INIT_BIT_ORGANIZATION) != 0) attributes.add("organization");
      return "Cannot build CreateDomainRequest, some of required attributes are not set " + attributes;
    }
  }
}
