package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request options for the get application operation
 */
@Generated(from = "_GetApplicationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetApplicationRequest
    extends org.cloudfoundry.operations.applications._GetApplicationRequest {
  private final String name;

  private GetApplicationRequest(GetApplicationRequest.Builder builder) {
    this.name = builder.name;
  }

  /**
   * The application name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code GetApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetApplicationRequest
        && equalTo((GetApplicationRequest) another);
  }

  private boolean equalTo(GetApplicationRequest another) {
    return name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetApplicationRequest{"
        + "name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link GetApplicationRequest GetApplicationRequest}.
   * @return A new GetApplicationRequest builder
   */
  public static GetApplicationRequest.Builder builder() {
    return new GetApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetApplicationRequest GetApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetApplicationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetApplicationRequest instance) {
      return from((_GetApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link GetApplicationRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link GetApplicationRequest GetApplicationRequest}.
     * @return An immutable instance of GetApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build GetApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
