package org.cloudfoundry.operations.applications;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the push application operation
 */
@Generated(from = "_PushApplicationManifestRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class PushApplicationManifestRequest
    extends org.cloudfoundry.operations.applications._PushApplicationManifestRequest {
  private final @Nullable String dockerPassword;
  private final @Nullable String dockerUsername;
  private final List<ApplicationManifest> manifests;
  private final @Nullable Boolean noStart;
  private final Duration stagingTimeout;
  private final Duration startupTimeout;

  private PushApplicationManifestRequest(PushApplicationManifestRequest.Builder builder) {
    this.dockerPassword = builder.dockerPassword;
    this.dockerUsername = builder.dockerUsername;
    this.manifests = createUnmodifiableList(true, builder.manifests);
    this.noStart = builder.noStart;
    if (builder.stagingTimeout != null) {
      initShim.stagingTimeout(builder.stagingTimeout);
    }
    if (builder.startupTimeout != null) {
      initShim.startupTimeout(builder.startupTimeout);
    }
    this.stagingTimeout = initShim.getStagingTimeout();
    this.startupTimeout = initShim.getStartupTimeout();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "_PushApplicationManifestRequest", generator = "Immutables")
  private final class InitShim {
    private byte stagingTimeoutBuildStage = STAGE_UNINITIALIZED;
    private Duration stagingTimeout;

    Duration getStagingTimeout() {
      if (stagingTimeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (stagingTimeoutBuildStage == STAGE_UNINITIALIZED) {
        stagingTimeoutBuildStage = STAGE_INITIALIZING;
        this.stagingTimeout = Objects.requireNonNull(PushApplicationManifestRequest.super.getStagingTimeout(), "stagingTimeout");
        stagingTimeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.stagingTimeout;
    }

    void stagingTimeout(Duration stagingTimeout) {
      this.stagingTimeout = stagingTimeout;
      stagingTimeoutBuildStage = STAGE_INITIALIZED;
    }

    private byte startupTimeoutBuildStage = STAGE_UNINITIALIZED;
    private Duration startupTimeout;

    Duration getStartupTimeout() {
      if (startupTimeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (startupTimeoutBuildStage == STAGE_UNINITIALIZED) {
        startupTimeoutBuildStage = STAGE_INITIALIZING;
        this.startupTimeout = Objects.requireNonNull(PushApplicationManifestRequest.super.getStartupTimeout(), "startupTimeout");
        startupTimeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.startupTimeout;
    }

    void startupTimeout(Duration startupTimeout) {
      this.startupTimeout = startupTimeout;
      startupTimeoutBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (stagingTimeoutBuildStage == STAGE_INITIALIZING) attributes.add("stagingTimeout");
      if (startupTimeoutBuildStage == STAGE_INITIALIZING) attributes.add("startupTimeout");
      return "Cannot build PushApplicationManifestRequest, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * The Docker repository password
   */
  @Override
  public @Nullable String getDockerPassword() {
    return dockerPassword;
  }

  /**
   * The Docker repository username
   */
  @Override
  public @Nullable String getDockerUsername() {
    return dockerUsername;
  }

  /**
   * The manifests to be pushed
   */
  @Override
  public List<ApplicationManifest> getManifests() {
    return manifests;
  }

  /**
   * Do not start the application after pushing
   */
  @Override
  public @Nullable Boolean getNoStart() {
    return noStart;
  }

  /**
   * How long to wait for staging
   */
  @Override
  public Duration getStagingTimeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getStagingTimeout()
        : this.stagingTimeout;
  }

  /**
   * How long to wait for startup
   */
  @Override
  public Duration getStartupTimeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getStartupTimeout()
        : this.startupTimeout;
  }

  /**
   * This instance is equal to all instances of {@code PushApplicationManifestRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof PushApplicationManifestRequest
        && equalTo((PushApplicationManifestRequest) another);
  }

  private boolean equalTo(PushApplicationManifestRequest another) {
    return Objects.equals(dockerPassword, another.dockerPassword)
        && Objects.equals(dockerUsername, another.dockerUsername)
        && manifests.equals(another.manifests)
        && Objects.equals(noStart, another.noStart)
        && stagingTimeout.equals(another.stagingTimeout)
        && startupTimeout.equals(another.startupTimeout);
  }

  /**
   * Computes a hash code from attributes: {@code dockerPassword}, {@code dockerUsername}, {@code manifests}, {@code noStart}, {@code stagingTimeout}, {@code startupTimeout}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(dockerPassword);
    h += (h << 5) + Objects.hashCode(dockerUsername);
    h += (h << 5) + manifests.hashCode();
    h += (h << 5) + Objects.hashCode(noStart);
    h += (h << 5) + stagingTimeout.hashCode();
    h += (h << 5) + startupTimeout.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PushApplicationManifestRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PushApplicationManifestRequest{"
        + "dockerPassword=" + dockerPassword
        + ", dockerUsername=" + dockerUsername
        + ", manifests=" + manifests
        + ", noStart=" + noStart
        + ", stagingTimeout=" + stagingTimeout
        + ", startupTimeout=" + startupTimeout
        + "}";
  }


  private static PushApplicationManifestRequest validate(PushApplicationManifestRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link PushApplicationManifestRequest PushApplicationManifestRequest}.
   * @return A new PushApplicationManifestRequest builder
   */
  public static PushApplicationManifestRequest.Builder builder() {
    return new PushApplicationManifestRequest.Builder();
  }

  /**
   * Builds instances of type {@link PushApplicationManifestRequest PushApplicationManifestRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_PushApplicationManifestRequest", generator = "Immutables")
  public static final class Builder {
    private String dockerPassword;
    private String dockerUsername;
    private List<ApplicationManifest> manifests = new ArrayList<ApplicationManifest>();
    private Boolean noStart;
    private Duration stagingTimeout;
    private Duration startupTimeout;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PushApplicationManifestRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PushApplicationManifestRequest instance) {
      return from((_PushApplicationManifestRequest) instance);
    }

    /**
     * Copy abstract value type {@code _PushApplicationManifestRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_PushApplicationManifestRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String dockerPasswordValue = instance.getDockerPassword();
      if (dockerPasswordValue != null) {
        dockerPassword(dockerPasswordValue);
      }
      String dockerUsernameValue = instance.getDockerUsername();
      if (dockerUsernameValue != null) {
        dockerUsername(dockerUsernameValue);
      }
      addAllManifests(instance.getManifests());
      Boolean noStartValue = instance.getNoStart();
      if (noStartValue != null) {
        noStart(noStartValue);
      }
      stagingTimeout(instance.getStagingTimeout());
      startupTimeout(instance.getStartupTimeout());
      return this;
    }

    /**
     * Initializes the value for the {@link PushApplicationManifestRequest#getDockerPassword() dockerPassword} attribute.
     * @param dockerPassword The value for dockerPassword (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dockerPassword(@Nullable String dockerPassword) {
      this.dockerPassword = dockerPassword;
      return this;
    }

    /**
     * Initializes the value for the {@link PushApplicationManifestRequest#getDockerUsername() dockerUsername} attribute.
     * @param dockerUsername The value for dockerUsername (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dockerUsername(@Nullable String dockerUsername) {
      this.dockerUsername = dockerUsername;
      return this;
    }

    /**
     * Adds one element to {@link PushApplicationManifestRequest#getManifests() manifests} list.
     * @param element A manifests element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder manifest(ApplicationManifest element) {
      this.manifests.add(Objects.requireNonNull(element, "manifests element"));
      return this;
    }

    /**
     * Adds elements to {@link PushApplicationManifestRequest#getManifests() manifests} list.
     * @param elements An array of manifests elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder manifests(ApplicationManifest... elements) {
      for (ApplicationManifest element : elements) {
        this.manifests.add(Objects.requireNonNull(element, "manifests element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PushApplicationManifestRequest#getManifests() manifests} list.
     * @param elements An iterable of manifests elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder manifests(Iterable<? extends ApplicationManifest> elements) {
      this.manifests.clear();
      return addAllManifests(elements);
    }

    /**
     * Adds elements to {@link PushApplicationManifestRequest#getManifests() manifests} list.
     * @param elements An iterable of manifests elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllManifests(Iterable<? extends ApplicationManifest> elements) {
      for (ApplicationManifest element : elements) {
        this.manifests.add(Objects.requireNonNull(element, "manifests element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link PushApplicationManifestRequest#getNoStart() noStart} attribute.
     * @param noStart The value for noStart (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder noStart(@Nullable Boolean noStart) {
      this.noStart = noStart;
      return this;
    }

    /**
     * Initializes the value for the {@link PushApplicationManifestRequest#getStagingTimeout() stagingTimeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link PushApplicationManifestRequest#getStagingTimeout() stagingTimeout}.</em>
     * @param stagingTimeout The value for stagingTimeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingTimeout(Duration stagingTimeout) {
      this.stagingTimeout = Objects.requireNonNull(stagingTimeout, "stagingTimeout");
      return this;
    }

    /**
     * Initializes the value for the {@link PushApplicationManifestRequest#getStartupTimeout() startupTimeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link PushApplicationManifestRequest#getStartupTimeout() startupTimeout}.</em>
     * @param startupTimeout The value for startupTimeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startupTimeout(Duration startupTimeout) {
      this.startupTimeout = Objects.requireNonNull(startupTimeout, "startupTimeout");
      return this;
    }

    /**
     * Builds a new {@link PushApplicationManifestRequest PushApplicationManifestRequest}.
     * @return An immutable instance of PushApplicationManifestRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public PushApplicationManifestRequest build() {
      return PushApplicationManifestRequest.validate(new PushApplicationManifestRequest(this));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
