package org.cloudfoundry.operations.routes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the create route operation
 */
@Generated(from = "_CreateRouteRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateRouteRequest extends org.cloudfoundry.operations.routes._CreateRouteRequest {
  private final String domain;
  private final @Nullable String host;
  private final @Nullable String path;
  private final @Nullable Integer port;
  private final @Nullable Boolean randomPort;
  private final String space;

  private CreateRouteRequest(CreateRouteRequest.Builder builder) {
    this.domain = builder.domain;
    this.host = builder.host;
    this.path = builder.path;
    this.port = builder.port;
    this.randomPort = builder.randomPort;
    this.space = builder.space;
  }

  /**
   * The domain of the route
   */
  @Override
  public String getDomain() {
    return domain;
  }

  /**
   * The host name of the route
   */
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The path of the route
   */
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * The port of the route
   */
  @Override
  public @Nullable Integer getPort() {
    return port;
  }

  /**
   * Generate a random port
   */
  @Override
  public @Nullable Boolean getRandomPort() {
    return randomPort;
  }

  /**
   * The space to create the route in
   */
  @Override
  public String getSpace() {
    return space;
  }

  /**
   * This instance is equal to all instances of {@code CreateRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateRouteRequest
        && equalTo((CreateRouteRequest) another);
  }

  private boolean equalTo(CreateRouteRequest another) {
    return domain.equals(another.domain)
        && Objects.equals(host, another.host)
        && Objects.equals(path, another.path)
        && Objects.equals(port, another.port)
        && Objects.equals(randomPort, another.randomPort)
        && space.equals(another.space);
  }

  /**
   * Computes a hash code from attributes: {@code domain}, {@code host}, {@code path}, {@code port}, {@code randomPort}, {@code space}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + domain.hashCode();
    h += (h << 5) + Objects.hashCode(host);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + Objects.hashCode(randomPort);
    h += (h << 5) + space.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateRouteRequest{"
        + "domain=" + domain
        + ", host=" + host
        + ", path=" + path
        + ", port=" + port
        + ", randomPort=" + randomPort
        + ", space=" + space
        + "}";
  }


  private static CreateRouteRequest validate(CreateRouteRequest instance) {
    instance.checkSetup();
    instance.checkPorts();
    return instance;
  }

  /**
   * Creates a builder for {@link CreateRouteRequest CreateRouteRequest}.
   * @return A new CreateRouteRequest builder
   */
  public static CreateRouteRequest.Builder builder() {
    return new CreateRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateRouteRequest CreateRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateRouteRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN = 0x1L;
    private static final long INIT_BIT_SPACE = 0x2L;
    private long initBits = 0x3L;

    private String domain;
    private String host;
    private String path;
    private Integer port;
    private Boolean randomPort;
    private String space;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateRouteRequest instance) {
      return from((_CreateRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      domain(instance.getDomain());
      String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      Integer portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      Boolean randomPortValue = instance.getRandomPort();
      if (randomPortValue != null) {
        randomPort(randomPortValue);
      }
      space(instance.getSpace());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRouteRequest#getDomain() domain} attribute.
     * @param domain The value for domain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String domain) {
      this.domain = Objects.requireNonNull(domain, "domain");
      initBits &= ~INIT_BIT_DOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRouteRequest#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRouteRequest#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRouteRequest#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRouteRequest#getRandomPort() randomPort} attribute.
     * @param randomPort The value for randomPort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder randomPort(@Nullable Boolean randomPort) {
      this.randomPort = randomPort;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRouteRequest#getSpace() space} attribute.
     * @param space The value for space 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder space(String space) {
      this.space = Objects.requireNonNull(space, "space");
      initBits &= ~INIT_BIT_SPACE;
      return this;
    }

    /**
     * Builds a new {@link CreateRouteRequest CreateRouteRequest}.
     * @return An immutable instance of CreateRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return CreateRouteRequest.validate(new CreateRouteRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOMAIN) != 0) attributes.add("domain");
      if ((initBits & INIT_BIT_SPACE) != 0) attributes.add("space");
      return "Cannot build CreateRouteRequest, some of required attributes are not set " + attributes;
    }
  }
}
