package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the create service key operation
 */
@Generated(from = "_CreateServiceKeyRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateServiceKeyRequest
    extends org.cloudfoundry.operations.services._CreateServiceKeyRequest {
  private final @Nullable Map<String, Object> parameters;
  private final String serviceInstanceName;
  private final String serviceKeyName;

  private CreateServiceKeyRequest(CreateServiceKeyRequest.Builder builder) {
    this.parameters = builder.parameters == null ? null : createUnmodifiableMap(false, false, builder.parameters);
    this.serviceInstanceName = builder.serviceInstanceName;
    this.serviceKeyName = builder.serviceKeyName;
  }

  /**
   * The parameters of the service key
   */
  @Override
  public @Nullable Map<String, Object> getParameters() {
    return parameters;
  }

  /**
   * The name of the service instance
   */
  @Override
  public String getServiceInstanceName() {
    return serviceInstanceName;
  }

  /**
   * The name of the service key to create
   */
  @Override
  public String getServiceKeyName() {
    return serviceKeyName;
  }

  /**
   * This instance is equal to all instances of {@code CreateServiceKeyRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateServiceKeyRequest
        && equalTo((CreateServiceKeyRequest) another);
  }

  private boolean equalTo(CreateServiceKeyRequest another) {
    return Objects.equals(parameters, another.parameters)
        && serviceInstanceName.equals(another.serviceInstanceName)
        && serviceKeyName.equals(another.serviceKeyName);
  }

  /**
   * Computes a hash code from attributes: {@code parameters}, {@code serviceInstanceName}, {@code serviceKeyName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(parameters);
    h += (h << 5) + serviceInstanceName.hashCode();
    h += (h << 5) + serviceKeyName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateServiceKeyRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateServiceKeyRequest{"
        + "parameters=" + parameters
        + ", serviceInstanceName=" + serviceInstanceName
        + ", serviceKeyName=" + serviceKeyName
        + "}";
  }

  /**
   * Creates a builder for {@link CreateServiceKeyRequest CreateServiceKeyRequest}.
   * @return A new CreateServiceKeyRequest builder
   */
  public static CreateServiceKeyRequest.Builder builder() {
    return new CreateServiceKeyRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateServiceKeyRequest CreateServiceKeyRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateServiceKeyRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_INSTANCE_NAME = 0x1L;
    private static final long INIT_BIT_SERVICE_KEY_NAME = 0x2L;
    private long initBits = 0x3L;

    private Map<String, Object> parameters = null;
    private String serviceInstanceName;
    private String serviceKeyName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateServiceKeyRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateServiceKeyRequest instance) {
      return from((_CreateServiceKeyRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateServiceKeyRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateServiceKeyRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Map<String, Object> parametersValue = instance.getParameters();
      if (parametersValue != null) {
        putAllParameters(parametersValue);
      }
      serviceInstanceName(instance.getServiceInstanceName());
      serviceKeyName(instance.getServiceKeyName());
      return this;
    }

    /**
     * Put one entry to the {@link CreateServiceKeyRequest#getParameters() parameters} map.
     * @param key The key in the parameters map
     * @param value The associated value in the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(String key, Object value) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      this.parameters.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CreateServiceKeyRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.parameters.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CreateServiceKeyRequest#getParameters() parameters} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameters(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.parameters = null;
        return this;
      }
      this.parameters = new LinkedHashMap<String, Object>();
      return putAllParameters(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CreateServiceKeyRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllParameters(Map<String, ? extends Object> entries) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.parameters.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceKeyRequest#getServiceInstanceName() serviceInstanceName} attribute.
     * @param serviceInstanceName The value for serviceInstanceName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceName(String serviceInstanceName) {
      this.serviceInstanceName = Objects.requireNonNull(serviceInstanceName, "serviceInstanceName");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateServiceKeyRequest#getServiceKeyName() serviceKeyName} attribute.
     * @param serviceKeyName The value for serviceKeyName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceKeyName(String serviceKeyName) {
      this.serviceKeyName = Objects.requireNonNull(serviceKeyName, "serviceKeyName");
      initBits &= ~INIT_BIT_SERVICE_KEY_NAME;
      return this;
    }

    /**
     * Builds a new {@link CreateServiceKeyRequest CreateServiceKeyRequest}.
     * @return An immutable instance of CreateServiceKeyRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateServiceKeyRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateServiceKeyRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_NAME) != 0) attributes.add("serviceInstanceName");
      if ((initBits & INIT_BIT_SERVICE_KEY_NAME) != 0) attributes.add("serviceKeyName");
      return "Cannot build CreateServiceKeyRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
