package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request options for the rename service instance operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_RenameServiceInstanceRequest"})
public final class RenameServiceInstanceRequest
    extends org.cloudfoundry.operations.services._RenameServiceInstanceRequest {
  private final String name;
  private final String newName;

  private RenameServiceInstanceRequest(RenameServiceInstanceRequest.Builder builder) {
    this.name = builder.name;
    this.newName = builder.newName;
  }

  /**
   * The name of the service instance
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The new name of the service instance
   */
  @Override
  public String getNewName() {
    return newName;
  }

  /**
   * This instance is equal to all instances of {@code RenameServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RenameServiceInstanceRequest
        && equalTo((RenameServiceInstanceRequest) another);
  }

  private boolean equalTo(RenameServiceInstanceRequest another) {
    return name.equals(another.name)
        && newName.equals(another.newName);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code newName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + newName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RenameServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RenameServiceInstanceRequest{"
        + "name=" + name
        + ", newName=" + newName
        + "}";
  }

  /**
   * Creates a builder for {@link RenameServiceInstanceRequest RenameServiceInstanceRequest}.
   * @return A new RenameServiceInstanceRequest builder
   */
  public static RenameServiceInstanceRequest.Builder builder() {
    return new RenameServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link RenameServiceInstanceRequest RenameServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_NEW_NAME = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private String newName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RenameServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RenameServiceInstanceRequest instance) {
      return from((_RenameServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RenameServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RenameServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      newName(instance.getNewName());
      return this;
    }

    /**
     * Initializes the value for the {@link _RenameServiceInstanceRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _RenameServiceInstanceRequest#getNewName() newName} attribute.
     * @param newName The value for newName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder newName(String newName) {
      this.newName = Objects.requireNonNull(newName, "newName");
      initBits &= ~INIT_BIT_NEW_NAME;
      return this;
    }

    /**
     * Builds a new {@link RenameServiceInstanceRequest RenameServiceInstanceRequest}.
     * @return An immutable instance of RenameServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RenameServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RenameServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_NEW_NAME) != 0) attributes.add("newName");
      return "Cannot build RenameServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }
}
