package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * A Cloud Foundry Service Offering
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ServiceOffering"})
public final class ServiceOffering extends org.cloudfoundry.operations.services._ServiceOffering {
  private final String description;
  private final String id;
  private final String label;
  private final List<ServicePlan> servicePlans;

  private ServiceOffering(ServiceOffering.Builder builder) {
    this.description = builder.description;
    this.id = builder.id;
    this.label = builder.label;
    this.servicePlans = createUnmodifiableList(true, builder.servicePlans);
  }

  /**
   * The description
   */
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The label
   */
  @Override
  public String getLabel() {
    return label;
  }

  /**
   * The service plans
   */
  @Override
  public List<ServicePlan> getServicePlans() {
    return servicePlans;
  }

  /**
   * This instance is equal to all instances of {@code ServiceOffering} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceOffering
        && equalTo((ServiceOffering) another);
  }

  private boolean equalTo(ServiceOffering another) {
    return description.equals(another.description)
        && id.equals(another.id)
        && label.equals(another.label)
        && servicePlans.equals(another.servicePlans);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code id}, {@code label}, {@code servicePlans}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + description.hashCode();
    h = h * 17 + id.hashCode();
    h = h * 17 + label.hashCode();
    h = h * 17 + servicePlans.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceOffering} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceOffering{"
        + "description=" + description
        + ", id=" + id
        + ", label=" + label
        + ", servicePlans=" + servicePlans
        + "}";
  }

  /**
   * Creates a builder for {@link ServiceOffering ServiceOffering}.
   * @return A new ServiceOffering builder
   */
  public static ServiceOffering.Builder builder() {
    return new ServiceOffering.Builder();
  }

  /**
   * Builds instances of type {@link ServiceOffering ServiceOffering}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DESCRIPTION = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_LABEL = 0x4L;
    private long initBits = 0x7L;

    private String description;
    private String id;
    private String label;
    private List<ServicePlan> servicePlans = new ArrayList<ServicePlan>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceOffering} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceOffering instance) {
      return from((_ServiceOffering) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceOffering} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceOffering instance) {
      Objects.requireNonNull(instance, "instance");
      description(instance.getDescription());
      id(instance.getId());
      label(instance.getLabel());
      addAllServicePlans(instance.getServicePlans());
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceOffering#getDescription() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceOffering#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceOffering#getLabel() label} attribute.
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      initBits &= ~INIT_BIT_LABEL;
      return this;
    }

    /**
     * Adds one element to {@link _ServiceOffering#getServicePlans() servicePlans} list.
     * @param element A servicePlans element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlan(ServicePlan element) {
      this.servicePlans.add(Objects.requireNonNull(element, "servicePlans element"));
      return this;
    }

    /**
     * Adds elements to {@link _ServiceOffering#getServicePlans() servicePlans} list.
     * @param elements An array of servicePlans elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlan(ServicePlan... elements) {
      for (ServicePlan element : elements) {
        this.servicePlans.add(Objects.requireNonNull(element, "servicePlans element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ServiceOffering#getServicePlans() servicePlans} list.
     * @param elements An iterable of servicePlans elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlans(Iterable<? extends ServicePlan> elements) {
      this.servicePlans.clear();
      return addAllServicePlans(elements);
    }

    /**
     * Adds elements to {@link _ServiceOffering#getServicePlans() servicePlans} list.
     * @param elements An iterable of servicePlans elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServicePlans(Iterable<? extends ServicePlan> elements) {
      for (ServicePlan element : elements) {
        this.servicePlans.add(Objects.requireNonNull(element, "servicePlans element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ServiceOffering ServiceOffering}.
     * @return An immutable instance of ServiceOffering
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceOffering build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ServiceOffering(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_LABEL) != 0) attributes.add("label");
      return "Cannot build ServiceOffering, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
