package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * A Cloud Foundry Service Plan
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ServicePlan"})
public final class ServicePlan extends org.cloudfoundry.operations.services._ServicePlan {
  private final String description;
  private final Boolean free;
  private final String id;
  private final String name;

  private ServicePlan(ServicePlan.Builder builder) {
    this.description = builder.description;
    this.free = builder.free;
    this.id = builder.id;
    this.name = builder.name;
  }

  /**
   * The description
   */
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * Whether the plan is free
   */
  @Override
  public Boolean getFree() {
    return free;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code ServicePlan} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServicePlan
        && equalTo((ServicePlan) another);
  }

  private boolean equalTo(ServicePlan another) {
    return description.equals(another.description)
        && free.equals(another.free)
        && id.equals(another.id)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code free}, {@code id}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + description.hashCode();
    h = h * 17 + free.hashCode();
    h = h * 17 + id.hashCode();
    h = h * 17 + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ServicePlan} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServicePlan{"
        + "description=" + description
        + ", free=" + free
        + ", id=" + id
        + ", name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link ServicePlan ServicePlan}.
   * @return A new ServicePlan builder
   */
  public static ServicePlan.Builder builder() {
    return new ServicePlan.Builder();
  }

  /**
   * Builds instances of type {@link ServicePlan ServicePlan}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DESCRIPTION = 0x1L;
    private static final long INIT_BIT_FREE = 0x2L;
    private static final long INIT_BIT_ID = 0x4L;
    private static final long INIT_BIT_NAME = 0x8L;
    private long initBits = 0xfL;

    private String description;
    private Boolean free;
    private String id;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServicePlan} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServicePlan instance) {
      return from((_ServicePlan) instance);
    }

    /**
     * Copy abstract value type {@code _ServicePlan} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServicePlan instance) {
      Objects.requireNonNull(instance, "instance");
      description(instance.getDescription());
      free(instance.getFree());
      id(instance.getId());
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link _ServicePlan#getDescription() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServicePlan#getFree() free} attribute.
     * @param free The value for free 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder free(Boolean free) {
      this.free = Objects.requireNonNull(free, "free");
      initBits &= ~INIT_BIT_FREE;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServicePlan#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServicePlan#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link ServicePlan ServicePlan}.
     * @return An immutable instance of ServicePlan
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServicePlan build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ServicePlan(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_FREE) != 0) attributes.add("free");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build ServicePlan, some of required attributes are not set " + attributes;
    }
  }
}
