package org.cloudfoundry.operations.applications;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request options for the restart application operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_RestartApplicationRequest"})
public final class RestartApplicationRequest
    extends org.cloudfoundry.operations.applications._RestartApplicationRequest {
  private final String name;
  private final @Nullable Duration stagingTimeout;
  private final @Nullable Duration startupTimeout;

  private RestartApplicationRequest(RestartApplicationRequest.Builder builder) {
    this.name = builder.name;
    this.stagingTimeout = builder.stagingTimeout;
    this.startupTimeout = builder.startupTimeout;
  }

  /**
   * The name of the application
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * How long to wait for staging
   */
  @Override
  public @Nullable Duration getStagingTimeout() {
    return stagingTimeout;
  }

  /**
   * How long to wait for startup
   */
  @Override
  public @Nullable Duration getStartupTimeout() {
    return startupTimeout;
  }

  /**
   * This instance is equal to all instances of {@code RestartApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RestartApplicationRequest
        && equalTo((RestartApplicationRequest) another);
  }

  private boolean equalTo(RestartApplicationRequest another) {
    return name.equals(another.name)
        && Objects.equals(stagingTimeout, another.stagingTimeout)
        && Objects.equals(startupTimeout, another.startupTimeout);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code stagingTimeout}, {@code startupTimeout}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + Objects.hashCode(stagingTimeout);
    h = h * 17 + Objects.hashCode(startupTimeout);
    return h;
  }

  /**
   * Prints the immutable value {@code RestartApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RestartApplicationRequest{"
        + "name=" + name
        + ", stagingTimeout=" + stagingTimeout
        + ", startupTimeout=" + startupTimeout
        + "}";
  }

  /**
   * Creates a builder for {@link RestartApplicationRequest RestartApplicationRequest}.
   * @return A new RestartApplicationRequest builder
   */
  public static RestartApplicationRequest.Builder builder() {
    return new RestartApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link RestartApplicationRequest RestartApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;
    private Duration stagingTimeout;
    private Duration startupTimeout;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RestartApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RestartApplicationRequest instance) {
      return from((_RestartApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RestartApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RestartApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      Duration stagingTimeoutValue = instance.getStagingTimeout();
      if (stagingTimeoutValue != null) {
        stagingTimeout(stagingTimeoutValue);
      }
      Duration startupTimeoutValue = instance.getStartupTimeout();
      if (startupTimeoutValue != null) {
        startupTimeout(startupTimeoutValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _RestartApplicationRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _RestartApplicationRequest#getStagingTimeout() stagingTimeout} attribute.
     * @param stagingTimeout The value for stagingTimeout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingTimeout(@Nullable Duration stagingTimeout) {
      this.stagingTimeout = stagingTimeout;
      return this;
    }

    /**
     * Initializes the value for the {@link _RestartApplicationRequest#getStartupTimeout() startupTimeout} attribute.
     * @param startupTimeout The value for startupTimeout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startupTimeout(@Nullable Duration startupTimeout) {
      this.startupTimeout = startupTimeout;
      return this;
    }

    /**
     * Builds a new {@link RestartApplicationRequest RestartApplicationRequest}.
     * @return An immutable instance of RestartApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RestartApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RestartApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build RestartApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
