package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request options for the get health check operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_SetApplicationHealthCheckRequest"})
public final class SetApplicationHealthCheckRequest
    extends org.cloudfoundry.operations.applications._SetApplicationHealthCheckRequest {
  private final String name;
  private final ApplicationHealthCheck type;

  private SetApplicationHealthCheckRequest(SetApplicationHealthCheckRequest.Builder builder) {
    this.name = builder.name;
    this.type = builder.type;
  }

  /**
   * The name of the application
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The health check type
   */
  @Override
  public ApplicationHealthCheck getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code SetApplicationHealthCheckRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SetApplicationHealthCheckRequest
        && equalTo((SetApplicationHealthCheckRequest) another);
  }

  private boolean equalTo(SetApplicationHealthCheckRequest another) {
    return name.equals(another.name)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SetApplicationHealthCheckRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SetApplicationHealthCheckRequest{"
        + "name=" + name
        + ", type=" + type
        + "}";
  }

  /**
   * Creates a builder for {@link SetApplicationHealthCheckRequest SetApplicationHealthCheckRequest}.
   * @return A new SetApplicationHealthCheckRequest builder
   */
  public static SetApplicationHealthCheckRequest.Builder builder() {
    return new SetApplicationHealthCheckRequest.Builder();
  }

  /**
   * Builds instances of type {@link SetApplicationHealthCheckRequest SetApplicationHealthCheckRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private ApplicationHealthCheck type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SetApplicationHealthCheckRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SetApplicationHealthCheckRequest instance) {
      return from((_SetApplicationHealthCheckRequest) instance);
    }

    /**
     * Copy abstract value type {@code _SetApplicationHealthCheckRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SetApplicationHealthCheckRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link _SetApplicationHealthCheckRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _SetApplicationHealthCheckRequest#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(ApplicationHealthCheck type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link SetApplicationHealthCheckRequest SetApplicationHealthCheckRequest}.
     * @return An immutable instance of SetApplicationHealthCheckRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SetApplicationHealthCheckRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new SetApplicationHealthCheckRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build SetApplicationHealthCheckRequest, some of required attributes are not set " + attributes;
    }
  }
}
