package org.cloudfoundry.operations.routes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request options for the map route operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_DeleteRouteRequest"})
public final class DeleteRouteRequest extends org.cloudfoundry.operations.routes._DeleteRouteRequest {
  private final String domain;
  private final @Nullable String host;
  private final @Nullable String path;
  private final @Nullable Integer port;

  private DeleteRouteRequest(DeleteRouteRequest.Builder builder) {
    this.domain = builder.domain;
    this.host = builder.host;
    this.path = builder.path;
    this.port = builder.port;
  }

  /**
   * The domain of the route
   */
  @Override
  public String getDomain() {
    return domain;
  }

  /**
   * The host of the route
   */
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The path of the route.
   * <p>
   * Note: the path is specified without a leading "/"
   */
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * The port of the route
   */
  @Override
  public @Nullable Integer getPort() {
    return port;
  }

  /**
   * This instance is equal to all instances of {@code DeleteRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteRouteRequest
        && equalTo((DeleteRouteRequest) another);
  }

  private boolean equalTo(DeleteRouteRequest another) {
    return domain.equals(another.domain)
        && Objects.equals(host, another.host)
        && Objects.equals(path, another.path)
        && Objects.equals(port, another.port);
  }

  /**
   * Computes a hash code from attributes: {@code domain}, {@code host}, {@code path}, {@code port}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + domain.hashCode();
    h = h * 17 + Objects.hashCode(host);
    h = h * 17 + Objects.hashCode(path);
    h = h * 17 + Objects.hashCode(port);
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteRouteRequest{"
        + "domain=" + domain
        + ", host=" + host
        + ", path=" + path
        + ", port=" + port
        + "}";
  }

  private static DeleteRouteRequest validate(DeleteRouteRequest instance) {
    instance.checkSetup();
    return instance;
  }

  /**
   * Creates a builder for {@link DeleteRouteRequest DeleteRouteRequest}.
   * @return A new DeleteRouteRequest builder
   */
  public static DeleteRouteRequest.Builder builder() {
    return new DeleteRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteRouteRequest DeleteRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN = 0x1L;
    private long initBits = 0x1L;

    private String domain;
    private String host;
    private String path;
    private Integer port;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteRouteRequest instance) {
      return from((_DeleteRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      domain(instance.getDomain());
      String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      Integer portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteRouteRequest#getDomain() domain} attribute.
     * @param domain The value for domain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String domain) {
      this.domain = Objects.requireNonNull(domain, "domain");
      initBits &= ~INIT_BIT_DOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteRouteRequest#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteRouteRequest#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteRouteRequest#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }

    /**
     * Builds a new {@link DeleteRouteRequest DeleteRouteRequest}.
     * @return An immutable instance of DeleteRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return DeleteRouteRequest.validate(new DeleteRouteRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DOMAIN) != 0) attributes.add("domain");
      return "Cannot build DeleteRouteRequest, some of required attributes are not set " + attributes;
    }
  }
}
