package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request options for the update user provided service instance operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateUserProvidedServiceInstanceRequest"})
public final class UpdateUserProvidedServiceInstanceRequest
    extends org.cloudfoundry.operations.services._UpdateUserProvidedServiceInstanceRequest {
  private final @Nullable Map<String, Object> credentials;
  private final @Nullable String syslogDrainUrl;
  private final String userProvidedServiceInstanceName;

  private UpdateUserProvidedServiceInstanceRequest(UpdateUserProvidedServiceInstanceRequest.Builder builder) {
    this.credentials = builder.credentials == null ? null : createUnmodifiableMap(false, false, builder.credentials);
    this.syslogDrainUrl = builder.syslogDrainUrl;
    this.userProvidedServiceInstanceName = builder.userProvidedServiceInstanceName;
  }

  /**
   * The credentials of the user provided service instance
   */
  @Override
  public @Nullable Map<String, Object> getCredentials() {
    return credentials;
  }

  /**
   * he url for the syslog_drain to direct to
   */
  @Override
  public @Nullable String getSyslogDrainUrl() {
    return syslogDrainUrl;
  }

  /**
   * The name of the user provided service instance
   */
  @Override
  public String getUserProvidedServiceInstanceName() {
    return userProvidedServiceInstanceName;
  }

  /**
   * This instance is equal to all instances of {@code UpdateUserProvidedServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateUserProvidedServiceInstanceRequest
        && equalTo((UpdateUserProvidedServiceInstanceRequest) another);
  }

  private boolean equalTo(UpdateUserProvidedServiceInstanceRequest another) {
    return Objects.equals(credentials, another.credentials)
        && Objects.equals(syslogDrainUrl, another.syslogDrainUrl)
        && userProvidedServiceInstanceName.equals(another.userProvidedServiceInstanceName);
  }

  /**
   * Computes a hash code from attributes: {@code credentials}, {@code syslogDrainUrl}, {@code userProvidedServiceInstanceName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(credentials);
    h = h * 17 + Objects.hashCode(syslogDrainUrl);
    h = h * 17 + userProvidedServiceInstanceName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateUserProvidedServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateUserProvidedServiceInstanceRequest{"
        + "credentials=" + credentials
        + ", syslogDrainUrl=" + syslogDrainUrl
        + ", userProvidedServiceInstanceName=" + userProvidedServiceInstanceName
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateUserProvidedServiceInstanceRequest UpdateUserProvidedServiceInstanceRequest}.
   * @return A new UpdateUserProvidedServiceInstanceRequest builder
   */
  public static UpdateUserProvidedServiceInstanceRequest.Builder builder() {
    return new UpdateUserProvidedServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateUserProvidedServiceInstanceRequest UpdateUserProvidedServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_NAME = 0x1L;
    private long initBits = 0x1L;

    private Map<String, Object> credentials = null;
    private String syslogDrainUrl;
    private String userProvidedServiceInstanceName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateUserProvidedServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateUserProvidedServiceInstanceRequest instance) {
      return from((_UpdateUserProvidedServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateUserProvidedServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateUserProvidedServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Map<String, Object> credentialsValue = instance.getCredentials();
      if (credentialsValue != null) {
        putAllCredentials(credentialsValue);
      }
      String syslogDrainUrlValue = instance.getSyslogDrainUrl();
      if (syslogDrainUrlValue != null) {
        syslogDrainUrl(syslogDrainUrlValue);
      }
      userProvidedServiceInstanceName(instance.getUserProvidedServiceInstanceName());
      return this;
    }

    /**
     * Put one entry to the {@link _UpdateUserProvidedServiceInstanceRequest#getCredentials() credentials} map.
     * @param key The key in the credentials map
     * @param value The associated value in the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(String key, Object value) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      this.credentials.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _UpdateUserProvidedServiceInstanceRequest#getCredentials() credentials} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(Map.Entry<String, ? extends Object> entry) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.credentials.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _UpdateUserProvidedServiceInstanceRequest#getCredentials() credentials} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param credentials The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credentials(@Nullable Map<String, ? extends Object> credentials) {
      if (credentials == null) {
        this.credentials = null;
        return this;
      }
      this.credentials = new LinkedHashMap<String, Object>();
      return putAllCredentials(credentials);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _UpdateUserProvidedServiceInstanceRequest#getCredentials() credentials} map. Nulls are not permitted
     * @param credentials The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCredentials(Map<String, ? extends Object> credentials) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : credentials.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.credentials.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateUserProvidedServiceInstanceRequest#getSyslogDrainUrl() syslogDrainUrl} attribute.
     * @param syslogDrainUrl The value for syslogDrainUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateUserProvidedServiceInstanceRequest#getUserProvidedServiceInstanceName() userProvidedServiceInstanceName} attribute.
     * @param userProvidedServiceInstanceName The value for userProvidedServiceInstanceName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userProvidedServiceInstanceName(String userProvidedServiceInstanceName) {
      this.userProvidedServiceInstanceName = Objects.requireNonNull(userProvidedServiceInstanceName, "userProvidedServiceInstanceName");
      initBits &= ~INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_NAME;
      return this;
    }

    /**
     * Builds a new {@link UpdateUserProvidedServiceInstanceRequest UpdateUserProvidedServiceInstanceRequest}.
     * @return An immutable instance of UpdateUserProvidedServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateUserProvidedServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateUserProvidedServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_NAME) != 0) attributes.add("userProvidedServiceInstanceName");
      return "Cannot build UpdateUserProvidedServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
