package org.cloudfoundry.operations.spaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request options for the delete space operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CreateSpaceRequest"})
public final class CreateSpaceRequest extends org.cloudfoundry.operations.spaces._CreateSpaceRequest {
  private final String name;
  private final @Nullable String organization;
  private final @Nullable String spaceQuota;

  private CreateSpaceRequest(CreateSpaceRequest.Builder builder) {
    this.name = builder.name;
    this.organization = builder.organization;
    this.spaceQuota = builder.spaceQuota;
  }

  /**
   * The name of the new space
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The organization of the new space
   */
  @Override
  public @Nullable String getOrganization() {
    return organization;
  }

  /**
   * The space quota definition of the new space
   */
  @Override
  public @Nullable String getSpaceQuota() {
    return spaceQuota;
  }

  /**
   * This instance is equal to all instances of {@code CreateSpaceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateSpaceRequest
        && equalTo((CreateSpaceRequest) another);
  }

  private boolean equalTo(CreateSpaceRequest another) {
    return name.equals(another.name)
        && Objects.equals(organization, another.organization)
        && Objects.equals(spaceQuota, another.spaceQuota);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code organization}, {@code spaceQuota}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + Objects.hashCode(organization);
    h = h * 17 + Objects.hashCode(spaceQuota);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateSpaceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateSpaceRequest{"
        + "name=" + name
        + ", organization=" + organization
        + ", spaceQuota=" + spaceQuota
        + "}";
  }

  /**
   * Creates a builder for {@link CreateSpaceRequest CreateSpaceRequest}.
   * @return A new CreateSpaceRequest builder
   */
  public static CreateSpaceRequest.Builder builder() {
    return new CreateSpaceRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateSpaceRequest CreateSpaceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;
    private String organization;
    private String spaceQuota;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateSpaceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateSpaceRequest instance) {
      return from((_CreateSpaceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateSpaceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateSpaceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      String organizationValue = instance.getOrganization();
      if (organizationValue != null) {
        organization(organizationValue);
      }
      String spaceQuotaValue = instance.getSpaceQuota();
      if (spaceQuotaValue != null) {
        spaceQuota(spaceQuotaValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateSpaceRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateSpaceRequest#getOrganization() organization} attribute.
     * @param organization The value for organization (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organization(@Nullable String organization) {
      this.organization = organization;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateSpaceRequest#getSpaceQuota() spaceQuota} attribute.
     * @param spaceQuota The value for spaceQuota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceQuota(@Nullable String spaceQuota) {
      this.spaceQuota = spaceQuota;
      return this;
    }

    /**
     * Builds a new {@link CreateSpaceRequest CreateSpaceRequest}.
     * @return An immutable instance of CreateSpaceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateSpaceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateSpaceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build CreateSpaceRequest, some of required attributes are not set " + attributes;
    }
  }
}
