package org.cloudfoundry.operations.stacks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * A Stack
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Stack"})
public final class Stack extends org.cloudfoundry.operations.stacks._Stack {
  private final String description;
  private final String id;
  private final String name;

  private Stack(Stack.Builder builder) {
    this.description = builder.description;
    this.id = builder.id;
    this.name = builder.name;
  }

  /**
   * The description of this stack
   */
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The name of this stack
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code Stack} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Stack
        && equalTo((Stack) another);
  }

  private boolean equalTo(Stack another) {
    return description.equals(another.description)
        && id.equals(another.id)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code id}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + description.hashCode();
    h = h * 17 + id.hashCode();
    h = h * 17 + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Stack} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Stack{"
        + "description=" + description
        + ", id=" + id
        + ", name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link Stack Stack}.
   * @return A new Stack builder
   */
  public static Stack.Builder builder() {
    return new Stack.Builder();
  }

  /**
   * Builds instances of type {@link Stack Stack}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DESCRIPTION = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private long initBits = 0x7L;

    private String description;
    private String id;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Stack} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Stack instance) {
      return from((_Stack) instance);
    }

    /**
     * Copy abstract value type {@code _Stack} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Stack instance) {
      Objects.requireNonNull(instance, "instance");
      description(instance.getDescription());
      id(instance.getId());
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link _Stack#getDescription() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Initializes the value for the {@link _Stack#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _Stack#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link Stack Stack}.
     * @return An immutable instance of Stack
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Stack build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Stack(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Stack, some of required attributes are not set " + attributes;
    }
  }
}
