/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.applications.AbstractApplicationResource;
import org.cloudfoundry.client.v2.applications.ApplicationEntity;
import org.cloudfoundry.client.v2.applications.ApplicationEnvironmentRequest;
import org.cloudfoundry.client.v2.applications.ApplicationEnvironmentResponse;
import org.cloudfoundry.client.v2.applications.ApplicationInstanceInfo;
import org.cloudfoundry.client.v2.applications.ApplicationInstancesRequest;
import org.cloudfoundry.client.v2.applications.ApplicationInstancesResponse;
import org.cloudfoundry.client.v2.applications.ApplicationStatisticsRequest;
import org.cloudfoundry.client.v2.applications.ApplicationStatisticsResponse;
import org.cloudfoundry.client.v2.applications.AssociateApplicationRouteRequest;
import org.cloudfoundry.client.v2.applications.AssociateApplicationRouteResponse;
import org.cloudfoundry.client.v2.applications.CopyApplicationRequest;
import org.cloudfoundry.client.v2.applications.CopyApplicationResponse;
import org.cloudfoundry.client.v2.applications.CreateApplicationRequest;
import org.cloudfoundry.client.v2.applications.CreateApplicationResponse;
import org.cloudfoundry.client.v2.applications.InstanceStatistics;
import org.cloudfoundry.client.v2.applications.ListApplicationServiceBindingsRequest;
import org.cloudfoundry.client.v2.applications.RemoveApplicationServiceBindingRequest;
import org.cloudfoundry.client.v2.applications.Resource;
import org.cloudfoundry.client.v2.applications.RestageApplicationResponse;
import org.cloudfoundry.client.v2.applications.Statistics;
import org.cloudfoundry.client.v2.applications.SummaryApplicationRequest;
import org.cloudfoundry.client.v2.applications.SummaryApplicationResponse;
import org.cloudfoundry.client.v2.applications.TerminateApplicationInstanceRequest;
import org.cloudfoundry.client.v2.applications.UpdateApplicationRequest;
import org.cloudfoundry.client.v2.applications.UploadApplicationRequest;
import org.cloudfoundry.client.v2.applications.UploadApplicationResponse;
import org.cloudfoundry.client.v2.applications.Usage;
import org.cloudfoundry.client.v2.domains.Domain;
import org.cloudfoundry.client.v2.events.EventEntity;
import org.cloudfoundry.client.v2.events.EventResource;
import org.cloudfoundry.client.v2.events.ListEventsRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationPrivateDomainsRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationSpacesRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationsRequest;
import org.cloudfoundry.client.v2.organizations.OrganizationResource;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomainResource;
import org.cloudfoundry.client.v2.routes.CreateRouteRequest;
import org.cloudfoundry.client.v2.routes.CreateRouteResponse;
import org.cloudfoundry.client.v2.routes.DeleteRouteRequest;
import org.cloudfoundry.client.v2.routes.DeleteRouteResponse;
import org.cloudfoundry.client.v2.routes.ListRoutesRequest;
import org.cloudfoundry.client.v2.routes.Route;
import org.cloudfoundry.client.v2.routes.RouteEntity;
import org.cloudfoundry.client.v2.routes.RouteResource;
import org.cloudfoundry.client.v2.servicebindings.ServiceBindingResource;
import org.cloudfoundry.client.v2.serviceinstances.ServiceInstance;
import org.cloudfoundry.client.v2.shareddomains.ListSharedDomainsRequest;
import org.cloudfoundry.client.v2.shareddomains.SharedDomainResource;
import org.cloudfoundry.client.v2.spaces.GetSpaceRequest;
import org.cloudfoundry.client.v2.spaces.GetSpaceResponse;
import org.cloudfoundry.client.v2.spaces.GetSpaceSummaryRequest;
import org.cloudfoundry.client.v2.spaces.GetSpaceSummaryResponse;
import org.cloudfoundry.client.v2.spaces.ListSpaceApplicationsRequest;
import org.cloudfoundry.client.v2.spaces.SpaceApplicationSummary;
import org.cloudfoundry.client.v2.spaces.SpaceEntity;
import org.cloudfoundry.client.v2.spaces.SpaceResource;
import org.cloudfoundry.client.v2.stacks.GetStackRequest;
import org.cloudfoundry.client.v2.stacks.GetStackResponse;
import org.cloudfoundry.client.v2.stacks.ListStacksRequest;
import org.cloudfoundry.client.v2.stacks.StackResource;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.doppler.Envelope;
import org.cloudfoundry.doppler.EventType;
import org.cloudfoundry.doppler.LogMessage;
import org.cloudfoundry.doppler.RecentLogsRequest;
import org.cloudfoundry.doppler.StreamRequest;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.cloudfoundry.operations.applications.ApplicationEnvironments;
import org.cloudfoundry.operations.applications.ApplicationEvent;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.cloudfoundry.operations.applications.ApplicationManifest;
import org.cloudfoundry.operations.applications.ApplicationSshEnabledRequest;
import org.cloudfoundry.operations.applications.ApplicationSummary;
import org.cloudfoundry.operations.applications.Applications;
import org.cloudfoundry.operations.applications.CopySourceApplicationRequest;
import org.cloudfoundry.operations.applications.DeleteApplicationRequest;
import org.cloudfoundry.operations.applications.DisableApplicationSshRequest;
import org.cloudfoundry.operations.applications.EnableApplicationSshRequest;
import org.cloudfoundry.operations.applications.GetApplicationEnvironmentsRequest;
import org.cloudfoundry.operations.applications.GetApplicationEventsRequest;
import org.cloudfoundry.operations.applications.GetApplicationHealthCheckRequest;
import org.cloudfoundry.operations.applications.GetApplicationManifestRequest;
import org.cloudfoundry.operations.applications.GetApplicationRequest;
import org.cloudfoundry.operations.applications.InstanceDetail;
import org.cloudfoundry.operations.applications.LogsRequest;
import org.cloudfoundry.operations.applications.PushApplicationRequest;
import org.cloudfoundry.operations.applications.RandomWords;
import org.cloudfoundry.operations.applications.RenameApplicationRequest;
import org.cloudfoundry.operations.applications.RestageApplicationRequest;
import org.cloudfoundry.operations.applications.RestartApplicationInstanceRequest;
import org.cloudfoundry.operations.applications.RestartApplicationRequest;
import org.cloudfoundry.operations.applications.ScaleApplicationRequest;
import org.cloudfoundry.operations.applications.SetApplicationHealthCheckRequest;
import org.cloudfoundry.operations.applications.SetEnvironmentVariableApplicationRequest;
import org.cloudfoundry.operations.applications.StartApplicationRequest;
import org.cloudfoundry.operations.applications.StopApplicationRequest;
import org.cloudfoundry.operations.applications.UnsetEnvironmentVariableApplicationRequest;
import org.cloudfoundry.operations.applications.WordListRandomWords;
import org.cloudfoundry.util.DateUtils;
import org.cloudfoundry.util.DelayTimeoutException;
import org.cloudfoundry.util.DelayUtils;
import org.cloudfoundry.util.ExceptionUtils;
import org.cloudfoundry.util.FileUtils;
import org.cloudfoundry.util.FluentMap;
import org.cloudfoundry.util.JobUtils;
import org.cloudfoundry.util.PaginationUtils;
import org.cloudfoundry.util.ResourceMatchingUtils;
import org.cloudfoundry.util.ResourceUtils;
import org.cloudfoundry.util.SortingUtils;
import org.cloudfoundry.util.tuple.TupleUtils;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuple4;
import reactor.util.function.Tuples;

public final class DefaultApplications
implements Applications {
    private static final int CF_APP_STOPPED_STATS_ERROR = 200003;
    private static final int CF_BUILDPACK_COMPILED_FAILED = 170004;
    private static final int CF_INSTANCES_ERROR = 220001;
    private static final int CF_STAGING_NOT_FINISHED = 170002;
    private static final int CF_STAGING_TIME_EXPIRED = 170007;
    private static final Comparator<LogMessage> LOG_MESSAGE_COMPARATOR = Comparator.comparing(LogMessage::getTimestamp);
    private static final Duration LOG_MESSAGE_TIMESPAN = Duration.ofMillis(500L);
    private static final int MAX_NUMBER_OF_RECENT_EVENTS = 50;
    private static final String STARTED_STATE = "STARTED";
    private static final String STOPPED_STATE = "STOPPED";
    private final Mono<CloudFoundryClient> cloudFoundryClient;
    private final Mono<DopplerClient> dopplerClient;
    private final RandomWords randomWords;
    private final Mono<String> spaceId;

    public DefaultApplications(Mono<CloudFoundryClient> cloudFoundryClient, Mono<DopplerClient> dopplerClient, Mono<String> spaceId) {
        this(cloudFoundryClient, dopplerClient, spaceId, new WordListRandomWords());
    }

    DefaultApplications(Mono<CloudFoundryClient> cloudFoundryClient, Mono<DopplerClient> dopplerClient, Mono<String> spaceId, RandomWords randomWords) {
        this.cloudFoundryClient = cloudFoundryClient;
        this.dopplerClient = dopplerClient;
        this.spaceId = spaceId;
        this.randomWords = randomWords;
    }

    @Override
    public Mono<Void> copySource(CopySourceApplicationRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId), DefaultApplications.getApplicationIdFromOrgSpace(cloudFoundryClient, request.getTargetName(), spaceId, request.getTargetOrganization(), request.getTargetSpace())))).then(TupleUtils.function((cloudFoundryClient, sourceApplicationId, targetApplicationId) -> DefaultApplications.copyBits(cloudFoundryClient, sourceApplicationId, targetApplicationId).then(Mono.just((Object)Tuples.of((Object)cloudFoundryClient, (Object)targetApplicationId))))).filter(TupleUtils.predicate((cloudFoundryClient, targetApplicationId) -> Optional.ofNullable(request.getRestart()).orElse(false))).then(TupleUtils.function((cloudFoundryClient, targetApplicationId) -> DefaultApplications.restartApplication(cloudFoundryClient, request.getTargetName(), targetApplicationId, request.getStagingTimeout(), request.getStartupTimeout()))).checkpoint();
    }

    @Override
    public Mono<Void> delete(DeleteApplicationRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> DefaultApplications.getRoutesAndApplicationId(cloudFoundryClient, request, spaceId, Optional.ofNullable(request.getDeleteRoutes()).orElse(false)).map(TupleUtils.function((routes, applicationId) -> Tuples.of((Object)cloudFoundryClient, (Object)routes, (Object)applicationId))))).then(TupleUtils.function((cloudFoundryClient, routes, applicationId) -> DefaultApplications.deleteRoutes(cloudFoundryClient, routes).then(Mono.just((Object)Tuples.of((Object)cloudFoundryClient, (Object)applicationId))))).then(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.removeServiceBindings(cloudFoundryClient, applicationId).then(Mono.just((Object)Tuples.of((Object)cloudFoundryClient, (Object)applicationId))))).then(TupleUtils.function(DefaultApplications::requestDeleteApplication)).checkpoint();
    }

    @Override
    public Mono<Void> disableSsh(DisableApplicationSshRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationIdWhere(cloudFoundryClient, request.getName(), spaceId, DefaultApplications.sshEnabled(true))))).then(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.requestUpdateApplicationSsh(cloudFoundryClient, applicationId, false))).then().checkpoint();
    }

    @Override
    public Mono<Void> enableSsh(EnableApplicationSshRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationIdWhere(cloudFoundryClient, request.getName(), spaceId, DefaultApplications.sshEnabled(false))))).then(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.requestUpdateApplicationSsh(cloudFoundryClient, applicationId, true))).then().checkpoint();
    }

    @Override
    public Mono<ApplicationDetail> get(GetApplicationRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplication(cloudFoundryClient, request.getName(), spaceId)))).then(TupleUtils.function(DefaultApplications::getAuxiliaryContent)).map(TupleUtils.function(DefaultApplications::toApplicationDetail)).checkpoint();
    }

    @Override
    public Mono<ApplicationManifest> getApplicationManifest(GetApplicationManifestRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, applicationId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.requestApplicationSummary(cloudFoundryClient, applicationId)))).then(TupleUtils.function((cloudFoundryClient, response) -> Mono.when((Mono)Mono.just((Object)response), DefaultApplications.getStackName(cloudFoundryClient, response.getStackId())))).then(TupleUtils.function(DefaultApplications::toApplicationManifest)).checkpoint();
    }

    @Override
    public Mono<ApplicationEnvironments> getEnvironments(GetApplicationEnvironmentsRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId)))).then(TupleUtils.function(DefaultApplications::requestApplicationEnvironment)).map(DefaultApplications::toApplicationEnvironments).checkpoint();
    }

    @Override
    public Flux<ApplicationEvent> getEvents(GetApplicationEventsRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId)))).flatMap(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.requestEvents(applicationId, cloudFoundryClient).take((long)Optional.ofNullable(request.getMaxNumberOfEvents()).orElse(50).intValue()))).map(DefaultApplications::convertToApplicationEvent).checkpoint();
    }

    @Override
    public Mono<ApplicationHealthCheck> getHealthCheck(GetApplicationHealthCheckRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> DefaultApplications.getApplication(cloudFoundryClient, request.getName(), spaceId))).map(DefaultApplications::toHealthCheck).checkpoint();
    }

    @Override
    public Flux<ApplicationSummary> list() {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function(DefaultApplications::requestSpaceSummary)).flatMap(DefaultApplications::extractApplications).map(DefaultApplications::toApplicationSummary).checkpoint();
    }

    @Override
    public Flux<LogMessage> logs(LogsRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId))).flatMap(applicationId -> DefaultApplications.getLogs(this.dopplerClient, applicationId, request.getRecent())).checkpoint();
    }

    @Override
    public Mono<Void> push(PushApplicationRequest request) {
        if (request.getApplication() != null) {
            return this.cloudFoundryClient.then(cloudFoundryClient -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), this.spaceId, DefaultApplications.getOptionalStackId(cloudFoundryClient, request.getStack()))).then(TupleUtils.function((cloudFoundryClient, spaceId, stackId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request, spaceId, stackId.orElse(null)), (Mono)ResourceMatchingUtils.getMatchedResources((CloudFoundryClient)cloudFoundryClient, (Path)request.getApplication()), (Mono)Mono.just((Object)spaceId)))).then(TupleUtils.function((cloudFoundryClient, applicationId, matchedResources, spaceId) -> DefaultApplications.prepareDomainsAndRoutes(cloudFoundryClient, request, applicationId, spaceId, this.randomWords).then(Mono.just((Object)Tuples.of((Object)cloudFoundryClient, (Object)applicationId, (Object)matchedResources))))).then(TupleUtils.function((cloudFoundryClient, applicationId, matchedResources) -> DefaultApplications.uploadApplicationAndWait(cloudFoundryClient, applicationId, request.getApplication(), matchedResources).then(Mono.just((Object)Tuples.of((Object)cloudFoundryClient, (Object)applicationId))))).then(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.stopAndStartApplication(cloudFoundryClient, applicationId, request))).checkpoint();
        }
        if (request.getDockerImage() != null) {
            return this.cloudFoundryClient.then(cloudFoundryClient -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), this.spaceId, DefaultApplications.getOptionalStackId(cloudFoundryClient, request.getStack()))).then(TupleUtils.function((cloudFoundryClient, spaceId, stackId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request, spaceId, stackId.orElse(null)), (Mono)Mono.just((Object)spaceId)))).then(TupleUtils.function((cloudFoundryClient, applicationId, spaceId) -> DefaultApplications.prepareDomainsAndRoutes(cloudFoundryClient, request, applicationId, spaceId, this.randomWords).then(Mono.just((Object)Tuples.of((Object)cloudFoundryClient, (Object)applicationId))))).then(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.stopAndStartApplication(cloudFoundryClient, applicationId, request))).checkpoint();
        }
        throw new IllegalStateException("One of application or dockerImage must be supplied");
    }

    @Override
    public Mono<Void> rename(RenameApplicationRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.requestUpdateApplicationName(cloudFoundryClient, applicationId, request.getNewName()))).then().checkpoint();
    }

    @Override
    public Mono<Void> restage(RestageApplicationRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.restageApplication(cloudFoundryClient, request.getName(), applicationId, request.getStagingTimeout(), request.getStartupTimeout()))).checkpoint();
    }

    @Override
    public Mono<Void> restart(RestartApplicationRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplication(cloudFoundryClient, request.getName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, resource) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.stopApplicationIfNotStopped(cloudFoundryClient, resource)))).then(TupleUtils.function((cloudFoundryClient, stoppedApplication) -> DefaultApplications.startApplicationAndWait(cloudFoundryClient, request.getName(), ResourceUtils.getId((org.cloudfoundry.client.v2.Resource)stoppedApplication), request.getStagingTimeout(), request.getStartupTimeout()))).checkpoint();
    }

    @Override
    public Mono<Void> restartInstance(RestartApplicationInstanceRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.requestTerminateApplicationInstance(cloudFoundryClient, applicationId, String.valueOf(request.getInstanceIndex())))).checkpoint();
    }

    @Override
    public Mono<Void> scale(ScaleApplicationRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).filter(TupleUtils.predicate((cloudFoundryClient, spaceId) -> DefaultApplications.areModifiersPresent(request))).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, applicationId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.requestUpdateApplicationScale(cloudFoundryClient, applicationId, request.getDiskLimit(), request.getInstances(), request.getMemoryLimit())))).filter(TupleUtils.predicate((cloudFoundryClient, resource) -> DefaultApplications.isRestartRequired(request, resource))).then(TupleUtils.function((cloudFoundryClient, resource) -> DefaultApplications.restartApplication(cloudFoundryClient, request.getName(), ResourceUtils.getId((org.cloudfoundry.client.v2.Resource)resource), request.getStagingTimeout(), request.getStartupTimeout()))).checkpoint();
    }

    @Override
    public Mono<Void> setEnvironmentVariable(SetEnvironmentVariableApplicationRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplication(cloudFoundryClient, request.getName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, resource) -> DefaultApplications.requestUpdateApplicationEnvironment(cloudFoundryClient, ResourceUtils.getId((org.cloudfoundry.client.v2.Resource)resource), DefaultApplications.addToEnvironment(DefaultApplications.getEnvironment(resource), request.getVariableName(), request.getVariableValue())))).then().checkpoint();
    }

    @Override
    public Mono<Void> setHealthCheck(SetApplicationHealthCheckRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.requestUpdateApplicationHealthCheckType(cloudFoundryClient, applicationId, request.getType()))).then().checkpoint();
    }

    @Override
    public Mono<Boolean> sshEnabled(ApplicationSshEnabledRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> DefaultApplications.getApplication(cloudFoundryClient, request.getName(), spaceId))).map(applicationResource -> ((ApplicationEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)applicationResource)).getEnableSsh()).checkpoint();
    }

    @Override
    public Mono<Void> start(StartApplicationRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationIdWhere(cloudFoundryClient, request.getName(), spaceId, DefaultApplications.isNotIn(STARTED_STATE))))).then(TupleUtils.function((cloudFoundryClient, applicationId) -> DefaultApplications.startApplicationAndWait(cloudFoundryClient, request.getName(), applicationId, request.getStagingTimeout(), request.getStartupTimeout()))).checkpoint();
    }

    @Override
    public Mono<Void> stop(StopApplicationRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplicationIdWhere(cloudFoundryClient, request.getName(), spaceId, DefaultApplications.isNotIn(STOPPED_STATE))))).then(TupleUtils.function(DefaultApplications::stopApplication)).then().checkpoint();
    }

    @Override
    public Mono<Void> unsetEnvironmentVariable(UnsetEnvironmentVariableApplicationRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultApplications.getApplication(cloudFoundryClient, request.getName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, resource) -> DefaultApplications.requestUpdateApplicationEnvironment(cloudFoundryClient, ResourceUtils.getId((org.cloudfoundry.client.v2.Resource)resource), DefaultApplications.removeFromEnvironment(DefaultApplications.getEnvironment(resource), request.getVariableName())))).then().checkpoint();
    }

    private static Map<String, Object> addToEnvironment(Map<String, Object> environment, String variableName, Object variableValue) {
        return FluentMap.builder().entries(environment).entry((Object)variableName, variableValue).build();
    }

    private static boolean areModifiersPresent(ScaleApplicationRequest request) {
        return request.getMemoryLimit() != null || request.getDiskLimit() != null || request.getInstances() != null;
    }

    private static BiFunction<String, String, String> collectStates() {
        return (totalState, instanceState) -> {
            if ("RUNNING".equals(instanceState) || "RUNNING".equals(totalState)) {
                return "RUNNING";
            }
            if ("FLAPPING".equals(instanceState) || "CRASHED".equals(instanceState)) {
                return "FAILED";
            }
            return totalState;
        };
    }

    private static ApplicationEvent convertToApplicationEvent(EventResource resource) {
        EventEntity entity = resource.getEntity();
        Date timestamp = null;
        try {
            timestamp = DateUtils.parseFromIso8601((String)entity.getTimestamp());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ApplicationEvent.builder().actor(entity.getActorName()).description(DefaultApplications.eventDescription(DefaultApplications.getMetadataRequest(entity), "instances", "memory", "state", "environment_json")).id(ResourceUtils.getId((org.cloudfoundry.client.v2.Resource)resource)).event(entity.getType()).time(timestamp).build();
    }

    private static Mono<Void> copyBits(CloudFoundryClient cloudFoundryClient, String sourceApplicationId, String targetApplicationId) {
        return DefaultApplications.requestCopyBits(cloudFoundryClient, sourceApplicationId, targetApplicationId).then(job -> JobUtils.waitForCompletion((CloudFoundryClient)cloudFoundryClient, (org.cloudfoundry.client.v2.Resource)job));
    }

    private static Mono<Void> deleteRoute(CloudFoundryClient cloudFoundryClient, String routeId) {
        return DefaultApplications.requestDeleteRoute(cloudFoundryClient, routeId).then(job -> JobUtils.waitForCompletion((CloudFoundryClient)cloudFoundryClient, (org.cloudfoundry.client.v2.Resource)job));
    }

    private static Mono<Void> deleteRoutes(CloudFoundryClient cloudFoundryClient, Optional<List<Route>> routes) {
        return routes.map(Flux::fromIterable).orElse(Flux.empty()).map(Route::getId).flatMap(routeId -> DefaultApplications.deleteRoute(cloudFoundryClient, routeId)).then();
    }

    private static String deriveHostname(PushApplicationRequest request, RandomWords randomWords) {
        if (Optional.ofNullable(request.getNoHostname()).orElse(false).booleanValue()) {
            return null;
        }
        if (request.getHost() != null) {
            return request.getHost();
        }
        if (Optional.ofNullable(request.getRandomRoute()).orElse(false).booleanValue()) {
            return String.join((CharSequence)"-", request.getName(), randomWords.getAdjective(), randomWords.getNoun());
        }
        return request.getName();
    }

    private static Statistics emptyApplicationStatistics() {
        return Statistics.builder().usage(DefaultApplications.emptyApplicationUsage()).build();
    }

    private static Usage emptyApplicationUsage() {
        return Usage.builder().build();
    }

    private static InstanceStatistics emptyInstanceStats() {
        return InstanceStatistics.builder().statistics(DefaultApplications.emptyApplicationStatistics()).build();
    }

    private static String eventDescription(Map<String, Object> request, String ... entryNames) {
        if (request == null) {
            return "";
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String entryName : entryNames) {
            Object value = request.get(entryName);
            if (value == null) continue;
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(entryName).append(": ").append(String.valueOf(value));
        }
        return sb.toString();
    }

    private static Flux<SpaceApplicationSummary> extractApplications(GetSpaceSummaryResponse getSpaceSummaryResponse) {
        return Flux.fromIterable((Iterable)getSpaceSummaryResponse.getApplications());
    }

    private static Mono<AbstractApplicationResource> getApplication(CloudFoundryClient cloudFoundryClient, String application, String spaceId) {
        return DefaultApplications.requestApplications(cloudFoundryClient, application, spaceId).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Application %s does not exist", (Object[])new Object[]{application}));
    }

    private static Mono<String> getApplicationId(CloudFoundryClient cloudFoundryClient, String application, String spaceId) {
        return DefaultApplications.getApplication(cloudFoundryClient, application, spaceId).map(ResourceUtils::getId);
    }

    private static Mono<String> getApplicationId(CloudFoundryClient cloudFoundryClient, PushApplicationRequest request, String spaceId, String stackId) {
        return DefaultApplications.requestApplications(cloudFoundryClient, request.getName(), spaceId).singleOrEmpty().map(ResourceUtils::getId).then(applicationId -> DefaultApplications.requestUpdateApplication(cloudFoundryClient, applicationId, request, stackId).map(ResourceUtils::getId)).otherwiseIfEmpty(DefaultApplications.requestCreateApplication(cloudFoundryClient, request, spaceId, stackId).map(ResourceUtils::getId));
    }

    private static Mono<String> getApplicationIdFromOrgSpace(CloudFoundryClient cloudFoundryClient, String application, String spaceId, String organization, String space) {
        return DefaultApplications.getSpaceOrganizationId(cloudFoundryClient, spaceId).then(organizationId -> organization != null ? DefaultApplications.getOrganizationId(cloudFoundryClient, organization) : Mono.just((Object)organizationId)).then(organizationId -> space != null ? DefaultApplications.getSpaceId(cloudFoundryClient, organizationId, space) : Mono.just((Object)spaceId)).then(spaceId1 -> DefaultApplications.getApplicationId(cloudFoundryClient, application, spaceId1));
    }

    private static Mono<String> getApplicationIdWhere(CloudFoundryClient cloudFoundryClient, String application, String spaceId, Predicate<AbstractApplicationResource> predicate) {
        return DefaultApplications.getApplication(cloudFoundryClient, application, spaceId).filter(predicate).map(ResourceUtils::getId);
    }

    private static Mono<ApplicationInstancesResponse> getApplicationInstances(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return DefaultApplications.requestApplicationInstances(cloudFoundryClient, applicationId).otherwise(ExceptionUtils.statusCode((int[])new int[]{170004, 220001, 170002, 170007}), t -> Mono.just((Object)ApplicationInstancesResponse.builder().build()));
    }

    private static Mono<ApplicationStatisticsResponse> getApplicationStatistics(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return DefaultApplications.requestApplicationStatistics(cloudFoundryClient, applicationId).otherwise(ExceptionUtils.statusCode((int[])new int[]{200003}), t -> Mono.just((Object)ApplicationStatisticsResponse.builder().build()));
    }

    private static Mono<Tuple4<SummaryApplicationResponse, GetStackResponse, List<InstanceDetail>, List<String>>> getAuxiliaryContent(CloudFoundryClient cloudFoundryClient, AbstractApplicationResource applicationResource) {
        String applicationId = ResourceUtils.getId((org.cloudfoundry.client.v2.Resource)applicationResource);
        String stackId = ((ApplicationEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)applicationResource)).getStackId();
        return Mono.when(DefaultApplications.getApplicationStatistics(cloudFoundryClient, applicationId), DefaultApplications.requestApplicationSummary(cloudFoundryClient, applicationId), DefaultApplications.getApplicationInstances(cloudFoundryClient, applicationId)).then(TupleUtils.function((applicationStatisticsResponse, summaryApplicationResponse, applicationInstancesResponse) -> Mono.when((Mono)Mono.just((Object)summaryApplicationResponse), DefaultApplications.requestStack(cloudFoundryClient, stackId), DefaultApplications.toInstanceDetailList(applicationInstancesResponse, applicationStatisticsResponse), DefaultApplications.toUrls(summaryApplicationResponse.getRoutes()))));
    }

    private static String getBuildpack(SummaryApplicationResponse response) {
        return Optional.ofNullable(response.getBuildpack()).orElse(response.getDetectedBuildpack());
    }

    private static Mono<String> getDomainId(CloudFoundryClient cloudFoundryClient, String domain, String organizationId) {
        if (domain == null) {
            return DefaultApplications.getSharedDomainIds(cloudFoundryClient).switchIfEmpty(DefaultApplications.getPrivateDomainIds(cloudFoundryClient, organizationId)).next().otherwiseIfEmpty(ExceptionUtils.illegalArgument((String)"Domain not found", (Object[])new Object[0]));
        }
        return DefaultApplications.getPrivateDomainId(cloudFoundryClient, domain, organizationId).otherwiseIfEmpty(DefaultApplications.getSharedDomainId(cloudFoundryClient, domain)).otherwiseIfEmpty(ExceptionUtils.illegalArgument((String)"Domain %s not found", (Object[])new Object[]{domain}));
    }

    private static Map<String, Object> getEnvironment(AbstractApplicationResource resource) {
        return ((ApplicationEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)resource)).getEnvironmentJsons();
    }

    private static Flux<LogMessage> getLogs(Mono<DopplerClient> dopplerClient, String applicationId, Boolean recent) {
        if (Optional.ofNullable(recent).orElse(false).booleanValue()) {
            return DefaultApplications.requestLogsRecent(dopplerClient, applicationId).filter(e -> EventType.LOG_MESSAGE == e.getEventType()).map(Envelope::getLogMessage).collectSortedList(LOG_MESSAGE_COMPARATOR).flatMapIterable(d -> d);
        }
        return DefaultApplications.requestLogsStream(dopplerClient, applicationId).filter(e -> EventType.LOG_MESSAGE == e.getEventType()).map(Envelope::getLogMessage).compose(SortingUtils.timespan(LOG_MESSAGE_COMPARATOR, (Duration)LOG_MESSAGE_TIMESPAN));
    }

    private static Map<String, Object> getMetadataRequest(EventEntity entity) {
        Map metadata = Optional.ofNullable(entity.getMetadatas()).orElse(Collections.emptyMap());
        if (metadata.get("request") != null) {
            return ((Optional)metadata.get("request")).map(m -> (Map)m).orElse(Collections.emptyMap());
        }
        return Collections.emptyMap();
    }

    private static Mono<Optional<List<Route>>> getOptionalRoutes(CloudFoundryClient cloudFoundryClient, boolean deleteRoutes, String applicationId) {
        if (deleteRoutes) {
            return DefaultApplications.getRoutes(cloudFoundryClient, applicationId).map(Optional::of);
        }
        return Mono.just(Optional.empty());
    }

    private static Mono<Optional<String>> getOptionalStackId(CloudFoundryClient cloudFoundryClient, String stack) {
        return Optional.ofNullable(stack).map(stack1 -> DefaultApplications.requestStackId(cloudFoundryClient, stack1).map(ResourceUtils::getId).map(Optional::of).otherwiseIfEmpty(ExceptionUtils.illegalState((String)"Stack %s not found", (Object[])new Object[]{stack1}))).orElse(Mono.just(Optional.empty()));
    }

    private static Mono<OrganizationResource> getOrganization(CloudFoundryClient cloudFoundryClient, String organization) {
        return DefaultApplications.requestOrganizations(cloudFoundryClient, organization).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Organization %s not found", (Object[])new Object[]{organization}));
    }

    private static Mono<String> getOrganizationId(CloudFoundryClient cloudFoundryClient, String organization) {
        return DefaultApplications.getOrganization(cloudFoundryClient, organization).map(ResourceUtils::getId);
    }

    private static Mono<SpaceResource> getOrganizationSpaceByName(CloudFoundryClient cloudFoundryClient, String organizationId, String space) {
        return DefaultApplications.requestOrganizationSpacesByName(cloudFoundryClient, organizationId, space).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Space %s not found", (Object[])new Object[]{space}));
    }

    private static Mono<String> getPrivateDomainId(CloudFoundryClient cloudFoundryClient, String domain, String organizationId) {
        return DefaultApplications.requestPrivateDomain(cloudFoundryClient, domain, organizationId).map(ResourceUtils::getId).singleOrEmpty();
    }

    private static Flux<String> getPrivateDomainIds(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return DefaultApplications.requestPrivateDomains(cloudFoundryClient, organizationId).map(ResourceUtils::getId);
    }

    private static Mono<String> getPushRouteId(CloudFoundryClient cloudFoundryClient, String domainId, PushApplicationRequest request, String spaceId, RandomWords randomWords) {
        String routePath = request.getRoutePath();
        String host = DefaultApplications.deriveHostname(request, randomWords);
        return DefaultApplications.getRouteId(cloudFoundryClient, domainId, host, routePath).otherwiseIfEmpty(DefaultApplications.requestCreateRoute(cloudFoundryClient, domainId, host, routePath, spaceId).map(ResourceUtils::getId));
    }

    private static Mono<String> getRouteId(CloudFoundryClient cloudFoundryClient, String domainId, String host, String routePath) {
        return DefaultApplications.requestRoutes(cloudFoundryClient, domainId, host, routePath).filter(resource -> DefaultApplications.isIdentical(host, ((RouteEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)resource)).getHost())).filter(resource -> DefaultApplications.isIdentical(Optional.ofNullable(routePath).orElse(""), ((RouteEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)resource)).getPath())).singleOrEmpty().map(ResourceUtils::getId);
    }

    private static Mono<List<Route>> getRoutes(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return DefaultApplications.requestApplicationSummary(cloudFoundryClient, applicationId).map(SummaryApplicationResponse::getRoutes);
    }

    private static Mono<Tuple2<Optional<List<Route>>, String>> getRoutesAndApplicationId(CloudFoundryClient cloudFoundryClient, DeleteApplicationRequest request, String spaceId, boolean deleteRoutes) {
        return DefaultApplications.getApplicationId(cloudFoundryClient, request.getName(), spaceId).then(applicationId -> DefaultApplications.getOptionalRoutes(cloudFoundryClient, deleteRoutes, applicationId).and(Mono.just((Object)applicationId)));
    }

    private static Mono<String> getSharedDomainId(CloudFoundryClient cloudFoundryClient, String domain) {
        return DefaultApplications.requestSharedDomain(cloudFoundryClient, domain).map(ResourceUtils::getId).singleOrEmpty();
    }

    private static Flux<String> getSharedDomainIds(CloudFoundryClient cloudFoundryClient) {
        return DefaultApplications.requestSharedDomains(cloudFoundryClient).map(ResourceUtils::getId);
    }

    private static Mono<String> getSpaceId(CloudFoundryClient cloudFoundryClient, String organizationId, String space) {
        return DefaultApplications.getOrganizationSpaceByName(cloudFoundryClient, organizationId, space).map(ResourceUtils::getId);
    }

    private static Mono<String> getSpaceOrganizationId(CloudFoundryClient cloudFoundryClient, String spaceId) {
        return DefaultApplications.requestSpace(cloudFoundryClient, spaceId).map(response -> ((SpaceEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)response)).getOrganizationId());
    }

    private static Mono<String> getStackName(CloudFoundryClient cloudFoundryClient, String stackId) {
        return DefaultApplications.requestStack(cloudFoundryClient, stackId).map(getStackResponse -> getStackResponse.getEntity().getName());
    }

    private static boolean isIdentical(String s, String t) {
        return s == null ? t == null : s.equals(t);
    }

    private static Predicate<String> isInstanceComplete() {
        return state -> "RUNNING".equals(state) || "FAILED".equals(state);
    }

    private static Predicate<AbstractApplicationResource> isNotIn(String expectedState) {
        return resource -> DefaultApplications.isNotIn(resource, expectedState);
    }

    private static boolean isNotIn(AbstractApplicationResource resource, String expectedState) {
        return !expectedState.equals(((ApplicationEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)resource)).getState());
    }

    private static boolean isRestartRequired(ScaleApplicationRequest request, AbstractApplicationResource applicationResource) {
        return (request.getDiskLimit() != null || request.getMemoryLimit() != null) && STARTED_STATE.equals(((ApplicationEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)applicationResource)).getState());
    }

    private static Predicate<String> isRunning() {
        return "RUNNING"::equals;
    }

    private static Predicate<String> isStaged() {
        return "STAGED"::equals;
    }

    private static Predicate<String> isStagingComplete() {
        return state -> "STAGED".equals(state) || "FAILED".equals(state);
    }

    private static Mono<Void> prepareDomainsAndRoutes(CloudFoundryClient cloudFoundryClient, PushApplicationRequest validRequest, String applicationId, String spaceId, RandomWords randomWords) {
        if (Optional.ofNullable(validRequest.getNoRoute()).orElse(false).booleanValue()) {
            return Mono.empty();
        }
        return DefaultApplications.getSpaceOrganizationId(cloudFoundryClient, spaceId).then(organizationId -> DefaultApplications.getDomainId(cloudFoundryClient, validRequest.getDomain(), organizationId)).then(domainId -> DefaultApplications.getPushRouteId(cloudFoundryClient, domainId, validRequest, spaceId, randomWords)).then(routeId -> DefaultApplications.requestAssociateRoute(cloudFoundryClient, applicationId, routeId)).then();
    }

    private static Map<String, Object> removeFromEnvironment(Map<String, Object> environment, String variableName) {
        HashMap<String, Object> modified = new HashMap<String, Object>(environment);
        modified.remove(variableName);
        return modified;
    }

    private static Mono<Void> removeServiceBindings(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return DefaultApplications.requestListServiceBindings(cloudFoundryClient, applicationId).map(ResourceUtils::getId).flatMap(serviceBindingId -> DefaultApplications.requestRemoveServiceBinding(cloudFoundryClient, applicationId, serviceBindingId)).then();
    }

    private static Mono<ApplicationEnvironmentResponse> requestApplicationEnvironment(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return cloudFoundryClient.applicationsV2().environment(ApplicationEnvironmentRequest.builder().applicationId(applicationId).build());
    }

    private static Mono<ApplicationInstancesResponse> requestApplicationInstances(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return cloudFoundryClient.applicationsV2().instances(ApplicationInstancesRequest.builder().applicationId(applicationId).build());
    }

    private static Mono<ApplicationStatisticsResponse> requestApplicationStatistics(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return cloudFoundryClient.applicationsV2().statistics(ApplicationStatisticsRequest.builder().applicationId(applicationId).build());
    }

    private static Mono<SummaryApplicationResponse> requestApplicationSummary(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return cloudFoundryClient.applicationsV2().summary(SummaryApplicationRequest.builder().applicationId(applicationId).build());
    }

    private static Flux<AbstractApplicationResource> requestApplications(CloudFoundryClient cloudFoundryClient, String application, String spaceId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.spaces().listApplications(ListSpaceApplicationsRequest.builder().name(application).spaceId(spaceId).page(page).build())).cast(AbstractApplicationResource.class);
    }

    private static Mono<AssociateApplicationRouteResponse> requestAssociateRoute(CloudFoundryClient cloudFoundryClient, String applicationId, String routeId) {
        return cloudFoundryClient.applicationsV2().associateRoute(AssociateApplicationRouteRequest.builder().applicationId(applicationId).routeId(routeId).build());
    }

    private static Mono<CopyApplicationResponse> requestCopyBits(CloudFoundryClient cloudFoundryClient, String sourceApplicationId, String targetApplicationId) {
        return cloudFoundryClient.applicationsV2().copy(CopyApplicationRequest.builder().applicationId(targetApplicationId).sourceApplicationId(sourceApplicationId).build());
    }

    private static Mono<CreateApplicationResponse> requestCreateApplication(CloudFoundryClient cloudFoundryClient, PushApplicationRequest request, String spaceId, String stackId) {
        CreateApplicationRequest.Builder builder = CreateApplicationRequest.builder().buildpack(request.getBuildpack()).command(request.getCommand()).diskQuota(request.getDiskQuota()).healthCheckTimeout(request.getTimeout()).healthCheckType((String)Optional.ofNullable(request.getHealthCheckType()).map(ApplicationHealthCheck::getValue).orElse(null)).instances(request.getInstances()).memory(request.getMemory()).name(request.getName()).spaceId(spaceId).stackId(stackId);
        Optional.ofNullable(request.getDockerImage()).ifPresent(dockerImage -> builder.diego(Boolean.valueOf(true)).dockerImage(dockerImage));
        return cloudFoundryClient.applicationsV2().create(builder.build());
    }

    private static Mono<CreateRouteResponse> requestCreateRoute(CloudFoundryClient cloudFoundryClient, String domainId, String host, String routePath, String spaceId) {
        return cloudFoundryClient.routes().create(CreateRouteRequest.builder().domainId(domainId).host(host).path(routePath).spaceId(spaceId).build());
    }

    private static Mono<Void> requestDeleteApplication(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return cloudFoundryClient.applicationsV2().delete(org.cloudfoundry.client.v2.applications.DeleteApplicationRequest.builder().applicationId(applicationId).build());
    }

    private static Mono<DeleteRouteResponse> requestDeleteRoute(CloudFoundryClient cloudFoundryClient, String routeId) {
        return cloudFoundryClient.routes().delete(DeleteRouteRequest.builder().async(Boolean.valueOf(true)).routeId(routeId).build());
    }

    private static Flux<EventResource> requestEvents(String applicationId, CloudFoundryClient cloudFoundryClient) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.events().list(ListEventsRequest.builder().actee(applicationId).orderDirection(OrderDirection.DESCENDING).resultsPerPage(Integer.valueOf(50)).page(page).build()));
    }

    private static Mono<AbstractApplicationResource> requestGetApplication(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return cloudFoundryClient.applicationsV2().get(org.cloudfoundry.client.v2.applications.GetApplicationRequest.builder().applicationId(applicationId).build()).cast(AbstractApplicationResource.class);
    }

    private static Flux<ServiceBindingResource> requestListServiceBindings(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.applicationsV2().listServiceBindings(ListApplicationServiceBindingsRequest.builder().applicationId(applicationId).page(page).build()));
    }

    private static Flux<Envelope> requestLogsRecent(Mono<DopplerClient> dopplerClient, String applicationId) {
        return dopplerClient.flatMap(client -> client.recentLogs(RecentLogsRequest.builder().applicationId(applicationId).build()));
    }

    private static Flux<Envelope> requestLogsStream(Mono<DopplerClient> dopplerClient, String applicationId) {
        return dopplerClient.flatMap(client -> client.stream(StreamRequest.builder().applicationId(applicationId).build()));
    }

    private static Flux<SpaceResource> requestOrganizationSpacesByName(CloudFoundryClient cloudFoundryClient, String organizationId, String space) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().listSpaces(ListOrganizationSpacesRequest.builder().page(page).organizationId(organizationId).name(space).build()));
    }

    private static Flux<OrganizationResource> requestOrganizations(CloudFoundryClient cloudFoundryClient, String organization) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().list(ListOrganizationsRequest.builder().page(page).name(organization).build()));
    }

    private static Flux<PrivateDomainResource> requestPrivateDomain(CloudFoundryClient cloudFoundryClient, String domain, String organizationId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().listPrivateDomains(ListOrganizationPrivateDomainsRequest.builder().name(domain).organizationId(organizationId).page(page).build()));
    }

    private static Flux<PrivateDomainResource> requestPrivateDomains(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().listPrivateDomains(ListOrganizationPrivateDomainsRequest.builder().organizationId(organizationId).page(page).build()));
    }

    private static Mono<Void> requestRemoveServiceBinding(CloudFoundryClient cloudFoundryClient, String applicationId, String serviceBindingId) {
        return cloudFoundryClient.applicationsV2().removeServiceBinding(RemoveApplicationServiceBindingRequest.builder().applicationId(applicationId).serviceBindingId(serviceBindingId).build());
    }

    private static Mono<RestageApplicationResponse> requestRestageApplication(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return cloudFoundryClient.applicationsV2().restage(org.cloudfoundry.client.v2.applications.RestageApplicationRequest.builder().applicationId(applicationId).build());
    }

    private static Flux<RouteResource> requestRoutes(CloudFoundryClient cloudFoundryClient, String domainId, String host, String routePath) {
        ListRoutesRequest.Builder requestBuilder = ListRoutesRequest.builder().domainId(domainId);
        Optional.ofNullable(host).ifPresent(arg_0 -> ((ListRoutesRequest.Builder)requestBuilder).host(arg_0));
        Optional.ofNullable(routePath).ifPresent(arg_0 -> ((ListRoutesRequest.Builder)requestBuilder).path(arg_0));
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.routes().list(requestBuilder.page(page).build()));
    }

    private static Flux<SharedDomainResource> requestSharedDomain(CloudFoundryClient cloudFoundryClient, String domain) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.sharedDomains().list(ListSharedDomainsRequest.builder().name(domain).page(page).build()));
    }

    private static Flux<SharedDomainResource> requestSharedDomains(CloudFoundryClient cloudFoundryClient) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.sharedDomains().list(ListSharedDomainsRequest.builder().page(page).build()));
    }

    private static Mono<GetSpaceResponse> requestSpace(CloudFoundryClient cloudFoundryClient, String spaceId) {
        return cloudFoundryClient.spaces().get(GetSpaceRequest.builder().spaceId(spaceId).build());
    }

    private static Mono<GetSpaceSummaryResponse> requestSpaceSummary(CloudFoundryClient cloudFoundryClient, String spaceId) {
        return cloudFoundryClient.spaces().getSummary(GetSpaceSummaryRequest.builder().spaceId(spaceId).build());
    }

    private static Mono<GetStackResponse> requestStack(CloudFoundryClient cloudFoundryClient, String stackId) {
        return cloudFoundryClient.stacks().get(GetStackRequest.builder().stackId(stackId).build());
    }

    private static Mono<StackResource> requestStackId(CloudFoundryClient cloudFoundryClient, String stack) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.stacks().list(ListStacksRequest.builder().page(page).name(stack).build())).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Stack %s does not exist", (Object[])new Object[]{stack}));
    }

    private static Mono<Void> requestTerminateApplicationInstance(CloudFoundryClient cloudFoundryClient, String applicationId, String instanceIndex) {
        return cloudFoundryClient.applicationsV2().terminateInstance(TerminateApplicationInstanceRequest.builder().applicationId(applicationId).index(instanceIndex).build());
    }

    private static Mono<AbstractApplicationResource> requestUpdateApplication(CloudFoundryClient cloudFoundryClient, String applicationId, PushApplicationRequest request, String stackId) {
        return DefaultApplications.requestUpdateApplication(cloudFoundryClient, applicationId, builder -> {
            builder.buildpack(request.getBuildpack()).command(request.getCommand()).diskQuota(request.getDiskQuota()).healthCheckTimeout(request.getTimeout()).healthCheckType((String)Optional.ofNullable(request.getHealthCheckType()).map(ApplicationHealthCheck::getValue).orElse(null)).instances(request.getInstances()).memory(request.getMemory()).name(request.getName()).stackId(stackId);
            Optional.ofNullable(request.getDockerImage()).ifPresent(dockerImage -> builder.diego(Boolean.valueOf(true)).dockerImage(dockerImage));
            return builder;
        });
    }

    private static Mono<AbstractApplicationResource> requestUpdateApplication(CloudFoundryClient cloudFoundryClient, String applicationId, UnaryOperator<UpdateApplicationRequest.Builder> modifier) {
        return cloudFoundryClient.applicationsV2().update(((UpdateApplicationRequest.Builder)modifier.apply(UpdateApplicationRequest.builder().applicationId(applicationId))).build()).cast(AbstractApplicationResource.class);
    }

    private static Mono<AbstractApplicationResource> requestUpdateApplicationEnvironment(CloudFoundryClient cloudFoundryClient, String applicationId, Map<String, Object> environment) {
        return DefaultApplications.requestUpdateApplication(cloudFoundryClient, applicationId, builder -> builder.environmentJsons(environment));
    }

    private static Mono<AbstractApplicationResource> requestUpdateApplicationHealthCheckType(CloudFoundryClient cloudFoundryClient, String applicationId, ApplicationHealthCheck type) {
        return DefaultApplications.requestUpdateApplication(cloudFoundryClient, applicationId, builder -> builder.healthCheckType(type.getValue()));
    }

    private static Mono<AbstractApplicationResource> requestUpdateApplicationName(CloudFoundryClient cloudFoundryClient, String applicationId, String name) {
        return DefaultApplications.requestUpdateApplication(cloudFoundryClient, applicationId, builder -> builder.name(name));
    }

    private static Mono<AbstractApplicationResource> requestUpdateApplicationScale(CloudFoundryClient cloudFoundryClient, String applicationId, Integer disk, Integer instances, Integer memory) {
        return DefaultApplications.requestUpdateApplication(cloudFoundryClient, applicationId, builder -> builder.diskQuota(disk).instances(instances).memory(memory));
    }

    private static Mono<AbstractApplicationResource> requestUpdateApplicationSsh(CloudFoundryClient cloudFoundryClient, String applicationId, Boolean enabled) {
        return DefaultApplications.requestUpdateApplication(cloudFoundryClient, applicationId, builder -> builder.enableSsh(enabled));
    }

    private static Mono<AbstractApplicationResource> requestUpdateApplicationState(CloudFoundryClient cloudFoundryClient, String applicationId, String state) {
        return DefaultApplications.requestUpdateApplication(cloudFoundryClient, applicationId, builder -> builder.state(state));
    }

    private static Mono<UploadApplicationResponse> requestUploadApplication(CloudFoundryClient cloudFoundryClient, String applicationId, Path application, List<ResourceMatchingUtils.ArtifactMetadata> matchedResources) {
        UploadApplicationRequest request = matchedResources.stream().reduce(UploadApplicationRequest.builder().application(application).applicationId(applicationId).async(Boolean.valueOf(true)), (builder, artifactMetadata) -> builder.resource(Resource.builder().hash(artifactMetadata.getHash()).mode(artifactMetadata.getPermissions()).path(artifactMetadata.getPath()).size(Integer.valueOf(artifactMetadata.getSize())).build()), (a, b) -> a).build();
        return cloudFoundryClient.applicationsV2().upload(request);
    }

    private static Mono<Void> restageApplication(CloudFoundryClient cloudFoundryClient, String application, String applicationId, Duration stagingTimeout, Duration startupTimeout) {
        return DefaultApplications.requestRestageApplication(cloudFoundryClient, applicationId).then(response -> DefaultApplications.waitForStaging(cloudFoundryClient, application, applicationId, stagingTimeout)).then(DefaultApplications.waitForRunning(cloudFoundryClient, application, applicationId, startupTimeout));
    }

    private static Mono<Void> restartApplication(CloudFoundryClient cloudFoundryClient, String application, String applicationId, Duration stagingTimeout, Duration startupTimeout) {
        return DefaultApplications.stopApplication(cloudFoundryClient, applicationId).then(DefaultApplications.startApplicationAndWait(cloudFoundryClient, application, applicationId, stagingTimeout, startupTimeout));
    }

    private static Predicate<AbstractApplicationResource> sshEnabled(Boolean enabled) {
        return resource -> enabled.equals(((ApplicationEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)resource)).getEnableSsh());
    }

    private static Mono<Void> startApplicationAndWait(CloudFoundryClient cloudFoundryClient, String application, String applicationId, Duration stagingTimeout, Duration startupTimeout) {
        return DefaultApplications.requestUpdateApplicationState(cloudFoundryClient, applicationId, STARTED_STATE).then(response -> DefaultApplications.waitForStaging(cloudFoundryClient, application, applicationId, stagingTimeout)).then(DefaultApplications.waitForRunning(cloudFoundryClient, application, applicationId, startupTimeout));
    }

    private static Mono<Void> stopAndStartApplication(CloudFoundryClient cloudFoundryClient, String applicationId, PushApplicationRequest request) {
        return DefaultApplications.stopApplication(cloudFoundryClient, applicationId).filter(resource -> Optional.ofNullable(request.getNoStart()).orElse(false) == false).then(resource -> DefaultApplications.startApplicationAndWait(cloudFoundryClient, request.getName(), applicationId, request.getStagingTimeout(), request.getStartupTimeout()));
    }

    private static Mono<AbstractApplicationResource> stopApplication(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return DefaultApplications.requestUpdateApplicationState(cloudFoundryClient, applicationId, STOPPED_STATE);
    }

    private static Mono<AbstractApplicationResource> stopApplicationIfNotStopped(CloudFoundryClient cloudFoundryClient, AbstractApplicationResource resource) {
        return DefaultApplications.isNotIn(resource, STOPPED_STATE) ? DefaultApplications.stopApplication(cloudFoundryClient, ResourceUtils.getId((org.cloudfoundry.client.v2.Resource)resource)) : Mono.just((Object)resource);
    }

    private static ApplicationDetail toApplicationDetail(SummaryApplicationResponse summaryApplicationResponse, GetStackResponse getStackResponse, List<InstanceDetail> instanceDetails, List<String> urls) {
        return ApplicationDetail.builder().buildpack(DefaultApplications.getBuildpack(summaryApplicationResponse)).diskQuota(summaryApplicationResponse.getDiskQuota()).id(summaryApplicationResponse.getId()).instanceDetails(instanceDetails).instances(summaryApplicationResponse.getInstances()).lastUploaded(DefaultApplications.toDate(summaryApplicationResponse.getPackageUpdatedAt())).memoryLimit(summaryApplicationResponse.getMemory()).name(summaryApplicationResponse.getName()).requestedState(summaryApplicationResponse.getState()).runningInstances(summaryApplicationResponse.getRunningInstances()).stack(getStackResponse.getEntity().getName()).urls(urls).build();
    }

    private static ApplicationEnvironments toApplicationEnvironments(ApplicationEnvironmentResponse response) {
        return ApplicationEnvironments.builder().running(response.getRunningEnvironmentJsons()).staging(response.getStagingEnvironmentJsons()).systemProvided(response.getSystemEnvironmentJsons()).userProvided(response.getEnvironmentJsons()).build();
    }

    private static Mono<ApplicationManifest> toApplicationManifest(SummaryApplicationResponse response, String stackName) {
        ApplicationManifest.Builder manifestBuilder = ApplicationManifest.builder().buildpack(response.getBuildpack()).command(response.getCommand()).disk(response.getDiskQuota()).environmentVariables(response.getEnvironmentJsons()).instances(response.getInstances()).memory(response.getMemory()).name(response.getName()).stack(stackName).timeout(response.getHealthCheckTimeout());
        for (Route route : Optional.ofNullable(response.getRoutes()).orElse(Collections.emptyList())) {
            Optional.ofNullable(route.getDomain()).map(Domain::getName).ifPresent(manifestBuilder::domain);
            Optional.ofNullable(route.getHost()).ifPresent(manifestBuilder::host);
        }
        for (ServiceInstance service : Optional.ofNullable(response.getServices()).orElse(Collections.emptyList())) {
            Optional.ofNullable(service.getName()).ifPresent(manifestBuilder::service);
        }
        return Mono.just((Object)manifestBuilder.build());
    }

    private static ApplicationSummary toApplicationSummary(SpaceApplicationSummary spaceApplicationSummary) {
        return ApplicationSummary.builder().diskQuota(spaceApplicationSummary.getDiskQuota()).id(spaceApplicationSummary.getId()).instances(spaceApplicationSummary.getInstances()).memoryLimit(spaceApplicationSummary.getMemory()).name(spaceApplicationSummary.getName()).requestedState(spaceApplicationSummary.getState()).runningInstances(spaceApplicationSummary.getRunningInstances()).urls(spaceApplicationSummary.getUrls()).build();
    }

    private static Date toDate(String date) {
        return date == null ? null : DateUtils.parseFromIso8601((String)date);
    }

    private static Date toDate(Double date) {
        return date == null ? null : DateUtils.parseSecondsFromEpoch((Double)date);
    }

    private static ApplicationHealthCheck toHealthCheck(AbstractApplicationResource resource) {
        String type = ((ApplicationEntity)resource.getEntity()).getHealthCheckType();
        if (ApplicationHealthCheck.NONE.getValue().equals(type)) {
            return ApplicationHealthCheck.NONE;
        }
        if (ApplicationHealthCheck.PORT.getValue().equals(type)) {
            return ApplicationHealthCheck.PORT;
        }
        return null;
    }

    private static InstanceDetail toInstanceDetail(Map.Entry<String, ApplicationInstanceInfo> entry, ApplicationStatisticsResponse statisticsResponse) {
        InstanceStatistics instanceStatistics = Optional.ofNullable(statisticsResponse.getInstances().get(entry.getKey())).orElse(DefaultApplications.emptyInstanceStats());
        Statistics stats = Optional.ofNullable(instanceStatistics.getStatistics()).orElse(DefaultApplications.emptyApplicationStatistics());
        Usage usage = Optional.ofNullable(stats.getUsage()).orElse(DefaultApplications.emptyApplicationUsage());
        return InstanceDetail.builder().state(entry.getValue().getState()).since(DefaultApplications.toDate(entry.getValue().getSince())).cpu(usage.getCpu()).memoryUsage(usage.getMemory()).diskUsage(usage.getDisk()).diskQuota(stats.getDiskQuota()).memoryQuota(stats.getMemoryQuota()).build();
    }

    private static Mono<List<InstanceDetail>> toInstanceDetailList(ApplicationInstancesResponse instancesResponse, ApplicationStatisticsResponse statisticsResponse) {
        return Flux.fromIterable(instancesResponse.getInstances().entrySet()).map(entry -> DefaultApplications.toInstanceDetail(entry, statisticsResponse)).collectList();
    }

    private static String toUrl(Route route) {
        String hostName = route.getHost();
        String domainName = route.getDomain().getName();
        return hostName.isEmpty() ? domainName : String.format("%s.%s", hostName, domainName);
    }

    private static Mono<List<String>> toUrls(List<Route> routes) {
        return Flux.fromIterable(routes).map(DefaultApplications::toUrl).collectList();
    }

    private static Mono<Void> uploadApplicationAndWait(CloudFoundryClient cloudFoundryClient, String applicationId, Path application, List<ResourceMatchingUtils.ArtifactMetadata> matchedResources) {
        return Mono.defer(() -> {
            if (matchedResources.isEmpty()) {
                return DefaultApplications.requestUploadApplication(cloudFoundryClient, applicationId, application, matchedResources);
            }
            List paths = matchedResources.stream().map(ResourceMatchingUtils.ArtifactMetadata::getPath).collect(Collectors.toList());
            return FileUtils.compress((Path)application, p -> !paths.contains(p)).then(filteredApplication -> DefaultApplications.requestUploadApplication(cloudFoundryClient, applicationId, filteredApplication, matchedResources).doOnTerminate((v, t) -> {
                try {
                    Files.delete(filteredApplication);
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }));
        }).then(job -> JobUtils.waitForCompletion((CloudFoundryClient)cloudFoundryClient, (org.cloudfoundry.client.v2.Resource)job));
    }

    private static Mono<Void> waitForRunning(CloudFoundryClient cloudFoundryClient, String application, String applicationId, Duration startupTimeout) {
        Duration timeout = Optional.ofNullable(startupTimeout).orElse(Duration.ofMinutes(5L));
        return DefaultApplications.requestApplicationInstances(cloudFoundryClient, applicationId).flatMap(response -> Flux.fromIterable(response.getInstances().values())).map(ApplicationInstanceInfo::getState).reduce((Object)"UNKNOWN", DefaultApplications.collectStates()).filter(DefaultApplications.isInstanceComplete()).repeatWhenEmpty(DelayUtils.exponentialBackOff((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(15L), (Duration)timeout)).filter(DefaultApplications.isRunning()).otherwiseIfEmpty(ExceptionUtils.illegalState((String)"Application %s failed during start", (Object[])new Object[]{application})).otherwise(DelayTimeoutException.class, t -> ExceptionUtils.illegalState((String)"Application %s timed out during start", (Object[])new Object[]{application})).then();
    }

    private static Mono<Void> waitForStaging(CloudFoundryClient cloudFoundryClient, String application, String applicationId, Duration stagingTimeout) {
        Duration timeout = Optional.ofNullable(stagingTimeout).orElse(Duration.ofMinutes(15L));
        return DefaultApplications.requestGetApplication(cloudFoundryClient, applicationId).map(response -> ((ApplicationEntity)ResourceUtils.getEntity((org.cloudfoundry.client.v2.Resource)response)).getPackageState()).filter(DefaultApplications.isStagingComplete()).repeatWhenEmpty(DelayUtils.exponentialBackOff((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(15L), (Duration)timeout)).filter(DefaultApplications.isStaged()).otherwiseIfEmpty(ExceptionUtils.illegalState((String)"Application %s failed during staging", (Object[])new Object[]{application})).otherwise(DelayTimeoutException.class, t -> ExceptionUtils.illegalState((String)"Application %s timed out during staging", (Object[])new Object[]{application})).then();
    }
}

