/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.buildpacks;

import java.nio.file.Path;
import java.util.Optional;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.Resource;
import org.cloudfoundry.client.v2.buildpacks.BuildpackEntity;
import org.cloudfoundry.client.v2.buildpacks.BuildpackResource;
import org.cloudfoundry.client.v2.buildpacks.CreateBuildpackResponse;
import org.cloudfoundry.client.v2.buildpacks.ListBuildpacksRequest;
import org.cloudfoundry.client.v2.buildpacks.UploadBuildpackRequest;
import org.cloudfoundry.client.v2.buildpacks.UploadBuildpackResponse;
import org.cloudfoundry.operations.buildpacks.Buildpack;
import org.cloudfoundry.operations.buildpacks.Buildpacks;
import org.cloudfoundry.operations.buildpacks.CreateBuildpackRequest;
import org.cloudfoundry.util.PaginationUtils;
import org.cloudfoundry.util.ResourceUtils;
import org.cloudfoundry.util.tuple.TupleUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DefaultBuildpacks
implements Buildpacks {
    private final Mono<CloudFoundryClient> cloudFoundryClient;

    public DefaultBuildpacks(Mono<CloudFoundryClient> cloudFoundryClient) {
        this.cloudFoundryClient = cloudFoundryClient;
    }

    @Override
    public Mono<Void> create(CreateBuildpackRequest request) {
        return this.cloudFoundryClient.then(cloudFoundryClient -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultBuildpacks.requestCreateBuildpack(cloudFoundryClient, request.getName(), request.getPosition(), request.getEnable()))).then(TupleUtils.function((cloudFoundryClient, response) -> DefaultBuildpacks.requestUploadBuildpackBits(cloudFoundryClient, ResourceUtils.getId((Resource)response), request.getFileName(), request.getBuildpack()))).then().checkpoint();
    }

    @Override
    public Flux<Buildpack> list() {
        return this.cloudFoundryClient.flatMap(DefaultBuildpacks::requestBuildpacks).map(DefaultBuildpacks::toBuildpackResource).checkpoint();
    }

    private static Flux<BuildpackResource> requestBuildpacks(CloudFoundryClient cloudFoundryClient) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.buildpacks().list(ListBuildpacksRequest.builder().page(page).build()));
    }

    private static Mono<CreateBuildpackResponse> requestCreateBuildpack(CloudFoundryClient cloudFoundryClient, String buildpackName, Integer position, Boolean enable) {
        return cloudFoundryClient.buildpacks().create(org.cloudfoundry.client.v2.buildpacks.CreateBuildpackRequest.builder().name(buildpackName).position(position).enabled(Optional.ofNullable(enable).orElse(true)).build());
    }

    private static Mono<UploadBuildpackResponse> requestUploadBuildpackBits(CloudFoundryClient cloudFoundryClient, String buildpackId, String filename, Path buildpack) {
        return cloudFoundryClient.buildpacks().upload(UploadBuildpackRequest.builder().buildpackId(buildpackId).filename(filename).buildpack(buildpack).build());
    }

    private static Buildpack toBuildpackResource(BuildpackResource resource) {
        BuildpackEntity entity = (BuildpackEntity)ResourceUtils.getEntity((Resource)resource);
        return Buildpack.builder().enabled(entity.getEnabled()).filename(entity.getFilename()).id(ResourceUtils.getId((Resource)resource)).locked(entity.getLocked()).name(entity.getName()).position(entity.getPosition()).build();
    }
}

