/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.routes;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.routes._CreateRouteRequest;

public final class CreateRouteRequest
extends _CreateRouteRequest {
    private final String domain;
    @Nullable
    private final String host;
    @Nullable
    private final String path;
    @Nullable
    private final Integer port;
    @Nullable
    private final Boolean randomPort;
    private final String space;

    private CreateRouteRequest(Builder builder) {
        this.domain = builder.domain;
        this.host = builder.host;
        this.path = builder.path;
        this.port = builder.port;
        this.randomPort = builder.randomPort;
        this.space = builder.space;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    @Nullable
    public String getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Override
    @Nullable
    public Boolean getRandomPort() {
        return this.randomPort;
    }

    @Override
    public String getSpace() {
        return this.space;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateRouteRequest && this.equalTo((CreateRouteRequest)another);
    }

    private boolean equalTo(CreateRouteRequest another) {
        return this.domain.equals(another.domain) && Objects.equals(this.host, another.host) && Objects.equals(this.path, another.path) && Objects.equals(this.port, another.port) && Objects.equals(this.randomPort, another.randomPort) && this.space.equals(another.space);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.domain.hashCode();
        h = h * 17 + Objects.hashCode(this.host);
        h = h * 17 + Objects.hashCode(this.path);
        h = h * 17 + Objects.hashCode(this.port);
        h = h * 17 + Objects.hashCode(this.randomPort);
        h = h * 17 + this.space.hashCode();
        return h;
    }

    public String toString() {
        return "CreateRouteRequest{domain=" + this.domain + ", host=" + this.host + ", path=" + this.path + ", port=" + this.port + ", randomPort=" + this.randomPort + ", space=" + this.space + "}";
    }

    private static CreateRouteRequest validate(CreateRouteRequest instance) {
        instance.checkSetup();
        instance.checkPorts();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DOMAIN = 1L;
        private static final long INIT_BIT_SPACE = 2L;
        private long initBits = 3L;
        private String domain;
        private String host;
        private String path;
        private Integer port;
        private Boolean randomPort;
        private String space;

        private Builder() {
        }

        public final Builder from(CreateRouteRequest instance) {
            return this.from((_CreateRouteRequest)instance);
        }

        final Builder from(_CreateRouteRequest instance) {
            Boolean randomPortValue;
            Integer portValue;
            String pathValue;
            Objects.requireNonNull(instance, "instance");
            this.domain(instance.getDomain());
            String hostValue = instance.getHost();
            if (hostValue != null) {
                this.host(hostValue);
            }
            if ((pathValue = instance.getPath()) != null) {
                this.path(pathValue);
            }
            if ((portValue = instance.getPort()) != null) {
                this.port(portValue);
            }
            if ((randomPortValue = instance.getRandomPort()) != null) {
                this.randomPort(randomPortValue);
            }
            this.space(instance.getSpace());
            return this;
        }

        public final Builder domain(String domain) {
            this.domain = Objects.requireNonNull(domain, "domain");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        public final Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        public final Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        public final Builder randomPort(@Nullable Boolean randomPort) {
            this.randomPort = randomPort;
            return this;
        }

        public final Builder space(String space) {
            this.space = Objects.requireNonNull(space, "space");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CreateRouteRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return CreateRouteRequest.validate(new CreateRouteRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("domain");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("space");
            }
            return "Cannot build CreateRouteRequest, some of required attributes are not set " + attributes;
        }
    }
}

