/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.services._BindRouteServiceInstanceRequest;

public final class BindRouteServiceInstanceRequest
extends _BindRouteServiceInstanceRequest {
    private final String domainName;
    @Nullable
    private final String hostname;
    @Nullable
    private final Map<String, Object> parameters;
    @Nullable
    private final String path;
    private final String serviceInstanceName;

    private BindRouteServiceInstanceRequest(Builder builder) {
        this.domainName = builder.domainName;
        this.hostname = builder.hostname;
        this.parameters = builder.parameters == null ? null : BindRouteServiceInstanceRequest.createUnmodifiableMap(false, false, builder.parameters);
        this.path = builder.path;
        this.serviceInstanceName = builder.serviceInstanceName;
    }

    @Override
    public String getDomainName() {
        return this.domainName;
    }

    @Override
    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    @Override
    @Nullable
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    @Nullable
    public String getPath() {
        return this.path;
    }

    @Override
    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BindRouteServiceInstanceRequest && this.equalTo((BindRouteServiceInstanceRequest)another);
    }

    private boolean equalTo(BindRouteServiceInstanceRequest another) {
        return this.domainName.equals(another.domainName) && Objects.equals(this.hostname, another.hostname) && Objects.equals(this.parameters, another.parameters) && Objects.equals(this.path, another.path) && this.serviceInstanceName.equals(another.serviceInstanceName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.domainName.hashCode();
        h = h * 17 + Objects.hashCode(this.hostname);
        h = h * 17 + Objects.hashCode(this.parameters);
        h = h * 17 + Objects.hashCode(this.path);
        h = h * 17 + this.serviceInstanceName.hashCode();
        return h;
    }

    public String toString() {
        return "BindRouteServiceInstanceRequest{domainName=" + this.domainName + ", hostname=" + this.hostname + ", parameters=" + this.parameters + ", path=" + this.path + ", serviceInstanceName=" + this.serviceInstanceName + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_DOMAIN_NAME = 1L;
        private static final long INIT_BIT_SERVICE_INSTANCE_NAME = 2L;
        private long initBits = 3L;
        private String domainName;
        private String hostname;
        private Map<String, Object> parameters = null;
        private String path;
        private String serviceInstanceName;

        private Builder() {
        }

        public final Builder from(BindRouteServiceInstanceRequest instance) {
            return this.from((_BindRouteServiceInstanceRequest)instance);
        }

        final Builder from(_BindRouteServiceInstanceRequest instance) {
            String pathValue;
            Map<String, Object> parametersValue;
            Objects.requireNonNull(instance, "instance");
            this.domainName(instance.getDomainName());
            String hostnameValue = instance.getHostname();
            if (hostnameValue != null) {
                this.hostname(hostnameValue);
            }
            if ((parametersValue = instance.getParameters()) != null) {
                this.putAllParameters(parametersValue);
            }
            if ((pathValue = instance.getPath()) != null) {
                this.path(pathValue);
            }
            this.serviceInstanceName(instance.getServiceInstanceName());
            return this;
        }

        public final Builder domainName(String domainName) {
            this.domainName = Objects.requireNonNull(domainName, "domainName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder hostname(@Nullable String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final Builder parameter(String key, Object value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            this.parameters.put(key, value);
            return this;
        }

        public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.parameters.put(k, v);
            return this;
        }

        public final Builder parameters(@Nullable Map<String, ? extends Object> parameters) {
            if (parameters == null) {
                this.parameters = null;
                return this;
            }
            this.parameters = new LinkedHashMap<String, Object>();
            return this.putAllParameters(parameters);
        }

        public final Builder putAllParameters(Map<String, ? extends Object> parameters) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.parameters.put(k, v);
            }
            return this;
        }

        public final Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = Objects.requireNonNull(serviceInstanceName, "serviceInstanceName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public BindRouteServiceInstanceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new BindRouteServiceInstanceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("domainName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("serviceInstanceName");
            }
            return "Cannot build BindRouteServiceInstanceRequest, some of required attributes are not set " + attributes;
        }
    }
}

