/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.services._CreateServiceKeyRequest;

public final class CreateServiceKeyRequest
extends _CreateServiceKeyRequest {
    @Nullable
    private final Map<String, Object> parameters;
    private final String serviceInstanceName;
    private final String serviceKeyName;

    private CreateServiceKeyRequest(Builder builder) {
        this.parameters = builder.parameters == null ? null : CreateServiceKeyRequest.createUnmodifiableMap(false, false, builder.parameters);
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceKeyName = builder.serviceKeyName;
    }

    @Override
    @Nullable
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    @Override
    public String getServiceKeyName() {
        return this.serviceKeyName;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateServiceKeyRequest && this.equalTo((CreateServiceKeyRequest)another);
    }

    private boolean equalTo(CreateServiceKeyRequest another) {
        return Objects.equals(this.parameters, another.parameters) && this.serviceInstanceName.equals(another.serviceInstanceName) && this.serviceKeyName.equals(another.serviceKeyName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.parameters);
        h = h * 17 + this.serviceInstanceName.hashCode();
        h = h * 17 + this.serviceKeyName.hashCode();
        return h;
    }

    public String toString() {
        return "CreateServiceKeyRequest{parameters=" + this.parameters + ", serviceInstanceName=" + this.serviceInstanceName + ", serviceKeyName=" + this.serviceKeyName + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_SERVICE_INSTANCE_NAME = 1L;
        private static final long INIT_BIT_SERVICE_KEY_NAME = 2L;
        private long initBits = 3L;
        private Map<String, Object> parameters = null;
        private String serviceInstanceName;
        private String serviceKeyName;

        private Builder() {
        }

        public final Builder from(CreateServiceKeyRequest instance) {
            return this.from((_CreateServiceKeyRequest)instance);
        }

        final Builder from(_CreateServiceKeyRequest instance) {
            Objects.requireNonNull(instance, "instance");
            Map<String, Object> parametersValue = instance.getParameters();
            if (parametersValue != null) {
                this.putAllParameters(parametersValue);
            }
            this.serviceInstanceName(instance.getServiceInstanceName());
            this.serviceKeyName(instance.getServiceKeyName());
            return this;
        }

        public final Builder parameter(String key, Object value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            this.parameters.put(key, value);
            return this;
        }

        public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.parameters.put(k, v);
            return this;
        }

        public final Builder parameters(@Nullable Map<String, ? extends Object> parameters) {
            if (parameters == null) {
                this.parameters = null;
                return this;
            }
            this.parameters = new LinkedHashMap<String, Object>();
            return this.putAllParameters(parameters);
        }

        public final Builder putAllParameters(Map<String, ? extends Object> parameters) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.parameters.put(k, v);
            }
            return this;
        }

        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = Objects.requireNonNull(serviceInstanceName, "serviceInstanceName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder serviceKeyName(String serviceKeyName) {
            this.serviceKeyName = Objects.requireNonNull(serviceKeyName, "serviceKeyName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CreateServiceKeyRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateServiceKeyRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serviceInstanceName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("serviceKeyName");
            }
            return "Cannot build CreateServiceKeyRequest, some of required attributes are not set " + attributes;
        }
    }
}

