/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.services.AbstractServiceInstanceSummary;
import org.cloudfoundry.operations.services.ServiceInstanceType;
import org.cloudfoundry.operations.services._ServiceInstanceSummary;

public final class ServiceInstanceSummary
extends _ServiceInstanceSummary {
    private final List<String> applications;
    private final String id;
    @Nullable
    private final String lastOperation;
    private final String name;
    @Nullable
    private final String plan;
    @Nullable
    private final String service;
    private final ServiceInstanceType type;

    private ServiceInstanceSummary(Builder builder) {
        this.applications = ServiceInstanceSummary.createUnmodifiableList(true, builder.applications);
        this.id = builder.id;
        this.lastOperation = builder.lastOperation;
        this.name = builder.name;
        this.plan = builder.plan;
        this.service = builder.service;
        this.type = builder.type;
    }

    @Override
    public List<String> getApplications() {
        return this.applications;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getLastOperation() {
        return this.lastOperation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getPlan() {
        return this.plan;
    }

    @Override
    @Nullable
    public String getService() {
        return this.service;
    }

    @Override
    public ServiceInstanceType getType() {
        return this.type;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ServiceInstanceSummary && this.equalTo((ServiceInstanceSummary)another);
    }

    private boolean equalTo(ServiceInstanceSummary another) {
        return this.applications.equals(another.applications) && this.id.equals(another.id) && Objects.equals(this.lastOperation, another.lastOperation) && this.name.equals(another.name) && Objects.equals(this.plan, another.plan) && Objects.equals(this.service, another.service) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.applications.hashCode();
        h = h * 17 + this.id.hashCode();
        h = h * 17 + Objects.hashCode(this.lastOperation);
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode(this.plan);
        h = h * 17 + Objects.hashCode(this.service);
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "ServiceInstanceSummary{applications=" + this.applications + ", id=" + this.id + ", lastOperation=" + this.lastOperation + ", name=" + this.name + ", plan=" + this.plan + ", service=" + this.service + ", type=" + (Object)((Object)this.type) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private long initBits = 7L;
        private List<String> applications = new ArrayList<String>();
        private String id;
        private String lastOperation;
        private String name;
        private String plan;
        private String service;
        private ServiceInstanceType type;

        private Builder() {
        }

        public final Builder from(AbstractServiceInstanceSummary instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ServiceInstanceSummary instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ServiceInstanceSummary instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof AbstractServiceInstanceSummary) {
                String lastOperationValue;
                AbstractServiceInstanceSummary instance = (AbstractServiceInstanceSummary)object;
                String serviceValue = instance.getService();
                if (serviceValue != null) {
                    this.service(serviceValue);
                }
                if ((lastOperationValue = instance.getLastOperation()) != null) {
                    this.lastOperation(lastOperationValue);
                }
                this.name(instance.getName());
                this.id(instance.getId());
                this.type(instance.getType());
                String planValue = instance.getPlan();
                if (planValue != null) {
                    this.plan(planValue);
                }
                this.addAllApplications(instance.getApplications());
            }
        }

        public final Builder application(String element) {
            this.applications.add(Objects.requireNonNull(element, "applications element"));
            return this;
        }

        public final Builder application(String ... elements) {
            for (String element : elements) {
                this.applications.add(Objects.requireNonNull(element, "applications element"));
            }
            return this;
        }

        public final Builder applications(Iterable<String> elements) {
            this.applications.clear();
            return this.addAllApplications(elements);
        }

        public final Builder addAllApplications(Iterable<String> elements) {
            for (String element : elements) {
                this.applications.add(Objects.requireNonNull(element, "applications element"));
            }
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder lastOperation(@Nullable String lastOperation) {
            this.lastOperation = lastOperation;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder plan(@Nullable String plan) {
            this.plan = plan;
            return this;
        }

        public final Builder service(@Nullable String service) {
            this.service = service;
            return this;
        }

        public final Builder type(ServiceInstanceType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ServiceInstanceSummary build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ServiceInstanceSummary(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build ServiceInstanceSummary, some of required attributes are not set " + attributes;
        }
    }
}

