/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.spaces;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.Resource;
import org.cloudfoundry.client.v2.applications.ApplicationEntity;
import org.cloudfoundry.client.v2.applications.ApplicationResource;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationUserByUsernameRequest;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationUserByUsernameResponse;
import org.cloudfoundry.client.v2.organizations.GetOrganizationRequest;
import org.cloudfoundry.client.v2.organizations.GetOrganizationResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationPrivateDomainsRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationSpaceQuotaDefinitionsRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationSpacesRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationsRequest;
import org.cloudfoundry.client.v2.organizations.OrganizationEntity;
import org.cloudfoundry.client.v2.organizations.OrganizationResource;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomainResource;
import org.cloudfoundry.client.v2.securitygroups.RuleEntity;
import org.cloudfoundry.client.v2.securitygroups.SecurityGroupEntity;
import org.cloudfoundry.client.v2.securitygroups.SecurityGroupResource;
import org.cloudfoundry.client.v2.services.ServiceEntity;
import org.cloudfoundry.client.v2.services.ServiceResource;
import org.cloudfoundry.client.v2.shareddomains.ListSharedDomainsRequest;
import org.cloudfoundry.client.v2.shareddomains.SharedDomainResource;
import org.cloudfoundry.client.v2.spacequotadefinitions.GetSpaceQuotaDefinitionRequest;
import org.cloudfoundry.client.v2.spacequotadefinitions.GetSpaceQuotaDefinitionResponse;
import org.cloudfoundry.client.v2.spacequotadefinitions.SpaceQuotaDefinitionEntity;
import org.cloudfoundry.client.v2.spacequotadefinitions.SpaceQuotaDefinitionResource;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceDeveloperByUsernameRequest;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceDeveloperByUsernameResponse;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceManagerByUsernameRequest;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceManagerByUsernameResponse;
import org.cloudfoundry.client.v2.spaces.CreateSpaceResponse;
import org.cloudfoundry.client.v2.spaces.DeleteSpaceResponse;
import org.cloudfoundry.client.v2.spaces.ListSpaceApplicationsRequest;
import org.cloudfoundry.client.v2.spaces.ListSpaceSecurityGroupsRequest;
import org.cloudfoundry.client.v2.spaces.ListSpaceServicesRequest;
import org.cloudfoundry.client.v2.spaces.ListSpacesRequest;
import org.cloudfoundry.client.v2.spaces.SpaceEntity;
import org.cloudfoundry.client.v2.spaces.SpaceResource;
import org.cloudfoundry.client.v2.spaces.UpdateSpaceRequest;
import org.cloudfoundry.client.v2.spaces.UpdateSpaceResponse;
import org.cloudfoundry.operations.spaceadmin.SpaceQuota;
import org.cloudfoundry.operations.spaces.AllowSpaceSshRequest;
import org.cloudfoundry.operations.spaces.CreateSpaceRequest;
import org.cloudfoundry.operations.spaces.DeleteSpaceRequest;
import org.cloudfoundry.operations.spaces.DisallowSpaceSshRequest;
import org.cloudfoundry.operations.spaces.GetSpaceRequest;
import org.cloudfoundry.operations.spaces.RenameSpaceRequest;
import org.cloudfoundry.operations.spaces.Rule;
import org.cloudfoundry.operations.spaces.SecurityGroup;
import org.cloudfoundry.operations.spaces.SpaceDetail;
import org.cloudfoundry.operations.spaces.SpaceSshAllowedRequest;
import org.cloudfoundry.operations.spaces.SpaceSummary;
import org.cloudfoundry.operations.spaces.Spaces;
import org.cloudfoundry.util.ExceptionUtils;
import org.cloudfoundry.util.JobUtils;
import org.cloudfoundry.util.PaginationUtils;
import org.cloudfoundry.util.ResourceUtils;
import org.cloudfoundry.util.tuple.TupleUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

public final class DefaultSpaces
implements Spaces {
    private final Mono<CloudFoundryClient> cloudFoundryClient;
    private final Mono<String> organizationId;
    private final Mono<String> username;

    public DefaultSpaces(Mono<CloudFoundryClient> cloudFoundryClient, Mono<String> organizationId, Mono<String> username) {
        this.cloudFoundryClient = cloudFoundryClient;
        this.organizationId = organizationId;
        this.username = username;
    }

    @Override
    public Mono<Void> allowSsh(AllowSpaceSshRequest request) {
        return Mono.when(this.cloudFoundryClient, this.organizationId).then(TupleUtils.function((cloudFoundryClient, organizationId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultSpaces.getOrganizationSpaceIdWhere(cloudFoundryClient, organizationId, request.getName(), DefaultSpaces.sshEnabled(false))))).then(TupleUtils.function((cloudFoundryClient, spaceId) -> DefaultSpaces.requestUpdateSpaceSsh(cloudFoundryClient, spaceId, true))).then().checkpoint();
    }

    @Override
    public Mono<Void> create(CreateSpaceRequest request) {
        return Mono.when(this.cloudFoundryClient, this.username).then(TupleUtils.function((cloudFoundryClient, username) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), (Mono)Mono.just((Object)username), DefaultSpaces.getOrganizationIdOrDefault(cloudFoundryClient, request.getOrganization(), this.organizationId)))).then(TupleUtils.function((cloudFoundryClient, username, organizationId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), (Mono)Mono.just((Object)username), (Mono)Mono.just((Object)organizationId), DefaultSpaces.getOptionalSpaceQuotaId(cloudFoundryClient, organizationId, request.getSpaceQuota())))).then(TupleUtils.function((cloudFoundryClient, username, organizationId, spaceQuotaId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), (Mono)Mono.just((Object)organizationId), (Mono)DefaultSpaces.requestCreateSpace(cloudFoundryClient, organizationId, request.getName(), spaceQuotaId.orElse(null)).map(ResourceUtils::getId), (Mono)Mono.just((Object)username)))).then(TupleUtils.function((cloudFoundryClient, organizationId, spaceId, username) -> DefaultSpaces.requestAssociateOrganizationUserByUsername(cloudFoundryClient, organizationId, username).then(Mono.just((Object)Tuples.of((Object)cloudFoundryClient, (Object)organizationId, (Object)spaceId, (Object)username))))).then(TupleUtils.function((cloudFoundryClient, organizationId, spaceId, username) -> Mono.when(DefaultSpaces.requestAssociateSpaceManagerByUsername(cloudFoundryClient, spaceId, username), DefaultSpaces.requestAssociateSpaceDeveloperByUsername(cloudFoundryClient, spaceId, username)))).then().checkpoint();
    }

    @Override
    public Mono<Void> delete(DeleteSpaceRequest request) {
        return Mono.when(this.cloudFoundryClient, this.organizationId).then(TupleUtils.function((cloudFoundryClient, organizationId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultSpaces.getOrganizationSpaceId(cloudFoundryClient, organizationId, request.getName())))).then(TupleUtils.function(DefaultSpaces::deleteSpace)).checkpoint();
    }

    @Override
    public Mono<Void> disallowSsh(DisallowSpaceSshRequest request) {
        return Mono.when(this.cloudFoundryClient, this.organizationId).then(TupleUtils.function((cloudFoundryClient, organizationId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultSpaces.getOrganizationSpaceIdWhere(cloudFoundryClient, organizationId, request.getName(), DefaultSpaces.sshEnabled(true))))).then(TupleUtils.function((cloudFoundryClient, spaceId) -> DefaultSpaces.requestUpdateSpaceSsh(cloudFoundryClient, spaceId, false))).then().checkpoint();
    }

    @Override
    public Mono<SpaceDetail> get(GetSpaceRequest request) {
        return Mono.when(this.cloudFoundryClient, this.organizationId).then(TupleUtils.function((cloudFoundryClient, organizationId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultSpaces.getOrganizationSpace(cloudFoundryClient, organizationId, request.getName())))).then(TupleUtils.function((cloudFoundryClient, resource) -> DefaultSpaces.getSpaceDetail(cloudFoundryClient, resource, request))).checkpoint();
    }

    @Override
    public Flux<SpaceSummary> list() {
        return Mono.when(this.cloudFoundryClient, this.organizationId).flatMap(TupleUtils.function(DefaultSpaces::requestSpaces)).map(DefaultSpaces::toSpaceSummary).checkpoint();
    }

    @Override
    public Mono<Void> rename(RenameSpaceRequest request) {
        return Mono.when(this.cloudFoundryClient, this.organizationId).then(TupleUtils.function((cloudFoundryClient, organizationId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultSpaces.getOrganizationSpaceId(cloudFoundryClient, organizationId, request.getName())))).then(TupleUtils.function((cloudFoundryClient, spaceId) -> DefaultSpaces.requestUpdateSpace(cloudFoundryClient, spaceId, request.getNewName()))).then().checkpoint();
    }

    @Override
    public Mono<Boolean> sshAllowed(SpaceSshAllowedRequest request) {
        return Mono.when(this.cloudFoundryClient, this.organizationId).then(TupleUtils.function((cloudFoundryClient, organizationId) -> DefaultSpaces.getOrganizationSpace(cloudFoundryClient, organizationId, request.getName()))).map(resource -> ((SpaceEntity)ResourceUtils.getEntity((Resource)resource)).getAllowSsh()).checkpoint();
    }

    private static Mono<Void> deleteSpace(CloudFoundryClient cloudFoundryClient, String spaceId) {
        return DefaultSpaces.requestDeleteSpace(cloudFoundryClient, spaceId).then(job -> JobUtils.waitForCompletion((CloudFoundryClient)cloudFoundryClient, (Resource)job));
    }

    private static Mono<List<String>> getApplicationNames(CloudFoundryClient cloudFoundryClient, SpaceResource spaceResource) {
        return DefaultSpaces.requestSpaceApplications(cloudFoundryClient, ResourceUtils.getId((Resource)spaceResource)).map(applicationResource -> ((ApplicationEntity)ResourceUtils.getEntity((Resource)applicationResource)).getName()).collectList();
    }

    private static Mono<List<String>> getDomainNames(CloudFoundryClient cloudFoundryClient, SpaceResource spaceResource) {
        return DefaultSpaces.requestListPrivateDomains(cloudFoundryClient, spaceResource.getEntity().getOrganizationId()).map(resource -> resource.getEntity().getName()).mergeWith((Publisher)DefaultSpaces.requestListSharedDomains(cloudFoundryClient).map(resource -> resource.getEntity().getName())).collectList();
    }

    private static Mono<Optional<SpaceQuota>> getOptionalSpaceQuotaDefinition(CloudFoundryClient cloudFoundryClient, SpaceResource spaceResource) {
        String spaceQuotaDefinitionId = ((SpaceEntity)ResourceUtils.getEntity((Resource)spaceResource)).getSpaceQuotaDefinitionId();
        if (spaceQuotaDefinitionId == null) {
            return Mono.just(Optional.empty());
        }
        return DefaultSpaces.requestSpaceQuotaDefinition(cloudFoundryClient, spaceQuotaDefinitionId).map(DefaultSpaces::toSpaceQuotaDefinition).map(Optional::of);
    }

    private static Mono<Optional<String>> getOptionalSpaceQuotaId(CloudFoundryClient cloudFoundryClient, String organizationId, String spaceQuota) {
        if (spaceQuota == null) {
            return Mono.just(Optional.empty());
        }
        return DefaultSpaces.getSpaceQuota(cloudFoundryClient, organizationId, spaceQuota).map(ResourceUtils::getId).map(Optional::of);
    }

    private static Mono<OrganizationResource> getOrganization(CloudFoundryClient cloudFoundryClient, String organization) {
        return DefaultSpaces.requestOrganizations(cloudFoundryClient, organization).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Organization %s does not exist", (Object[])new Object[]{organization}));
    }

    private static Mono<String> getOrganizationId(CloudFoundryClient cloudFoundryClient, String organization) {
        return DefaultSpaces.getOrganization(cloudFoundryClient, organization).map(ResourceUtils::getId);
    }

    private static Mono<String> getOrganizationIdOrDefault(CloudFoundryClient cloudFoundryClient, String organizationName, Mono<String> organizationId) {
        return Optional.ofNullable(organizationName).map(organization -> DefaultSpaces.getOrganizationId(cloudFoundryClient, organization)).orElse(organizationId);
    }

    private static Mono<String> getOrganizationName(CloudFoundryClient cloudFoundryClient, SpaceResource resource) {
        return DefaultSpaces.requestOrganization(cloudFoundryClient, ((SpaceEntity)ResourceUtils.getEntity((Resource)resource)).getOrganizationId()).map(response -> ((OrganizationEntity)ResourceUtils.getEntity((Resource)response)).getName());
    }

    private static Mono<SpaceResource> getOrganizationSpace(CloudFoundryClient cloudFoundryClient, String organizationId, String space) {
        return DefaultSpaces.requestOrganizationSpaces(cloudFoundryClient, organizationId, space).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Space %s does not exist", (Object[])new Object[]{space}));
    }

    private static Mono<String> getOrganizationSpaceId(CloudFoundryClient cloudFoundryClient, String organizationId, String space) {
        return DefaultSpaces.getOrganizationSpace(cloudFoundryClient, organizationId, space).map(ResourceUtils::getId);
    }

    private static Mono<String> getOrganizationSpaceIdWhere(CloudFoundryClient cloudFoundryClient, String organizationId, String space, Predicate<SpaceResource> predicate) {
        return DefaultSpaces.getOrganizationSpace(cloudFoundryClient, organizationId, space).filter(predicate).map(ResourceUtils::getId);
    }

    private static Mono<List<SecurityGroupEntity>> getSecurityGroups(CloudFoundryClient cloudFoundryClient, SpaceResource spaceResource, boolean withRules) {
        return DefaultSpaces.requestSpaceSecurityGroups(cloudFoundryClient, ResourceUtils.getId((Resource)spaceResource)).map(securityGroupResource -> {
            SecurityGroupEntity entity = (SecurityGroupEntity)ResourceUtils.getEntity((Resource)securityGroupResource);
            if (!withRules) {
                entity = SecurityGroupEntity.builder().name(entity.getName()).runningDefault(entity.getRunningDefault()).spacesUrl(entity.getSpacesUrl()).stagingDefault(entity.getStagingDefault()).build();
            }
            return entity;
        }).collectList();
    }

    private static Mono<List<String>> getServiceNames(CloudFoundryClient cloudFoundryClient, SpaceResource spaceResource) {
        return DefaultSpaces.requestSpaceServices(cloudFoundryClient, ResourceUtils.getId((Resource)spaceResource)).map(serviceResource -> ((ServiceEntity)ResourceUtils.getEntity((Resource)serviceResource)).getLabel()).collectList();
    }

    private static Mono<SpaceDetail> getSpaceDetail(CloudFoundryClient cloudFoundryClient, SpaceResource resource, GetSpaceRequest request) {
        return Mono.when(DefaultSpaces.getApplicationNames(cloudFoundryClient, resource), DefaultSpaces.getDomainNames(cloudFoundryClient, resource), DefaultSpaces.getOrganizationName(cloudFoundryClient, resource), DefaultSpaces.getSecurityGroups(cloudFoundryClient, resource, Optional.ofNullable(request.getSecurityGroupRules()).orElse(false)), DefaultSpaces.getServiceNames(cloudFoundryClient, resource), DefaultSpaces.getOptionalSpaceQuotaDefinition(cloudFoundryClient, resource)).map(TupleUtils.function((applications, domains, organization, securityGroups, services, spaceQuota) -> DefaultSpaces.toSpaceDetail(applications, domains, organization, resource, securityGroups, services, spaceQuota)));
    }

    private static Mono<SpaceQuotaDefinitionResource> getSpaceQuota(CloudFoundryClient cloudFoundryClient, String organizationId, String spaceQuota) {
        return DefaultSpaces.requestOrganizationSpaceQuotas(cloudFoundryClient, organizationId, spaceQuota).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Space quota definition %s does not exist", (Object[])new Object[]{spaceQuota}));
    }

    private static Mono<AssociateOrganizationUserByUsernameResponse> requestAssociateOrganizationUserByUsername(CloudFoundryClient cloudFoundryClient, String organizationId, String username) {
        return cloudFoundryClient.organizations().associateUserByUsername(AssociateOrganizationUserByUsernameRequest.builder().organizationId(organizationId).username(username).build());
    }

    private static Mono<AssociateSpaceDeveloperByUsernameResponse> requestAssociateSpaceDeveloperByUsername(CloudFoundryClient cloudFoundryClient, String spaceId, String username) {
        return cloudFoundryClient.spaces().associateDeveloperByUsername(AssociateSpaceDeveloperByUsernameRequest.builder().spaceId(spaceId).username(username).build());
    }

    private static Mono<AssociateSpaceManagerByUsernameResponse> requestAssociateSpaceManagerByUsername(CloudFoundryClient cloudFoundryClient, String spaceId, String username) {
        return cloudFoundryClient.spaces().associateManagerByUsername(AssociateSpaceManagerByUsernameRequest.builder().spaceId(spaceId).username(username).build());
    }

    private static Mono<CreateSpaceResponse> requestCreateSpace(CloudFoundryClient cloudFoundryClient, String organizationId, String space, String spaceQuotaId) {
        return cloudFoundryClient.spaces().create(org.cloudfoundry.client.v2.spaces.CreateSpaceRequest.builder().name(space).organizationId(organizationId).spaceQuotaDefinitionId(spaceQuotaId).build());
    }

    private static Mono<DeleteSpaceResponse> requestDeleteSpace(CloudFoundryClient cloudFoundryClient, String spaceId) {
        return cloudFoundryClient.spaces().delete(org.cloudfoundry.client.v2.spaces.DeleteSpaceRequest.builder().async(Boolean.valueOf(true)).spaceId(spaceId).build());
    }

    private static Flux<PrivateDomainResource> requestListPrivateDomains(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().listPrivateDomains(ListOrganizationPrivateDomainsRequest.builder().organizationId(organizationId).page(page).build()));
    }

    private static Flux<SharedDomainResource> requestListSharedDomains(CloudFoundryClient cloudFoundryClient) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.sharedDomains().list(ListSharedDomainsRequest.builder().page(page).build()));
    }

    private static Mono<GetOrganizationResponse> requestOrganization(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return cloudFoundryClient.organizations().get(GetOrganizationRequest.builder().organizationId(organizationId).build());
    }

    private static Flux<SpaceQuotaDefinitionResource> requestOrganizationSpaceQuotas(CloudFoundryClient cloudFoundryClient, String organizationId, String spaceQuota) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().listSpaceQuotaDefinitions(ListOrganizationSpaceQuotaDefinitionsRequest.builder().page(page).organizationId(organizationId).build())).filter(resource -> ((SpaceQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)resource)).getName().equals(spaceQuota));
    }

    private static Flux<SpaceResource> requestOrganizationSpaces(CloudFoundryClient cloudFoundryClient, String organizationId, String space) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().listSpaces(ListOrganizationSpacesRequest.builder().name(space).organizationId(organizationId).page(page).build()));
    }

    private static Flux<OrganizationResource> requestOrganizations(CloudFoundryClient cloudFoundryClient, String organizationName) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().list(ListOrganizationsRequest.builder().name(organizationName).page(page).build()));
    }

    private static Flux<ApplicationResource> requestSpaceApplications(CloudFoundryClient cloudFoundryClient, String spaceId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.spaces().listApplications(ListSpaceApplicationsRequest.builder().page(page).spaceId(spaceId).build()));
    }

    private static Mono<GetSpaceQuotaDefinitionResponse> requestSpaceQuotaDefinition(CloudFoundryClient cloudFoundryClient, String spaceQuotaDefinitionId) {
        return cloudFoundryClient.spaceQuotaDefinitions().get(GetSpaceQuotaDefinitionRequest.builder().spaceQuotaDefinitionId(spaceQuotaDefinitionId).build());
    }

    private static Flux<SecurityGroupResource> requestSpaceSecurityGroups(CloudFoundryClient cloudFoundryClient, String spaceId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.spaces().listSecurityGroups(ListSpaceSecurityGroupsRequest.builder().spaceId(spaceId).page(page).build()));
    }

    private static Flux<ServiceResource> requestSpaceServices(CloudFoundryClient cloudFoundryClient, String spaceId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.spaces().listServices(ListSpaceServicesRequest.builder().page(page).spaceId(spaceId).build()));
    }

    private static Flux<SpaceResource> requestSpaces(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.spaces().list(ListSpacesRequest.builder().organizationId(organizationId).page(page).build()));
    }

    private static Mono<UpdateSpaceResponse> requestUpdateSpace(CloudFoundryClient cloudFoundryClient, String spaceId, String newName) {
        return cloudFoundryClient.spaces().update(UpdateSpaceRequest.builder().name(newName).spaceId(spaceId).build());
    }

    private static Mono<UpdateSpaceResponse> requestUpdateSpaceSsh(CloudFoundryClient cloudFoundryClient, String spaceId, Boolean allowed) {
        return cloudFoundryClient.spaces().update(UpdateSpaceRequest.builder().allowSsh(allowed).spaceId(spaceId).build());
    }

    private static Predicate<SpaceResource> sshEnabled(Boolean enabled) {
        return resource -> enabled.equals(((SpaceEntity)ResourceUtils.getEntity((Resource)resource)).getAllowSsh());
    }

    private static SpaceDetail toSpaceDetail(List<String> applications, List<String> domains, String organization, SpaceResource resource, List<SecurityGroupEntity> securityGroups, List<String> services, Optional<SpaceQuota> spaceQuota) {
        return SpaceDetail.builder().applications(applications).domains(domains).id(ResourceUtils.getId((Resource)resource)).name(((SpaceEntity)ResourceUtils.getEntity((Resource)resource)).getName()).organization(organization).securityGroups(DefaultSpaces.toSpaceDetailSecurityGroups(securityGroups)).services(services).spaceQuota(spaceQuota).build();
    }

    private static List<Rule> toSpaceDetailSecurityGroupRules(List<RuleEntity> rules) {
        return Optional.ofNullable(rules).map(r -> r.stream().map(ruleEntity -> Rule.builder().destination(ruleEntity.getDestination()).ports(ruleEntity.getPorts()).protocol(ruleEntity.getProtocol()).build()).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private static List<SecurityGroup> toSpaceDetailSecurityGroups(List<SecurityGroupEntity> securityGroups) {
        return securityGroups.stream().map(entity -> SecurityGroup.builder().name(entity.getName()).rules(DefaultSpaces.toSpaceDetailSecurityGroupRules(entity.getRules())).build()).collect(Collectors.toList());
    }

    private static SpaceQuota toSpaceQuotaDefinition(Resource<SpaceQuotaDefinitionEntity> resource) {
        SpaceQuotaDefinitionEntity entity = (SpaceQuotaDefinitionEntity)ResourceUtils.getEntity(resource);
        return SpaceQuota.builder().id(ResourceUtils.getId(resource)).instanceMemoryLimit(entity.getInstanceMemoryLimit()).name(entity.getName()).organizationId(entity.getOrganizationId()).paidServicePlans(entity.getNonBasicServicesAllowed()).totalMemoryLimit(entity.getMemoryLimit()).totalRoutes(entity.getTotalRoutes()).totalServiceInstances(entity.getTotalServices()).build();
    }

    private static SpaceSummary toSpaceSummary(SpaceResource resource) {
        return SpaceSummary.builder().id(ResourceUtils.getId((Resource)resource)).name(((SpaceEntity)ResourceUtils.getEntity((Resource)resource)).getName()).build();
    }
}

