/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.spaces;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.spaces._GetSpaceRequest;

public final class GetSpaceRequest
extends _GetSpaceRequest {
    private final String name;
    @Nullable
    private final Boolean securityGroupRules;

    private GetSpaceRequest(Builder builder) {
        this.name = builder.name;
        this.securityGroupRules = builder.securityGroupRules;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Boolean getSecurityGroupRules() {
        return this.securityGroupRules;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetSpaceRequest && this.equalTo((GetSpaceRequest)another);
    }

    private boolean equalTo(GetSpaceRequest another) {
        return this.name.equals(another.name) && Objects.equals(this.securityGroupRules, another.securityGroupRules);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode(this.securityGroupRules);
        return h;
    }

    public String toString() {
        return "GetSpaceRequest{name=" + this.name + ", securityGroupRules=" + this.securityGroupRules + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String name;
        private Boolean securityGroupRules;

        private Builder() {
        }

        public final Builder from(GetSpaceRequest instance) {
            return this.from((_GetSpaceRequest)instance);
        }

        final Builder from(_GetSpaceRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            Boolean securityGroupRulesValue = instance.getSecurityGroupRules();
            if (securityGroupRulesValue != null) {
                this.securityGroupRules(securityGroupRulesValue);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder securityGroupRules(@Nullable Boolean securityGroupRules) {
            this.securityGroupRules = securityGroupRules;
            return this;
        }

        public GetSpaceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetSpaceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build GetSpaceRequest, some of required attributes are not set " + attributes;
        }
    }
}

