/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.spaces;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.securitygroups.Protocol;
import org.cloudfoundry.operations.spaces._Rule;

public final class Rule
extends _Rule {
    private final String destination;
    private final String ports;
    private final Protocol protocol;

    private Rule(Builder builder) {
        this.destination = builder.destination;
        this.ports = builder.ports;
        this.protocol = builder.protocol;
    }

    @Override
    public String getDestination() {
        return this.destination;
    }

    @Override
    public String getPorts() {
        return this.ports;
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Rule && this.equalTo((Rule)another);
    }

    private boolean equalTo(Rule another) {
        return this.destination.equals(another.destination) && this.ports.equals(another.ports) && this.protocol.equals((Object)another.protocol);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.destination.hashCode();
        h = h * 17 + this.ports.hashCode();
        h = h * 17 + this.protocol.hashCode();
        return h;
    }

    public String toString() {
        return "Rule{destination=" + this.destination + ", ports=" + this.ports + ", protocol=" + this.protocol + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DESTINATION = 1L;
        private static final long INIT_BIT_PORTS = 2L;
        private static final long INIT_BIT_PROTOCOL = 4L;
        private long initBits = 7L;
        private String destination;
        private String ports;
        private Protocol protocol;

        private Builder() {
        }

        public final Builder from(Rule instance) {
            return this.from((_Rule)instance);
        }

        final Builder from(_Rule instance) {
            Objects.requireNonNull(instance, "instance");
            this.destination(instance.getDestination());
            this.ports(instance.getPorts());
            this.protocol(instance.getProtocol());
            return this;
        }

        public final Builder destination(String destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ports(String ports) {
            this.ports = Objects.requireNonNull(ports, "ports");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder protocol(Protocol protocol) {
            this.protocol = Objects.requireNonNull(protocol, "protocol");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Rule build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Rule(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("destination");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ports");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("protocol");
            }
            return "Cannot build Rule, some of required attributes are not set " + attributes;
        }
    }
}

