/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.stacks;

import java.util.NoSuchElementException;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.Resource;
import org.cloudfoundry.client.v2.stacks.ListStacksRequest;
import org.cloudfoundry.client.v2.stacks.StackEntity;
import org.cloudfoundry.client.v2.stacks.StackResource;
import org.cloudfoundry.operations.stacks.GetStackRequest;
import org.cloudfoundry.operations.stacks.Stack;
import org.cloudfoundry.operations.stacks.Stacks;
import org.cloudfoundry.util.ExceptionUtils;
import org.cloudfoundry.util.PaginationUtils;
import org.cloudfoundry.util.ResourceUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DefaultStacks
implements Stacks {
    private final Mono<CloudFoundryClient> cloudFoundryClient;

    public DefaultStacks(Mono<CloudFoundryClient> cloudFoundryClient) {
        this.cloudFoundryClient = cloudFoundryClient;
    }

    @Override
    public Mono<Stack> get(GetStackRequest request) {
        return this.cloudFoundryClient.then(cloudFoundryClient -> DefaultStacks.getStack(cloudFoundryClient, request.getName())).map(this::toStack).checkpoint();
    }

    @Override
    public Flux<Stack> list() {
        return this.cloudFoundryClient.flatMap(DefaultStacks::requestStacks).map(this::toStack).checkpoint();
    }

    private static Mono<StackResource> getStack(CloudFoundryClient cloudFoundryClient, String stack) {
        return DefaultStacks.requestStack(cloudFoundryClient, stack).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Stack %s does not exist", (Object[])new Object[]{stack}));
    }

    private static Flux<StackResource> requestStack(CloudFoundryClient cloudFoundryClient, String stack) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.stacks().list(ListStacksRequest.builder().name(stack).page(page).build()));
    }

    private static Flux<StackResource> requestStacks(CloudFoundryClient cloudFoundryClient) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.stacks().list(ListStacksRequest.builder().page(page).build()));
    }

    private Stack toStack(StackResource stackResource) {
        return Stack.builder().description(((StackEntity)ResourceUtils.getEntity((Resource)stackResource)).getDescription()).id(ResourceUtils.getId((Resource)stackResource)).name(((StackEntity)ResourceUtils.getEntity((Resource)stackResource)).getName()).build();
    }
}

