package org.cloudfoundry.operations.applications;

import java.util.Date;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Information about an instance of an application
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_InstanceDetail"})
public final class InstanceDetail extends org.cloudfoundry.operations.applications._InstanceDetail {
  private final @Nullable Double cpu;
  private final @Nullable Long diskQuota;
  private final @Nullable Long diskUsage;
  private final @Nullable Long memoryQuota;
  private final @Nullable Long memoryUsage;
  private final @Nullable Date since;
  private final @Nullable String state;

  private InstanceDetail(InstanceDetail.Builder builder) {
    this.cpu = builder.cpu;
    this.diskQuota = builder.diskQuota;
    this.diskUsage = builder.diskUsage;
    this.memoryQuota = builder.memoryQuota;
    this.memoryUsage = builder.memoryUsage;
    this.since = builder.since;
    this.state = builder.state;
  }

  /**
   * The CPU consumption of this instance
   */
  @Override
  public @Nullable Double getCpu() {
    return cpu;
  }

  /**
   * The diskUsage quota, in bytes, of this instance
   */
  @Override
  public @Nullable Long getDiskQuota() {
    return diskQuota;
  }

  /**
   * The disk usage, in bytes, of this instance
   */
  @Override
  public @Nullable Long getDiskUsage() {
    return diskUsage;
  }

  /**
   * The memoryUsage quota, in bytes, of this instance
   */
  @Override
  public @Nullable Long getMemoryQuota() {
    return memoryQuota;
  }

  /**
   * The memory usage, in bytes, of this instance
   */
  @Override
  public @Nullable Long getMemoryUsage() {
    return memoryUsage;
  }

  /**
   * The time this instance was created
   */
  @Override
  public @Nullable Date getSince() {
    return since;
  }

  /**
   * The state of the instance
   */
  @Override
  public @Nullable String getState() {
    return state;
  }

  /**
   * This instance is equal to all instances of {@code InstanceDetail} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InstanceDetail
        && equalTo((InstanceDetail) another);
  }

  private boolean equalTo(InstanceDetail another) {
    return Objects.equals(cpu, another.cpu)
        && Objects.equals(diskQuota, another.diskQuota)
        && Objects.equals(diskUsage, another.diskUsage)
        && Objects.equals(memoryQuota, another.memoryQuota)
        && Objects.equals(memoryUsage, another.memoryUsage)
        && Objects.equals(since, another.since)
        && Objects.equals(state, another.state);
  }

  /**
   * Computes a hash code from attributes: {@code cpu}, {@code diskQuota}, {@code diskUsage}, {@code memoryQuota}, {@code memoryUsage}, {@code since}, {@code state}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(cpu);
    h += (h << 5) + Objects.hashCode(diskQuota);
    h += (h << 5) + Objects.hashCode(diskUsage);
    h += (h << 5) + Objects.hashCode(memoryQuota);
    h += (h << 5) + Objects.hashCode(memoryUsage);
    h += (h << 5) + Objects.hashCode(since);
    h += (h << 5) + Objects.hashCode(state);
    return h;
  }

  /**
   * Prints the immutable value {@code InstanceDetail} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InstanceDetail{"
        + "cpu=" + cpu
        + ", diskQuota=" + diskQuota
        + ", diskUsage=" + diskUsage
        + ", memoryQuota=" + memoryQuota
        + ", memoryUsage=" + memoryUsage
        + ", since=" + since
        + ", state=" + state
        + "}";
  }

  /**
   * Creates a builder for {@link InstanceDetail InstanceDetail}.
   * @return A new InstanceDetail builder
   */
  public static InstanceDetail.Builder builder() {
    return new InstanceDetail.Builder();
  }

  /**
   * Builds instances of type {@link InstanceDetail InstanceDetail}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Double cpu;
    private Long diskQuota;
    private Long diskUsage;
    private Long memoryQuota;
    private Long memoryUsage;
    private Date since;
    private String state;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InstanceDetail} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InstanceDetail instance) {
      return from((_InstanceDetail) instance);
    }

    /**
     * Copy abstract value type {@code _InstanceDetail} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_InstanceDetail instance) {
      Objects.requireNonNull(instance, "instance");
      Double cpuValue = instance.getCpu();
      if (cpuValue != null) {
        cpu(cpuValue);
      }
      Long diskQuotaValue = instance.getDiskQuota();
      if (diskQuotaValue != null) {
        diskQuota(diskQuotaValue);
      }
      Long diskUsageValue = instance.getDiskUsage();
      if (diskUsageValue != null) {
        diskUsage(diskUsageValue);
      }
      Long memoryQuotaValue = instance.getMemoryQuota();
      if (memoryQuotaValue != null) {
        memoryQuota(memoryQuotaValue);
      }
      Long memoryUsageValue = instance.getMemoryUsage();
      if (memoryUsageValue != null) {
        memoryUsage(memoryUsageValue);
      }
      Date sinceValue = instance.getSince();
      if (sinceValue != null) {
        since(sinceValue);
      }
      String stateValue = instance.getState();
      if (stateValue != null) {
        state(stateValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _InstanceDetail#getCpu() cpu} attribute.
     * @param cpu The value for cpu (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cpu(@Nullable Double cpu) {
      this.cpu = cpu;
      return this;
    }

    /**
     * Initializes the value for the {@link _InstanceDetail#getDiskQuota() diskQuota} attribute.
     * @param diskQuota The value for diskQuota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskQuota(@Nullable Long diskQuota) {
      this.diskQuota = diskQuota;
      return this;
    }

    /**
     * Initializes the value for the {@link _InstanceDetail#getDiskUsage() diskUsage} attribute.
     * @param diskUsage The value for diskUsage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskUsage(@Nullable Long diskUsage) {
      this.diskUsage = diskUsage;
      return this;
    }

    /**
     * Initializes the value for the {@link _InstanceDetail#getMemoryQuota() memoryQuota} attribute.
     * @param memoryQuota The value for memoryQuota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryQuota(@Nullable Long memoryQuota) {
      this.memoryQuota = memoryQuota;
      return this;
    }

    /**
     * Initializes the value for the {@link _InstanceDetail#getMemoryUsage() memoryUsage} attribute.
     * @param memoryUsage The value for memoryUsage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryUsage(@Nullable Long memoryUsage) {
      this.memoryUsage = memoryUsage;
      return this;
    }

    /**
     * Initializes the value for the {@link _InstanceDetail#getSince() since} attribute.
     * @param since The value for since (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder since(@Nullable Date since) {
      this.since = since;
      return this;
    }

    /**
     * Initializes the value for the {@link _InstanceDetail#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Builds a new {@link InstanceDetail InstanceDetail}.
     * @return An immutable instance of InstanceDetail
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public InstanceDetail build() {
      return new InstanceDetail(this);
    }
  }
}
