/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations;

import java.util.NoSuchElementException;
import java.util.Optional;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.organizations.ListOrganizationsRequest;
import org.cloudfoundry.client.v2.organizations.OrganizationResource;
import org.cloudfoundry.client.v2.spaces.ListSpacesRequest;
import org.cloudfoundry.client.v2.spaces.SpaceResource;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.advanced.Advanced;
import org.cloudfoundry.operations.advanced.DefaultAdvanced;
import org.cloudfoundry.operations.applications.Applications;
import org.cloudfoundry.operations.applications.DefaultApplications;
import org.cloudfoundry.operations.buildpacks.Buildpacks;
import org.cloudfoundry.operations.buildpacks.DefaultBuildpacks;
import org.cloudfoundry.operations.domains.DefaultDomains;
import org.cloudfoundry.operations.domains.Domains;
import org.cloudfoundry.operations.organizationadmin.DefaultOrganizationAdmin;
import org.cloudfoundry.operations.organizationadmin.OrganizationAdmin;
import org.cloudfoundry.operations.organizations.DefaultOrganizations;
import org.cloudfoundry.operations.organizations.Organizations;
import org.cloudfoundry.operations.routes.DefaultRoutes;
import org.cloudfoundry.operations.routes.Routes;
import org.cloudfoundry.operations.serviceadmin.DefaultServiceAdmin;
import org.cloudfoundry.operations.serviceadmin.ServiceAdmin;
import org.cloudfoundry.operations.services.DefaultServices;
import org.cloudfoundry.operations.services.Services;
import org.cloudfoundry.operations.spaceadmin.DefaultSpaceAdmin;
import org.cloudfoundry.operations.spaceadmin.SpaceAdmin;
import org.cloudfoundry.operations.spaces.DefaultSpaces;
import org.cloudfoundry.operations.spaces.Spaces;
import org.cloudfoundry.operations.stacks.DefaultStacks;
import org.cloudfoundry.operations.stacks.Stacks;
import org.cloudfoundry.routing.RoutingClient;
import org.cloudfoundry.uaa.UaaClient;
import org.cloudfoundry.util.ExceptionUtils;
import org.cloudfoundry.util.PaginationUtils;
import org.cloudfoundry.util.ResourceUtils;
import org.immutables.value.Value;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Value.Immutable
abstract class _DefaultCloudFoundryOperations
implements CloudFoundryOperations {
    _DefaultCloudFoundryOperations() {
    }

    @Override
    @Value.Derived
    public Advanced advanced() {
        return new DefaultAdvanced(this.getUaaClientPublisher());
    }

    @Override
    @Value.Derived
    public Applications applications() {
        return new DefaultApplications(this.getCloudFoundryClientPublisher(), this.getDopplerClientPublisher(), this.getSpaceId());
    }

    @Override
    @Value.Derived
    public Buildpacks buildpacks() {
        return new DefaultBuildpacks(this.getCloudFoundryClientPublisher());
    }

    @Override
    @Value.Derived
    public Domains domains() {
        return new DefaultDomains(this.getCloudFoundryClientPublisher(), this.getRoutingClientPublisher());
    }

    @Override
    @Value.Derived
    public OrganizationAdmin organizationAdmin() {
        return new DefaultOrganizationAdmin(this.getCloudFoundryClientPublisher());
    }

    @Override
    @Value.Derived
    public Organizations organizations() {
        return new DefaultOrganizations(this.getCloudFoundryClientPublisher(), this.getUsername());
    }

    @Override
    @Value.Derived
    public Routes routes() {
        return new DefaultRoutes(this.getCloudFoundryClientPublisher(), this.getOrganizationId(), this.getSpaceId());
    }

    @Override
    @Value.Derived
    public ServiceAdmin serviceAdmin() {
        return new DefaultServiceAdmin(this.getCloudFoundryClientPublisher(), this.getSpaceId());
    }

    @Override
    @Value.Derived
    public Services services() {
        return new DefaultServices(this.getCloudFoundryClientPublisher(), this.getOrganizationId(), this.getSpaceId());
    }

    @Override
    @Value.Derived
    public SpaceAdmin spaceAdmin() {
        return new DefaultSpaceAdmin(this.getCloudFoundryClientPublisher(), this.getOrganizationId());
    }

    @Override
    @Value.Derived
    public Spaces spaces() {
        return new DefaultSpaces(this.getCloudFoundryClientPublisher(), this.getOrganizationId(), this.getUsername());
    }

    @Override
    @Value.Derived
    public Stacks stacks() {
        return new DefaultStacks(this.getCloudFoundryClientPublisher());
    }

    @Nullable
    abstract CloudFoundryClient getCloudFoundryClient();

    @Value.Derived
    Mono<CloudFoundryClient> getCloudFoundryClientPublisher() {
        return Optional.ofNullable(this.getCloudFoundryClient()).map(Mono::just).orElse(Mono.error((Throwable)new IllegalStateException("CloudFoundryClient must be set")));
    }

    @Nullable
    abstract DopplerClient getDopplerClient();

    @Value.Derived
    Mono<DopplerClient> getDopplerClientPublisher() {
        return Optional.ofNullable(this.getDopplerClient()).map(Mono::just).orElse(Mono.error((Throwable)new IllegalStateException("DopplerClient must be set")));
    }

    @Nullable
    abstract String getOrganization();

    @Value.Derived
    Mono<String> getOrganizationId() {
        String organization = this.getOrganization();
        if (_DefaultCloudFoundryOperations.hasText(organization)) {
            return _DefaultCloudFoundryOperations.getOrganization(this.getCloudFoundryClientPublisher(), organization).map(ResourceUtils::getId).cache();
        }
        return Mono.error((Throwable)new IllegalStateException("No organization targeted"));
    }

    @Nullable
    abstract RoutingClient getRoutingClient();

    @Value.Derived
    Mono<RoutingClient> getRoutingClientPublisher() {
        return Optional.ofNullable(this.getRoutingClient()).map(Mono::just).orElse(Mono.error((Throwable)new IllegalStateException("RoutingClient must be set")));
    }

    @Nullable
    abstract String getSpace();

    @Value.Derived
    Mono<String> getSpaceId() {
        String space = this.getSpace();
        if (_DefaultCloudFoundryOperations.hasText(this.getSpace())) {
            return this.getOrganizationId().then(organizationId -> _DefaultCloudFoundryOperations.getSpace(this.getCloudFoundryClientPublisher(), organizationId, space)).map(ResourceUtils::getId).cache();
        }
        return Mono.error((Throwable)new IllegalStateException("No space targeted"));
    }

    @Nullable
    abstract UaaClient getUaaClient();

    @Value.Derived
    Mono<UaaClient> getUaaClientPublisher() {
        return Optional.ofNullable(this.getUaaClient()).map(Mono::just).orElse(Mono.error((Throwable)new IllegalStateException("UaaClient must be set")));
    }

    @Value.Derived
    Mono<String> getUsername() {
        return this.getUaaClientPublisher().then(UaaClient::getUsername);
    }

    private static Mono<OrganizationResource> getOrganization(Mono<CloudFoundryClient> cloudFoundryClient, String organization) {
        return _DefaultCloudFoundryOperations.requestOrganizations(cloudFoundryClient, organization).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Organization %s does not exist", (Object[])new Object[]{organization}));
    }

    private static Mono<SpaceResource> getSpace(Mono<CloudFoundryClient> cloudFoundryClient, String organizationId, String space) {
        return _DefaultCloudFoundryOperations.requestSpaces(cloudFoundryClient, organizationId, space).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Space %s does not exist", (Object[])new Object[]{space}));
    }

    private static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    private static boolean hasText(CharSequence str) {
        if (!_DefaultCloudFoundryOperations.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static Flux<OrganizationResource> requestOrganizations(Mono<CloudFoundryClient> cloudFoundryClientPublisher, String organization) {
        return cloudFoundryClientPublisher.flatMap(cloudFoundryClient -> PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().list(ListOrganizationsRequest.builder().name(organization).page(page).build())));
    }

    private static Flux<SpaceResource> requestSpaces(Mono<CloudFoundryClient> cloudFoundryClientPublisher, String organizationId, String space) {
        return cloudFoundryClientPublisher.flatMap(cloudFoundryClient -> PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.spaces().list(ListSpacesRequest.builder().organizationId(organizationId).name(space).page(page).build())));
    }
}

