/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.Resource;
import org.cloudfoundry.client.v2.applications.ApplicationEntity;
import org.cloudfoundry.client.v2.applications.ApplicationResource;
import org.cloudfoundry.client.v2.applications.GetApplicationRequest;
import org.cloudfoundry.client.v2.applications.GetApplicationResponse;
import org.cloudfoundry.client.v2.applications.ListApplicationServiceBindingsRequest;
import org.cloudfoundry.client.v2.jobs.JobEntity;
import org.cloudfoundry.client.v2.organizations.ListOrganizationPrivateDomainsRequest;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomainResource;
import org.cloudfoundry.client.v2.routes.ListRoutesRequest;
import org.cloudfoundry.client.v2.routes.RouteEntity;
import org.cloudfoundry.client.v2.routes.RouteResource;
import org.cloudfoundry.client.v2.servicebindings.CreateServiceBindingRequest;
import org.cloudfoundry.client.v2.servicebindings.CreateServiceBindingResponse;
import org.cloudfoundry.client.v2.servicebindings.DeleteServiceBindingRequest;
import org.cloudfoundry.client.v2.servicebindings.DeleteServiceBindingResponse;
import org.cloudfoundry.client.v2.servicebindings.ListServiceBindingsRequest;
import org.cloudfoundry.client.v2.servicebindings.ServiceBindingEntity;
import org.cloudfoundry.client.v2.servicebindings.ServiceBindingResource;
import org.cloudfoundry.client.v2.serviceinstances.AbstractServiceInstanceResource;
import org.cloudfoundry.client.v2.serviceinstances.BaseServiceInstanceEntity;
import org.cloudfoundry.client.v2.serviceinstances.CreateServiceInstanceResponse;
import org.cloudfoundry.client.v2.serviceinstances.DeleteServiceInstanceResponse;
import org.cloudfoundry.client.v2.serviceinstances.GetServiceInstanceResponse;
import org.cloudfoundry.client.v2.serviceinstances.LastOperation;
import org.cloudfoundry.client.v2.serviceinstances.ListServiceInstanceServiceKeysRequest;
import org.cloudfoundry.client.v2.serviceinstances.ServiceInstanceEntity;
import org.cloudfoundry.client.v2.serviceinstances.UnionServiceInstanceEntity;
import org.cloudfoundry.client.v2.serviceinstances.UnionServiceInstanceResource;
import org.cloudfoundry.client.v2.serviceinstances.UpdateServiceInstanceResponse;
import org.cloudfoundry.client.v2.servicekeys.AbstractServiceKeyResource;
import org.cloudfoundry.client.v2.servicekeys.CreateServiceKeyResponse;
import org.cloudfoundry.client.v2.servicekeys.ServiceKeyEntity;
import org.cloudfoundry.client.v2.servicekeys.ServiceKeyResource;
import org.cloudfoundry.client.v2.serviceplans.GetServicePlanRequest;
import org.cloudfoundry.client.v2.serviceplans.GetServicePlanResponse;
import org.cloudfoundry.client.v2.serviceplans.ListServicePlansRequest;
import org.cloudfoundry.client.v2.serviceplans.ServicePlanEntity;
import org.cloudfoundry.client.v2.serviceplans.ServicePlanResource;
import org.cloudfoundry.client.v2.serviceplanvisibilities.ListServicePlanVisibilitiesRequest;
import org.cloudfoundry.client.v2.serviceplanvisibilities.ServicePlanVisibilityResource;
import org.cloudfoundry.client.v2.services.GetServiceRequest;
import org.cloudfoundry.client.v2.services.GetServiceResponse;
import org.cloudfoundry.client.v2.services.ServiceEntity;
import org.cloudfoundry.client.v2.services.ServiceResource;
import org.cloudfoundry.client.v2.shareddomains.ListSharedDomainsRequest;
import org.cloudfoundry.client.v2.shareddomains.SharedDomainResource;
import org.cloudfoundry.client.v2.spaces.GetSpaceSummaryRequest;
import org.cloudfoundry.client.v2.spaces.GetSpaceSummaryResponse;
import org.cloudfoundry.client.v2.spaces.ListSpaceApplicationsRequest;
import org.cloudfoundry.client.v2.spaces.ListSpaceServiceInstancesRequest;
import org.cloudfoundry.client.v2.spaces.ListSpaceServicesRequest;
import org.cloudfoundry.client.v2.userprovidedserviceinstances.AssociateUserProvidedServiceInstanceRouteRequest;
import org.cloudfoundry.client.v2.userprovidedserviceinstances.AssociateUserProvidedServiceInstanceRouteResponse;
import org.cloudfoundry.client.v2.userprovidedserviceinstances.CreateUserProvidedServiceInstanceResponse;
import org.cloudfoundry.client.v2.userprovidedserviceinstances.DeleteUserProvidedServiceInstanceRequest;
import org.cloudfoundry.client.v2.userprovidedserviceinstances.UpdateUserProvidedServiceInstanceResponse;
import org.cloudfoundry.operations.services.BindRouteServiceInstanceRequest;
import org.cloudfoundry.operations.services.BindServiceInstanceRequest;
import org.cloudfoundry.operations.services.CreateServiceInstanceRequest;
import org.cloudfoundry.operations.services.CreateServiceKeyRequest;
import org.cloudfoundry.operations.services.CreateUserProvidedServiceInstanceRequest;
import org.cloudfoundry.operations.services.DeleteServiceInstanceRequest;
import org.cloudfoundry.operations.services.DeleteServiceKeyRequest;
import org.cloudfoundry.operations.services.GetServiceInstanceRequest;
import org.cloudfoundry.operations.services.GetServiceKeyRequest;
import org.cloudfoundry.operations.services.ListServiceKeysRequest;
import org.cloudfoundry.operations.services.ListServiceOfferingsRequest;
import org.cloudfoundry.operations.services.RenameServiceInstanceRequest;
import org.cloudfoundry.operations.services.ServiceInstance;
import org.cloudfoundry.operations.services.ServiceInstanceSummary;
import org.cloudfoundry.operations.services.ServiceInstanceType;
import org.cloudfoundry.operations.services.ServiceKey;
import org.cloudfoundry.operations.services.ServiceOffering;
import org.cloudfoundry.operations.services.ServicePlan;
import org.cloudfoundry.operations.services.Services;
import org.cloudfoundry.operations.services.UnbindServiceInstanceRequest;
import org.cloudfoundry.operations.services.UpdateServiceInstanceRequest;
import org.cloudfoundry.operations.services.UpdateUserProvidedServiceInstanceRequest;
import org.cloudfoundry.util.ExceptionUtils;
import org.cloudfoundry.util.JobUtils;
import org.cloudfoundry.util.LastOperationUtils;
import org.cloudfoundry.util.PaginationUtils;
import org.cloudfoundry.util.ResourceUtils;
import org.cloudfoundry.util.tuple.TupleUtils;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

public final class DefaultServices
implements Services {
    private static final int CF_ROUTE_SERVICE_ALREADY_BOUND = 130008;
    private static final int CF_SERVICE_ALREADY_BOUND = 90003;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Mono<CloudFoundryClient> cloudFoundryClient;
    private final Mono<String> organizationId;
    private final Mono<String> spaceId;

    public DefaultServices(Mono<CloudFoundryClient> cloudFoundryClient, Mono<String> organizationId, Mono<String> spaceId) {
        this.cloudFoundryClient = cloudFoundryClient;
        this.spaceId = spaceId;
        this.organizationId = organizationId;
    }

    @Override
    public Mono<Void> bind(BindServiceInstanceRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServices.getApplicationId(cloudFoundryClient, request.getApplicationName(), spaceId), DefaultServices.getSpaceServiceInstanceId(cloudFoundryClient, request.getServiceInstanceName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, applicationId, serviceInstanceId) -> DefaultServices.createServiceBinding(cloudFoundryClient, applicationId, serviceInstanceId, request.getParameters()))).then().checkpoint();
    }

    @Override
    public Mono<Void> bindRoute(BindRouteServiceInstanceRequest request) {
        return Mono.when(this.cloudFoundryClient, this.organizationId, this.spaceId).then(TupleUtils.function((cloudFoundryClient, organizationId, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServices.getDomainId(cloudFoundryClient, request.getDomainName(), organizationId), (Mono)Mono.just((Object)spaceId)))).then(TupleUtils.function((cloudFoundryClient, domainId, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServices.getRouteId(cloudFoundryClient, request.getDomainName(), domainId, request.getHostname(), request.getPath()), DefaultServices.getSpaceUserProvidedServiceInstanceId(cloudFoundryClient, request.getServiceInstanceName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, routeId, userProvidedServiceInstanceId) -> DefaultServices.createRouteBinding(cloudFoundryClient, routeId, userProvidedServiceInstanceId, request.getParameters()))).then().checkpoint();
    }

    @Override
    public Mono<Void> createInstance(CreateServiceInstanceRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), (Mono)Mono.just((Object)spaceId), DefaultServices.getServiceIdByName(cloudFoundryClient, spaceId, request.getServiceName())))).then(TupleUtils.function((cloudFoundryClient, spaceId, serviceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), (Mono)Mono.just((Object)spaceId), DefaultServices.getServicePlanIdByName(cloudFoundryClient, serviceId, request.getPlanName())))).then(TupleUtils.function((cloudFoundryClient, spaceId, planId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), (Mono)Mono.just((Object)request.getCompletionTimeout()), DefaultServices.createServiceInstance(cloudFoundryClient, spaceId, planId, request)))).then(TupleUtils.function(DefaultServices::waitForCreateInstance)).checkpoint();
    }

    @Override
    public Mono<Void> createServiceKey(CreateServiceKeyRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServices.getSpaceServiceInstanceId(cloudFoundryClient, request.getServiceInstanceName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, serviceInstanceId) -> DefaultServices.requestCreateServiceKey(cloudFoundryClient, serviceInstanceId, request.getServiceKeyName(), request.getParameters()))).then().checkpoint();
    }

    @Override
    public Mono<Void> createUserProvidedInstance(CreateUserProvidedServiceInstanceRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> DefaultServices.requestCreateUserProvidedServiceInstance(cloudFoundryClient, request.getName(), request.getCredentials(), request.getRouteServiceUrl(), spaceId, request.getSyslogDrainUrl()))).then().checkpoint();
    }

    @Override
    public Mono<Void> deleteInstance(DeleteServiceInstanceRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), (Mono)Mono.just((Object)request.getCompletionTimeout()), DefaultServices.getSpaceServiceInstance(cloudFoundryClient, request.getName(), spaceId)))).then(TupleUtils.function(DefaultServices::deleteServiceInstance)).checkpoint();
    }

    @Override
    public Mono<Void> deleteServiceKey(DeleteServiceKeyRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServices.getSpaceServiceInstanceId(cloudFoundryClient, request.getServiceInstanceName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, serviceInstanceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), (Mono)DefaultServices.getServiceKey(cloudFoundryClient, serviceInstanceId, request.getServiceKeyName()).map(ResourceUtils::getId)))).then(TupleUtils.function(DefaultServices::requestDeleteServiceKey)).checkpoint();
    }

    @Override
    public Mono<ServiceInstance> getInstance(GetServiceInstanceRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServices.getSpaceServiceInstance(cloudFoundryClient, request.getName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, resource) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), (Mono)Mono.just((Object)resource), DefaultServices.getServicePlanEntity(cloudFoundryClient, ((UnionServiceInstanceEntity)ResourceUtils.getEntity((Resource)resource)).getServicePlanId())))).then(TupleUtils.function((cloudFoundryClient, resource, servicePlanEntity) -> Mono.when((Mono)Mono.just((Object)resource), (Mono)Mono.just(Optional.ofNullable(servicePlanEntity.getName())), DefaultServices.getBoundApplications(cloudFoundryClient, ResourceUtils.getId((Resource)resource)), DefaultServices.getServiceEntity(cloudFoundryClient, Optional.ofNullable(servicePlanEntity.getServiceId()))))).map(TupleUtils.function(DefaultServices::toServiceInstance)).checkpoint();
    }

    @Override
    public Mono<ServiceKey> getServiceKey(GetServiceKeyRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServices.getSpaceServiceInstanceId(cloudFoundryClient, request.getServiceInstanceName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, serviceInstanceId) -> DefaultServices.getServiceKey(cloudFoundryClient, serviceInstanceId, request.getServiceKeyName()))).map(DefaultServices::toServiceKey).checkpoint();
    }

    @Override
    public Flux<ServiceInstanceSummary> listInstances() {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> cloudFoundryClient.spaces().getSummary(GetSpaceSummaryRequest.builder().spaceId(spaceId).build()))).flatMap(DefaultServices::toServiceInstanceSummary).checkpoint();
    }

    @Override
    public Flux<ServiceKey> listServiceKeys(ListServiceKeysRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServices.getSpaceServiceInstanceId(cloudFoundryClient, request.getServiceInstanceName(), spaceId)))).flatMap(TupleUtils.function((cloudFoundryClient, serviceInstanceId) -> DefaultServices.requestListServiceInstanceServiceKeys(cloudFoundryClient, serviceInstanceId))).map(DefaultServices::toServiceKey).checkpoint();
    }

    @Override
    public Flux<ServiceOffering> listServiceOfferings(ListServiceOfferingsRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> Optional.ofNullable(request.getServiceName()).map(serviceName -> DefaultServices.getSpaceService(cloudFoundryClient, spaceId, serviceName).flux()).orElse(DefaultServices.requestListServices(cloudFoundryClient, spaceId)).map(resource -> Tuples.of((Object)cloudFoundryClient, (Object)resource)))).flatMap(TupleUtils.function((cloudFoundryClient, resource) -> Mono.when((Mono)Mono.just((Object)resource), this.getServicePlans((CloudFoundryClient)cloudFoundryClient, ResourceUtils.getId((Resource)resource))))).map(TupleUtils.function(DefaultServices::toServiceOffering)).checkpoint();
    }

    @Override
    public Mono<Void> renameInstance(RenameServiceInstanceRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServices.getSpaceServiceInstance(cloudFoundryClient, request.getName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, serviceInstance) -> DefaultServices.renameServiceInstance(cloudFoundryClient, serviceInstance, request.getNewName()))).then().checkpoint();
    }

    @Override
    public Mono<Void> unbind(UnbindServiceInstanceRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServices.getApplicationId(cloudFoundryClient, request.getApplicationName(), spaceId), DefaultServices.getSpaceServiceInstanceId(cloudFoundryClient, request.getServiceInstanceName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, applicationId, serviceInstanceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), (Mono)Mono.just((Object)request.getCompletionTimeout()), DefaultServices.getServiceBindingId(cloudFoundryClient, applicationId, serviceInstanceId, request.getServiceInstanceName())))).then(TupleUtils.function(DefaultServices::deleteServiceBinding)).then().checkpoint();
    }

    @Override
    public Mono<Void> updateInstance(UpdateServiceInstanceRequest request) {
        return Mono.when(this.cloudFoundryClient, this.organizationId, this.spaceId).then(TupleUtils.function((cloudFoundryClient, organizationId, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), (Mono)Mono.just((Object)organizationId), DefaultServices.getSpaceServiceInstance(cloudFoundryClient, request.getServiceInstanceName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, organizationId, serviceInstance) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), (Mono)Mono.just((Object)ResourceUtils.getId((Resource)serviceInstance)), DefaultServices.getOptionalValidatedServicePlanId(cloudFoundryClient, request.getPlanName(), serviceInstance, organizationId)))).then(TupleUtils.function((cloudFoundryClient, serviceInstanceId, servicePlanId) -> DefaultServices.updateServiceInstance(cloudFoundryClient, request, serviceInstanceId, servicePlanId.orElse(null)))).then().checkpoint();
    }

    @Override
    public Mono<Void> updateUserProvidedInstance(UpdateUserProvidedServiceInstanceRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServices.getSpaceUserProvidedServiceInstanceId(cloudFoundryClient, request.getUserProvidedServiceInstanceName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, userProvidedServiceInstanceId) -> DefaultServices.updateUserProvidedServiceInstance(cloudFoundryClient, request, userProvidedServiceInstanceId))).then().checkpoint();
    }

    private static Mono<Optional<String>> checkVisibility(CloudFoundryClient cloudFoundryClient, String organizationId, ServicePlanResource resource) {
        String servicePlanId = ResourceUtils.getId((Resource)resource);
        if (resource.getEntity().getPubliclyVisible().booleanValue()) {
            return Mono.just(Optional.of(servicePlanId));
        }
        return DefaultServices.requestListServicePlanVisibilities(cloudFoundryClient, organizationId, servicePlanId).next().otherwiseIfEmpty(ExceptionUtils.illegalArgument((String)"Service Plan %s is not visible to your organization", (Object[])new Object[]{resource.getEntity().getName()})).then(Mono.just(Optional.of(servicePlanId)));
    }

    private static Mono<AssociateUserProvidedServiceInstanceRouteResponse> createRouteBinding(CloudFoundryClient cloudFoundryClient, String routeId, String userProvidedServiceInstanceId, Map<String, Object> parameters) {
        return DefaultServices.requestCreateRouteBinding(cloudFoundryClient, routeId, userProvidedServiceInstanceId, parameters).otherwise(ExceptionUtils.statusCode((int[])new int[]{130008}), t -> Mono.empty());
    }

    private static Mono<CreateServiceBindingResponse> createServiceBinding(CloudFoundryClient cloudFoundryClient, String applicationId, String serviceInstanceId, Map<String, Object> parameters) {
        return DefaultServices.requestCreateServiceBinding(cloudFoundryClient, applicationId, serviceInstanceId, parameters).otherwise(ExceptionUtils.statusCode((int[])new int[]{90003}), t -> Mono.empty());
    }

    private static Mono<AbstractServiceInstanceResource> createServiceInstance(CloudFoundryClient cloudFoundryClient, String spaceId, String planId, CreateServiceInstanceRequest request) {
        return DefaultServices.requestCreateServiceInstance(cloudFoundryClient, spaceId, planId, request.getServiceInstanceName(), request.getParameters(), request.getTags()).cast(AbstractServiceInstanceResource.class);
    }

    private static Mono<Void> deleteServiceBinding(CloudFoundryClient cloudFoundryClient, Duration completionTimeout, String serviceBindingId) {
        return DefaultServices.requestDeleteServiceBinding(cloudFoundryClient, serviceBindingId).then(job -> JobUtils.waitForCompletion((CloudFoundryClient)cloudFoundryClient, (Duration)completionTimeout, (Resource)job));
    }

    private static Mono<Void> deleteServiceInstance(CloudFoundryClient cloudFoundryClient, Duration completionTimeout, UnionServiceInstanceResource serviceInstance) {
        if (DefaultServices.isUserProvidedService(serviceInstance)) {
            return DefaultServices.requestDeleteUserProvidedServiceInstance(cloudFoundryClient, ResourceUtils.getId((Resource)serviceInstance));
        }
        return DefaultServices.requestDeleteServiceInstance(cloudFoundryClient, ResourceUtils.getId((Resource)serviceInstance)).then(response -> {
            Object entity = response.getEntity();
            if (entity instanceof JobEntity) {
                return JobUtils.waitForCompletion((CloudFoundryClient)cloudFoundryClient, (Duration)completionTimeout, (JobEntity)((JobEntity)response.getEntity()));
            }
            return LastOperationUtils.waitForCompletion((Duration)completionTimeout, () -> DefaultServices.requestGetServiceInstance(cloudFoundryClient, ResourceUtils.getId((Resource)serviceInstance)).map(r -> ((ServiceInstanceEntity)ResourceUtils.getEntity((Resource)r)).getLastOperation()));
        });
    }

    private static Mono<ApplicationResource> getApplication(CloudFoundryClient cloudFoundryClient, String applicationName, String spaceId) {
        return DefaultServices.requestListApplications(cloudFoundryClient, applicationName, spaceId).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Application %s does not exist", (Object[])new Object[]{applicationName}));
    }

    private static Mono<String> getApplicationId(CloudFoundryClient cloudFoundryClient, String applicationName, String spaceId) {
        return DefaultServices.getApplication(cloudFoundryClient, applicationName, spaceId).map(ResourceUtils::getId);
    }

    private static Mono<List<String>> getBoundApplications(CloudFoundryClient cloudFoundryClient, String serviceInstanceId) {
        return DefaultServices.requestListServiceBindings(cloudFoundryClient, serviceInstanceId).map(resource -> ((ServiceBindingEntity)ResourceUtils.getEntity((Resource)resource)).getApplicationId()).flatMap(applicationId -> DefaultServices.requestGetApplication(cloudFoundryClient, applicationId)).map(ResourceUtils::getEntity).map(ApplicationEntity::getName).collectList();
    }

    private static Mono<String> getDomainId(CloudFoundryClient cloudFoundryClient, String domain, String organizationId) {
        return DefaultServices.getPrivateDomainId(cloudFoundryClient, domain, organizationId).otherwiseIfEmpty(DefaultServices.getSharedDomainId(cloudFoundryClient, domain)).otherwiseIfEmpty(ExceptionUtils.illegalArgument((String)"Domain %s not found", (Object[])new Object[]{domain}));
    }

    private static String getExtraValue(String extra, String key) {
        if (extra == null || extra.isEmpty()) {
            return null;
        }
        try {
            return (String)((Map)OBJECT_MAPPER.readValue(extra, Map.class)).get(key);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static Mono<Optional<String>> getOptionalValidatedServicePlanId(CloudFoundryClient cloudFoundryClient, String planName, UnionServiceInstanceResource serviceInstance, String organizationId) {
        if (planName == null || planName.isEmpty()) {
            return Mono.just(Optional.empty());
        }
        String servicePlanId = serviceInstance.getEntity().getServicePlanId();
        if (servicePlanId == null || servicePlanId.isEmpty()) {
            return ExceptionUtils.illegalArgument((String)"Plan does not exist for the %s service", (Object[])new Object[]{serviceInstance.getEntity().getName()});
        }
        return DefaultServices.getServiceId(cloudFoundryClient, servicePlanId).then(serviceId -> DefaultServices.requestGetService(cloudFoundryClient, serviceId)).filter(DefaultServices::isPlanUpdateable).otherwiseIfEmpty(ExceptionUtils.illegalArgument((String)"Plan for the %s service cannot be updated", (Object[])new Object[]{serviceInstance.getEntity().getName()})).flatMap(response -> DefaultServices.requestListServicePlans(cloudFoundryClient, ResourceUtils.getId((Resource)response))).filter(resource -> planName.equals(resource.getEntity().getName())).singleOrEmpty().otherwiseIfEmpty(ExceptionUtils.illegalArgument((String)"New service plan %s not found", (Object[])new Object[]{planName})).then(resource -> DefaultServices.checkVisibility(cloudFoundryClient, organizationId, resource));
    }

    private static Mono<String> getPrivateDomainId(CloudFoundryClient cloudFoundryClient, String domain, String organizationId) {
        return DefaultServices.requestPrivateDomain(cloudFoundryClient, domain, organizationId).map(ResourceUtils::getId).singleOrEmpty();
    }

    private static Mono<RouteResource> getRoute(CloudFoundryClient cloudFoundryClient, String domainId, String domain, String host, String path) {
        return DefaultServices.getRoute(cloudFoundryClient, domainId, host, path).otherwiseIfEmpty(ExceptionUtils.illegalArgument((String)"Route %s.%s does not exist", (Object[])new Object[]{host, domain}));
    }

    private static Mono<RouteResource> getRoute(CloudFoundryClient cloudFoundryClient, String domainId, String host, String path) {
        return DefaultServices.requestRoutes(cloudFoundryClient, domainId, host, path).filter(resource -> DefaultServices.isIdentical(host, ((RouteEntity)ResourceUtils.getEntity((Resource)resource)).getHost())).filter(resource -> DefaultServices.isIdentical(path, ((RouteEntity)ResourceUtils.getEntity((Resource)resource)).getPath())).singleOrEmpty();
    }

    private static Mono<String> getRouteId(CloudFoundryClient cloudFoundryClient, String domain, String domainId, String host, String path) {
        return DefaultServices.getRoute(cloudFoundryClient, domainId, domain, host, path).map(ResourceUtils::getId);
    }

    private static Mono<String> getServiceBindingId(CloudFoundryClient cloudFoundryClient, String applicationId, String serviceInstanceId, String serviceInstanceName) {
        return DefaultServices.requestListServiceBindings(cloudFoundryClient, applicationId, serviceInstanceId).singleOrEmpty().otherwiseIfEmpty(ExceptionUtils.illegalState((String)"Service instance %s is not bound to application", (Object[])new Object[]{serviceInstanceName})).map(ResourceUtils::getId);
    }

    private static Mono<ServiceEntity> getServiceEntity(CloudFoundryClient cloudFoundryClient, Optional<String> serviceId) {
        return Mono.justOrEmpty(serviceId).then(serviceId1 -> DefaultServices.requestGetService(cloudFoundryClient, serviceId1)).map(ResourceUtils::getEntity).otherwiseIfEmpty(Mono.just((Object)ServiceEntity.builder().build()));
    }

    private static Mono<String> getServiceId(CloudFoundryClient cloudFoundryClient, String servicePlanId) {
        return DefaultServices.requestGetServicePlan(cloudFoundryClient, servicePlanId).map(response -> response.getEntity().getServiceId());
    }

    private static Mono<String> getServiceIdByName(CloudFoundryClient cloudFoundryClient, String spaceId, String service) {
        return DefaultServices.getSpaceService(cloudFoundryClient, spaceId, service).map(ResourceUtils::getId);
    }

    private static Mono<ServiceKeyResource> getServiceKey(CloudFoundryClient cloudFoundryClient, String serviceInstanceId, String serviceKey) {
        return DefaultServices.requestListServiceInstanceServiceKeys(cloudFoundryClient, serviceInstanceId, serviceKey).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Service key %s does not exist", (Object[])new Object[]{serviceKey}));
    }

    private static Mono<ServicePlanEntity> getServicePlanEntity(CloudFoundryClient cloudFoundryClient, String servicePlanId) {
        return Mono.justOrEmpty((Object)servicePlanId).then(servicePlanId1 -> DefaultServices.requestGetServicePlan(cloudFoundryClient, servicePlanId1)).map(ResourceUtils::getEntity).otherwiseIfEmpty(Mono.just((Object)ServicePlanEntity.builder().build()));
    }

    private static Mono<String> getServicePlanIdByName(CloudFoundryClient cloudFoundryClient, String serviceId, String plan) {
        return DefaultServices.requestListServicePlans(cloudFoundryClient, serviceId).filter(resource -> plan.equals(((ServicePlanEntity)ResourceUtils.getEntity((Resource)resource)).getName())).single().map(ResourceUtils::getId).otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Service plan %s does not exist", (Object[])new Object[]{plan}));
    }

    private static Mono<String> getSharedDomainId(CloudFoundryClient cloudFoundryClient, String domain) {
        return DefaultServices.requestSharedDomain(cloudFoundryClient, domain).map(ResourceUtils::getId).singleOrEmpty();
    }

    private static Mono<ServiceResource> getSpaceService(CloudFoundryClient cloudFoundryClient, String spaceId, String service) {
        return DefaultServices.requestListServices(cloudFoundryClient, spaceId, service).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Service %s does not exist", (Object[])new Object[]{service}));
    }

    private static Mono<UnionServiceInstanceResource> getSpaceServiceInstance(CloudFoundryClient cloudFoundryClient, String serviceInstanceName, String spaceId) {
        return DefaultServices.requestListServiceInstances(cloudFoundryClient, spaceId, serviceInstanceName).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Service instance %s does not exist", (Object[])new Object[]{serviceInstanceName}));
    }

    private static Mono<String> getSpaceServiceInstanceId(CloudFoundryClient cloudFoundryClient, String serviceInstanceName, String spaceId) {
        return DefaultServices.getSpaceServiceInstance(cloudFoundryClient, serviceInstanceName, spaceId).map(ResourceUtils::getId);
    }

    private static Mono<UnionServiceInstanceResource> getSpaceUserProvidedServiceInstance(CloudFoundryClient cloudFoundryClient, String serviceInstanceName, String spaceId) {
        return DefaultServices.requestListServiceInstances(cloudFoundryClient, spaceId, serviceInstanceName).filter(DefaultServices::isUserProvidedService).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"User provided service instance %s does not exist", (Object[])new Object[]{serviceInstanceName}));
    }

    private static Mono<String> getSpaceUserProvidedServiceInstanceId(CloudFoundryClient cloudFoundryClient, String serviceInstanceName, String spaceId) {
        return DefaultServices.getSpaceUserProvidedServiceInstance(cloudFoundryClient, serviceInstanceName, spaceId).map(ResourceUtils::getId);
    }

    private static boolean isIdentical(String s, String t) {
        return s == null ? t == null : s.equals(t);
    }

    private static boolean isPlanUpdateable(GetServiceResponse response) {
        return response.getEntity().getPlanUpdateable();
    }

    private static boolean isUserProvidedService(UnionServiceInstanceResource serviceInstance) {
        return ServiceInstanceType.from(((UnionServiceInstanceEntity)ResourceUtils.getEntity((Resource)serviceInstance)).getType()).equals((Object)ServiceInstanceType.USER_PROVIDED);
    }

    private static Mono<BaseServiceInstanceEntity> renameServiceInstance(CloudFoundryClient cloudFoundryClient, UnionServiceInstanceResource serviceInstance, String newName) {
        if (DefaultServices.isUserProvidedService(serviceInstance)) {
            return DefaultServices.requestUserProvidedServiceInstanceUpdate(cloudFoundryClient, ResourceUtils.getId((Resource)serviceInstance), newName).map(ResourceUtils::getEntity).cast(BaseServiceInstanceEntity.class);
        }
        return DefaultServices.requestServiceInstanceUpdate(cloudFoundryClient, ResourceUtils.getId((Resource)serviceInstance), newName).map(ResourceUtils::getEntity).cast(BaseServiceInstanceEntity.class);
    }

    private static Mono<AssociateUserProvidedServiceInstanceRouteResponse> requestCreateRouteBinding(CloudFoundryClient cloudFoundryClient, String routeId, String userProvidedServiceInstanceId, Map<String, Object> parameters) {
        return cloudFoundryClient.userProvidedServiceInstances().associateRoute(AssociateUserProvidedServiceInstanceRouteRequest.builder().parameters(parameters).routeId(routeId).userProvidedServiceInstanceId(userProvidedServiceInstanceId).build());
    }

    private static Mono<CreateServiceBindingResponse> requestCreateServiceBinding(CloudFoundryClient cloudFoundryClient, String applicationId, String serviceInstanceId, Map<String, Object> parameters) {
        return cloudFoundryClient.serviceBindingsV2().create(CreateServiceBindingRequest.builder().applicationId(applicationId).parameters(parameters).serviceInstanceId(serviceInstanceId).build());
    }

    private static Mono<CreateServiceInstanceResponse> requestCreateServiceInstance(CloudFoundryClient cloudFoundryClient, String spaceId, String planId, String serviceInstance, Map<String, Object> parameters, List<String> tags) {
        return cloudFoundryClient.serviceInstances().create(org.cloudfoundry.client.v2.serviceinstances.CreateServiceInstanceRequest.builder().acceptsIncomplete(Boolean.valueOf(true)).name(serviceInstance).servicePlanId(planId).spaceId(spaceId).parameters(parameters).tags(tags).build());
    }

    private static Mono<CreateServiceKeyResponse> requestCreateServiceKey(CloudFoundryClient cloudFoundryClient, String serviceInstanceId, String serviceKey, Map<String, Object> parameters) {
        return cloudFoundryClient.serviceKeys().create(org.cloudfoundry.client.v2.servicekeys.CreateServiceKeyRequest.builder().serviceInstanceId(serviceInstanceId).name(serviceKey).parameters(parameters).build());
    }

    private static Mono<CreateUserProvidedServiceInstanceResponse> requestCreateUserProvidedServiceInstance(CloudFoundryClient cloudFoundryClient, String name, Map<String, Object> credentials, String routeServiceUrl, String spaceId, String syslogDrainUrl) {
        return cloudFoundryClient.userProvidedServiceInstances().create(org.cloudfoundry.client.v2.userprovidedserviceinstances.CreateUserProvidedServiceInstanceRequest.builder().name(name).credentials(credentials).routeServiceUrl(routeServiceUrl).spaceId(spaceId).syslogDrainUrl(syslogDrainUrl).build());
    }

    private static Mono<DeleteServiceBindingResponse> requestDeleteServiceBinding(CloudFoundryClient cloudFoundryClient, String serviceBindingId) {
        return cloudFoundryClient.serviceBindingsV2().delete(DeleteServiceBindingRequest.builder().serviceBindingId(serviceBindingId).async(Boolean.valueOf(true)).build());
    }

    private static Mono<DeleteServiceInstanceResponse> requestDeleteServiceInstance(CloudFoundryClient cloudFoundryClient, String serviceInstanceId) {
        return cloudFoundryClient.serviceInstances().delete(org.cloudfoundry.client.v2.serviceinstances.DeleteServiceInstanceRequest.builder().acceptsIncomplete(Boolean.valueOf(true)).serviceInstanceId(serviceInstanceId).async(Boolean.valueOf(true)).build());
    }

    private static Mono<Void> requestDeleteServiceKey(CloudFoundryClient cloudFoundryClient, String serviceKeyId) {
        return cloudFoundryClient.serviceKeys().delete(org.cloudfoundry.client.v2.servicekeys.DeleteServiceKeyRequest.builder().serviceKeyId(serviceKeyId).build());
    }

    private static Mono<Void> requestDeleteUserProvidedServiceInstance(CloudFoundryClient cloudFoundryClient, String serviceInstanceId) {
        return cloudFoundryClient.userProvidedServiceInstances().delete(DeleteUserProvidedServiceInstanceRequest.builder().userProvidedServiceInstanceId(serviceInstanceId).build());
    }

    private static Mono<GetApplicationResponse> requestGetApplication(CloudFoundryClient cloudFoundryClient, String applicationId) {
        return cloudFoundryClient.applicationsV2().get(GetApplicationRequest.builder().applicationId(applicationId).build());
    }

    private static Mono<GetServiceResponse> requestGetService(CloudFoundryClient cloudFoundryClient, String serviceId) {
        return cloudFoundryClient.services().get(GetServiceRequest.builder().serviceId(serviceId).build());
    }

    private static Mono<GetServiceInstanceResponse> requestGetServiceInstance(CloudFoundryClient cloudFoundryClient, String serviceInstanceId) {
        return cloudFoundryClient.serviceInstances().get(org.cloudfoundry.client.v2.serviceinstances.GetServiceInstanceRequest.builder().serviceInstanceId(serviceInstanceId).build());
    }

    private static Mono<GetServicePlanResponse> requestGetServicePlan(CloudFoundryClient cloudFoundryClient, String servicePlanId) {
        return cloudFoundryClient.servicePlans().get(GetServicePlanRequest.builder().servicePlanId(servicePlanId).build());
    }

    private static Flux<ApplicationResource> requestListApplications(CloudFoundryClient cloudFoundryClient, String application, String spaceId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.spaces().listApplications(ListSpaceApplicationsRequest.builder().name(application).spaceId(spaceId).page(page).build()));
    }

    private static Flux<ServiceBindingResource> requestListServiceBindings(CloudFoundryClient cloudFoundryClient, String applicationId, String serviceInstanceId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.applicationsV2().listServiceBindings(ListApplicationServiceBindingsRequest.builder().page(page).applicationId(applicationId).serviceInstanceId(serviceInstanceId).build()));
    }

    private static Flux<ServiceBindingResource> requestListServiceBindings(CloudFoundryClient cloudFoundryClient, String serviceInstanceId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.serviceBindingsV2().list(ListServiceBindingsRequest.builder().page(page).serviceInstanceId(serviceInstanceId).build()));
    }

    private static Flux<ServiceKeyResource> requestListServiceInstanceServiceKeys(CloudFoundryClient cloudFoundryClient, String serviceInstanceId, String serviceKey) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.serviceInstances().listServiceKeys(ListServiceInstanceServiceKeysRequest.builder().serviceInstanceId(serviceInstanceId).name(serviceKey).page(page).build()));
    }

    private static Flux<ServiceKeyResource> requestListServiceInstanceServiceKeys(CloudFoundryClient cloudFoundryClient, String serviceInstanceId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.serviceInstances().listServiceKeys(ListServiceInstanceServiceKeysRequest.builder().page(page).serviceInstanceId(serviceInstanceId).build()));
    }

    private static Flux<UnionServiceInstanceResource> requestListServiceInstances(CloudFoundryClient cloudFoundryClient, String spaceId, String serviceInstanceName) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.spaces().listServiceInstances(ListSpaceServiceInstancesRequest.builder().page(page).returnUserProvidedServiceInstances(Boolean.valueOf(true)).name(serviceInstanceName).spaceId(spaceId).build()));
    }

    private static Flux<ServicePlanVisibilityResource> requestListServicePlanVisibilities(CloudFoundryClient cloudFoundryClient, String organizationId, String servicePlanId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.servicePlanVisibilities().list(ListServicePlanVisibilitiesRequest.builder().organizationId(organizationId).page(page).servicePlanId(servicePlanId).build()));
    }

    private static Flux<ServicePlanResource> requestListServicePlans(CloudFoundryClient cloudFoundryClient, String serviceId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.servicePlans().list(ListServicePlansRequest.builder().page(page).serviceId(serviceId).build()));
    }

    private static Flux<ServiceResource> requestListServices(CloudFoundryClient cloudFoundryClient, String spaceId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.spaces().listServices(ListSpaceServicesRequest.builder().page(page).spaceId(spaceId).build()));
    }

    private static Flux<ServiceResource> requestListServices(CloudFoundryClient cloudFoundryClient, String spaceId, String serviceName) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.spaces().listServices(ListSpaceServicesRequest.builder().label(serviceName).page(page).spaceId(spaceId).build()));
    }

    private static Flux<PrivateDomainResource> requestPrivateDomain(CloudFoundryClient cloudFoundryClient, String domain, String organizationId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().listPrivateDomains(ListOrganizationPrivateDomainsRequest.builder().name(domain).organizationId(organizationId).page(page).build()));
    }

    private static Flux<RouteResource> requestRoutes(CloudFoundryClient cloudFoundryClient, UnaryOperator<ListRoutesRequest.Builder> modifier) {
        ListRoutesRequest.Builder listBuilder = (ListRoutesRequest.Builder)modifier.apply(ListRoutesRequest.builder());
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.routes().list(listBuilder.page(page).build()));
    }

    private static Flux<RouteResource> requestRoutes(CloudFoundryClient cloudFoundryClient, String domainId, String host, String path) {
        return DefaultServices.requestRoutes(cloudFoundryClient, builder -> builder.domainId(domainId).hosts((Iterable)Optional.ofNullable(host).map(Collections::singletonList).orElse(null)).paths((Iterable)Optional.ofNullable(path).map(Collections::singletonList).orElse(null)));
    }

    private static Mono<UpdateServiceInstanceResponse> requestServiceInstanceUpdate(CloudFoundryClient cloudFoundryClient, String serviceInstanceId, String newName) {
        return cloudFoundryClient.serviceInstances().update(org.cloudfoundry.client.v2.serviceinstances.UpdateServiceInstanceRequest.builder().name(newName).serviceInstanceId(serviceInstanceId).build());
    }

    private static Flux<SharedDomainResource> requestSharedDomain(CloudFoundryClient cloudFoundryClient, String domain) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.sharedDomains().list(ListSharedDomainsRequest.builder().name(domain).page(page).build()));
    }

    private static Mono<UpdateUserProvidedServiceInstanceResponse> requestUserProvidedServiceInstanceUpdate(CloudFoundryClient cloudFoundryClient, String serviceInstanceId, String newName) {
        return cloudFoundryClient.userProvidedServiceInstances().update(org.cloudfoundry.client.v2.userprovidedserviceinstances.UpdateUserProvidedServiceInstanceRequest.builder().name(newName).userProvidedServiceInstanceId(serviceInstanceId).build());
    }

    private static ServiceInstance toServiceInstance(UnionServiceInstanceResource resource, Optional<String> plan, List<String> applications, ServiceEntity serviceEntity) {
        String extra = Optional.ofNullable(serviceEntity.getExtra()).orElse("");
        Optional<String> documentationUrl = Optional.ofNullable(DefaultServices.getExtraValue(extra, "documentationUrl"));
        UnionServiceInstanceEntity serviceInstanceEntity = resource.getEntity();
        LastOperation lastOperation = Optional.ofNullable(serviceInstanceEntity.getLastOperation()).orElse(LastOperation.builder().build());
        return ServiceInstance.builder().applications(applications).dashboardUrl(serviceInstanceEntity.getDashboardUrl()).description(serviceEntity.getDescription()).documentationUrl(documentationUrl.orElse(null)).id(ResourceUtils.getId((Resource)resource)).lastOperation(lastOperation.getType()).message(lastOperation.getDescription()).name(serviceInstanceEntity.getName()).plan(plan.orElse(null)).service(serviceEntity.getLabel()).startedAt(lastOperation.getCreatedAt()).status(lastOperation.getState()).tags(serviceInstanceEntity.getTags()).type(ServiceInstanceType.from(serviceInstanceEntity.getType())).updatedAt(lastOperation.getUpdatedAt()).build();
    }

    private static Flux<ServiceInstanceSummary> toServiceInstanceSummary(GetSpaceSummaryResponse response) {
        HashMap applicationBindings = new HashMap();
        response.getApplications().forEach(application -> application.getServiceNames().forEach(serviceName -> {
            if (!applicationBindings.containsKey(serviceName)) {
                applicationBindings.put(serviceName, new ArrayList());
            }
            ((List)applicationBindings.get(serviceName)).add(application.getName());
        }));
        return Flux.fromIterable((Iterable)response.getServices()).map(service -> ServiceInstanceSummary.builder().applications(Optional.ofNullable(applicationBindings.get(service.getName())).orElse(Collections.emptyList())).id(service.getId()).lastOperation(service.getLastOperation() == null ? null : service.getLastOperation().getDescription()).name(service.getName()).plan(service.getServicePlan() == null ? null : service.getServicePlan().getName()).service(service.getServicePlan() == null ? null : service.getServicePlan().getService().getLabel()).type(service.getServicePlan() == null ? ServiceInstanceType.USER_PROVIDED : ServiceInstanceType.MANAGED).build());
    }

    private static ServiceKey toServiceKey(AbstractServiceKeyResource resource) {
        ServiceKeyEntity entity = (ServiceKeyEntity)ResourceUtils.getEntity((Resource)resource);
        return ServiceKey.builder().credentials(entity.getCredentials()).id(ResourceUtils.getId((Resource)resource)).name(entity.getName()).build();
    }

    private static ServiceOffering toServiceOffering(ServiceResource resource, List<ServicePlanResource> servicePlans) {
        ServiceEntity entity = resource.getEntity();
        return ServiceOffering.builder().description(entity.getDescription()).id(ResourceUtils.getId((Resource)resource)).label(entity.getLabel()).servicePlans(DefaultServices.toServicePlans(servicePlans)).build();
    }

    private static ServicePlan toServicePlan(ServicePlanResource resource) {
        ServicePlanEntity entity = (ServicePlanEntity)ResourceUtils.getEntity((Resource)resource);
        return ServicePlan.builder().description(entity.getDescription()).free(entity.getFree()).id(ResourceUtils.getId((Resource)resource)).name(entity.getName()).build();
    }

    private static List<ServicePlan> toServicePlans(List<ServicePlanResource> servicePlans) {
        return servicePlans.stream().map(DefaultServices::toServicePlan).collect(Collectors.toList());
    }

    private static Mono<UpdateServiceInstanceResponse> updateServiceInstance(CloudFoundryClient cloudFoundryClient, UpdateServiceInstanceRequest request, String serviceInstanceId, String servicePlanId) {
        return cloudFoundryClient.serviceInstances().update(org.cloudfoundry.client.v2.serviceinstances.UpdateServiceInstanceRequest.builder().acceptsIncomplete(Boolean.valueOf(true)).parameters(request.getParameters()).serviceInstanceId(serviceInstanceId).servicePlanId(servicePlanId).tags(request.getTags()).build());
    }

    private static Mono<UpdateUserProvidedServiceInstanceResponse> updateUserProvidedServiceInstance(CloudFoundryClient cloudFoundryClient, UpdateUserProvidedServiceInstanceRequest request, String userProvidedServiceInstanceId) {
        return cloudFoundryClient.userProvidedServiceInstances().update(org.cloudfoundry.client.v2.userprovidedserviceinstances.UpdateUserProvidedServiceInstanceRequest.builder().credentials(request.getCredentials()).syslogDrainUrl(request.getSyslogDrainUrl()).userProvidedServiceInstanceId(userProvidedServiceInstanceId).build());
    }

    private static Mono<Void> waitForCreateInstance(CloudFoundryClient cloudFoundryClient, Duration completionTimeout, AbstractServiceInstanceResource serviceInstance) {
        AtomicBoolean sentFirst = new AtomicBoolean(false);
        return LastOperationUtils.waitForCompletion((Duration)completionTimeout, () -> Mono.defer(() -> {
            if (sentFirst.getAndSet(true)) {
                return DefaultServices.requestGetServiceInstance(cloudFoundryClient, ResourceUtils.getId((Resource)serviceInstance));
            }
            return Mono.just((Object)serviceInstance);
        }).map(response -> ((ServiceInstanceEntity)ResourceUtils.getEntity((Resource)response)).getLastOperation()));
    }

    private Mono<List<ServicePlanResource>> getServicePlans(CloudFoundryClient cloudFoundryClient, String serviceId) {
        return DefaultServices.requestListServicePlans(cloudFoundryClient, serviceId).collectList();
    }
}

