/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.domains;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.operations.domains.Status;
import org.cloudfoundry.operations.domains._Domain;

public final class Domain
extends _Domain {
    private final String id;
    private final String name;
    private final Status status;

    private Domain(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Domain && this.equalTo((Domain)another);
    }

    private boolean equalTo(Domain another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.status.equals((Object)another.status);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.status.hashCode();
        return h;
    }

    public String toString() {
        return "Domain{id=" + this.id + ", name=" + this.name + ", status=" + (Object)((Object)this.status) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_STATUS = 4L;
        private long initBits = 7L;
        private String id;
        private String name;
        private Status status;

        private Builder() {
        }

        public final Builder from(Domain instance) {
            return this.from((_Domain)instance);
        }

        final Builder from(_Domain instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.name(instance.getName());
            this.status(instance.getStatus());
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder status(Status status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Domain build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Domain(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build Domain, some of required attributes are not set " + attributes;
        }
    }
}

