/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.organizationadmin;

import java.time.Duration;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.Resource;
import org.cloudfoundry.client.v2.organizationquotadefinitions.AbstractOrganizationQuotaDefinition;
import org.cloudfoundry.client.v2.organizationquotadefinitions.CreateOrganizationQuotaDefinitionRequest;
import org.cloudfoundry.client.v2.organizationquotadefinitions.CreateOrganizationQuotaDefinitionResponse;
import org.cloudfoundry.client.v2.organizationquotadefinitions.DeleteOrganizationQuotaDefinitionRequest;
import org.cloudfoundry.client.v2.organizationquotadefinitions.DeleteOrganizationQuotaDefinitionResponse;
import org.cloudfoundry.client.v2.organizationquotadefinitions.ListOrganizationQuotaDefinitionsRequest;
import org.cloudfoundry.client.v2.organizationquotadefinitions.OrganizationQuotaDefinitionEntity;
import org.cloudfoundry.client.v2.organizationquotadefinitions.OrganizationQuotaDefinitionResource;
import org.cloudfoundry.client.v2.organizationquotadefinitions.UpdateOrganizationQuotaDefinitionRequest;
import org.cloudfoundry.client.v2.organizationquotadefinitions.UpdateOrganizationQuotaDefinitionResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationsRequest;
import org.cloudfoundry.client.v2.organizations.OrganizationResource;
import org.cloudfoundry.client.v2.organizations.UpdateOrganizationRequest;
import org.cloudfoundry.client.v2.organizations.UpdateOrganizationResponse;
import org.cloudfoundry.operations.organizationadmin.CreateQuotaRequest;
import org.cloudfoundry.operations.organizationadmin.DeleteQuotaRequest;
import org.cloudfoundry.operations.organizationadmin.GetQuotaRequest;
import org.cloudfoundry.operations.organizationadmin.OrganizationAdmin;
import org.cloudfoundry.operations.organizationadmin.OrganizationQuota;
import org.cloudfoundry.operations.organizationadmin.SetQuotaRequest;
import org.cloudfoundry.operations.organizationadmin.UpdateQuotaRequest;
import org.cloudfoundry.operations.util.OperationsLogging;
import org.cloudfoundry.util.ExceptionUtils;
import org.cloudfoundry.util.JobUtils;
import org.cloudfoundry.util.PaginationUtils;
import org.cloudfoundry.util.ResourceUtils;
import org.cloudfoundry.util.tuple.TupleUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DefaultOrganizationAdmin
implements OrganizationAdmin {
    private final Mono<CloudFoundryClient> cloudFoundryClient;

    public DefaultOrganizationAdmin(Mono<CloudFoundryClient> cloudFoundryClient) {
        this.cloudFoundryClient = cloudFoundryClient;
    }

    @Override
    public Mono<OrganizationQuota> createQuota(CreateQuotaRequest request) {
        return this.cloudFoundryClient.then(cloudFoundryClient -> DefaultOrganizationAdmin.createOrganizationQuota(cloudFoundryClient, request)).map(DefaultOrganizationAdmin::toOrganizationQuota).transform(OperationsLogging.log("Create Organization Quota")).checkpoint();
    }

    @Override
    public Mono<Void> deleteQuota(DeleteQuotaRequest request) {
        return this.cloudFoundryClient.then(cloudFoundryClient -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), (Mono)Mono.just((Object)request.getCompletionTimeout()), DefaultOrganizationAdmin.getOrganizationQuotaId(cloudFoundryClient, request.getName()))).then(TupleUtils.function(DefaultOrganizationAdmin::deleteOrganizationQuota)).transform(OperationsLogging.log("Delete Organization Quota")).checkpoint();
    }

    @Override
    public Mono<OrganizationQuota> getQuota(GetQuotaRequest request) {
        return this.cloudFoundryClient.then(cloudFoundryClient -> DefaultOrganizationAdmin.getOrganizationQuota(cloudFoundryClient, request.getName())).map(DefaultOrganizationAdmin::toOrganizationQuota).transform(OperationsLogging.log("Get Organization Quota")).checkpoint();
    }

    @Override
    public Flux<OrganizationQuota> listQuotas() {
        return this.cloudFoundryClient.flatMap(DefaultOrganizationAdmin::requestListOrganizationQuotas).map(DefaultOrganizationAdmin::toOrganizationQuota).transform(OperationsLogging.log("List Organization Quotas")).checkpoint();
    }

    @Override
    public Mono<Void> setQuota(SetQuotaRequest request) {
        return this.cloudFoundryClient.then(cloudFoundryClient -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultOrganizationAdmin.getOrganizationId(cloudFoundryClient, request.getOrganizationName()), DefaultOrganizationAdmin.getOrganizationQuotaId(cloudFoundryClient, request.getQuotaName()))).then(TupleUtils.function(DefaultOrganizationAdmin::requestUpdateOrganization)).then().transform(OperationsLogging.log("Set Organization Quota")).checkpoint();
    }

    @Override
    public Mono<OrganizationQuota> updateQuota(UpdateQuotaRequest request) {
        return this.cloudFoundryClient.then(cloudFoundryClient -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultOrganizationAdmin.getOrganizationQuota(cloudFoundryClient, request.getName()))).then(TupleUtils.function((cloudFoundryClient, exitingQuotaDefinition) -> DefaultOrganizationAdmin.updateOrganizationQuota(cloudFoundryClient, request, exitingQuotaDefinition))).map(DefaultOrganizationAdmin::toOrganizationQuota).transform(OperationsLogging.log("Update Organization Quota")).checkpoint();
    }

    private static Mono<CreateOrganizationQuotaDefinitionResponse> createOrganizationQuota(CloudFoundryClient cloudFoundryClient, CreateQuotaRequest request) {
        return DefaultOrganizationAdmin.requestCreateOrganizationQuota(cloudFoundryClient, Optional.ofNullable(request.getInstanceMemoryLimit()).orElse(-1), Optional.ofNullable(request.getMemoryLimit()).orElse(0), request.getName(), Optional.ofNullable(request.getAllowPaidServicePlans()).orElse(false), Optional.ofNullable(request.getTotalRoutes()).orElse(0), Optional.ofNullable(request.getTotalServices()).orElse(0));
    }

    private static Mono<Void> deleteOrganizationQuota(CloudFoundryClient cloudFoundryClient, Duration completionTimeout, String quotaId) {
        return DefaultOrganizationAdmin.requestDeleteOrganizationQuota(cloudFoundryClient, quotaId).then(job -> JobUtils.waitForCompletion((CloudFoundryClient)cloudFoundryClient, (Duration)completionTimeout, (Resource)job));
    }

    private static Mono<String> getOrganizationId(CloudFoundryClient cloudFoundryClient, String name) {
        return DefaultOrganizationAdmin.requestListOrganizations(cloudFoundryClient, name).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Organization %s does not exist", (Object[])new Object[]{name})).map(ResourceUtils::getId);
    }

    private static Mono<OrganizationQuotaDefinitionResource> getOrganizationQuota(CloudFoundryClient cloudFoundryClient, String name) {
        return DefaultOrganizationAdmin.requestListOrganizationQuotas(cloudFoundryClient, name).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Quota %s does not exist", (Object[])new Object[]{name}));
    }

    private static Mono<String> getOrganizationQuotaId(CloudFoundryClient cloudFoundryClient, String name) {
        return DefaultOrganizationAdmin.getOrganizationQuota(cloudFoundryClient, name).map(ResourceUtils::getId);
    }

    private static Mono<CreateOrganizationQuotaDefinitionResponse> requestCreateOrganizationQuota(CloudFoundryClient cloudFoundryClient, Integer instanceMemoryLimit, Integer memoryLimit, String name, Boolean nonBasicServicesAllowed, Integer totalRoutes, Integer totalServices) {
        return cloudFoundryClient.organizationQuotaDefinitions().create(CreateOrganizationQuotaDefinitionRequest.builder().instanceMemoryLimit(instanceMemoryLimit).memoryLimit(memoryLimit).name(name).nonBasicServicesAllowed(nonBasicServicesAllowed).totalRoutes(totalRoutes).totalServices(totalServices).build());
    }

    private static Mono<DeleteOrganizationQuotaDefinitionResponse> requestDeleteOrganizationQuota(CloudFoundryClient cloudFoundryClient, String quotaId) {
        return cloudFoundryClient.organizationQuotaDefinitions().delete(DeleteOrganizationQuotaDefinitionRequest.builder().organizationQuotaDefinitionId(quotaId).async(Boolean.valueOf(true)).build());
    }

    private static Flux<OrganizationQuotaDefinitionResource> requestListOrganizationQuotas(CloudFoundryClient cloudFoundryClient) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizationQuotaDefinitions().list(ListOrganizationQuotaDefinitionsRequest.builder().page(page).build()));
    }

    private static Flux<OrganizationQuotaDefinitionResource> requestListOrganizationQuotas(CloudFoundryClient cloudFoundryClient, String name) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizationQuotaDefinitions().list(ListOrganizationQuotaDefinitionsRequest.builder().name(name).page(page).build()));
    }

    private static Flux<OrganizationResource> requestListOrganizations(CloudFoundryClient cloudFoundryClient, String name) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().list(ListOrganizationsRequest.builder().name(name).page(page).build()));
    }

    private static Mono<UpdateOrganizationResponse> requestUpdateOrganization(CloudFoundryClient cloudFoundryClient, String organizationId, String quotaDefinitionId) {
        return cloudFoundryClient.organizations().update(UpdateOrganizationRequest.builder().organizationId(organizationId).quotaDefinitionId(quotaDefinitionId).build());
    }

    private static Mono<UpdateOrganizationQuotaDefinitionResponse> requestUpdateOrganizationQuota(CloudFoundryClient cloudFoundryClient, String organizationQuotaDefinitionId, Integer instanceMemoryLimit, Integer memoryLimit, String name, Boolean nonBasicServicesAllowed, Integer totalRoutes, Integer totalServices) {
        return cloudFoundryClient.organizationQuotaDefinitions().update(UpdateOrganizationQuotaDefinitionRequest.builder().instanceMemoryLimit(instanceMemoryLimit).memoryLimit(memoryLimit).name(name).organizationQuotaDefinitionId(organizationQuotaDefinitionId).nonBasicServicesAllowed(nonBasicServicesAllowed).totalRoutes(totalRoutes).totalServices(totalServices).build());
    }

    private static OrganizationQuota toOrganizationQuota(AbstractOrganizationQuotaDefinition resource) {
        OrganizationQuotaDefinitionEntity entity = (OrganizationQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)resource);
        return OrganizationQuota.builder().allowPaidServicePlans(entity.getNonBasicServicesAllowed()).applicationInstanceLimit(entity.getApplicationInstanceLimit()).id(ResourceUtils.getId((Resource)resource)).instanceMemoryLimit(entity.getInstanceMemoryLimit()).memoryLimit(entity.getMemoryLimit()).name(entity.getName()).totalRoutes(entity.getTotalRoutes()).totalServices(entity.getTotalServices()).build();
    }

    private static Mono<UpdateOrganizationQuotaDefinitionResponse> updateOrganizationQuota(CloudFoundryClient cloudFoundryClient, UpdateQuotaRequest request, OrganizationQuotaDefinitionResource resource) {
        OrganizationQuotaDefinitionEntity existing = (OrganizationQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)resource);
        return DefaultOrganizationAdmin.requestUpdateOrganizationQuota(cloudFoundryClient, ResourceUtils.getId((Resource)resource), Optional.ofNullable(request.getInstanceMemoryLimit()).orElse(existing.getInstanceMemoryLimit()), Optional.ofNullable(request.getMemoryLimit()).orElse(existing.getMemoryLimit()), Optional.ofNullable(request.getNewName()).orElse(existing.getName()), Optional.ofNullable(request.getAllowPaidServicePlans()).orElse(existing.getNonBasicServicesAllowed()), Optional.ofNullable(request.getTotalRoutes()).orElse(existing.getTotalRoutes()), Optional.ofNullable(request.getTotalServices()).orElse(existing.getTotalServices()));
    }
}

