/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.cloudfoundry.operations.applications.Route;
import org.cloudfoundry.operations.applications._ApplicationManifest;

public final class ApplicationManifest
extends _ApplicationManifest {
    @Nullable
    private final String buildpack;
    @Nullable
    private final String command;
    @Nullable
    private final Integer disk;
    @Nullable
    private final String dockerImage;
    @Nullable
    private final List<String> domains;
    @Nullable
    private final Map<String, Object> environmentVariables;
    @Nullable
    private final String healthCheckHttpEndpoint;
    @Nullable
    private final ApplicationHealthCheck healthCheckType;
    @Nullable
    private final List<String> hosts;
    @Nullable
    private final Integer instances;
    @Nullable
    private final Integer memory;
    private final String name;
    @Nullable
    private final Boolean noHostname;
    @Nullable
    private final Boolean noRoute;
    @Nullable
    private final Path path;
    @Nullable
    private final Boolean randomRoute;
    @Nullable
    private final String routePath;
    @Nullable
    private final List<Route> routes;
    @Nullable
    private final List<String> services;
    @Nullable
    private final String stack;
    @Nullable
    private final Integer timeout;

    private ApplicationManifest(Builder builder) {
        this.buildpack = builder.buildpack;
        this.command = builder.command;
        this.disk = builder.disk;
        this.dockerImage = builder.dockerImage;
        this.domains = builder.domains == null ? null : ApplicationManifest.createUnmodifiableList(true, builder.domains);
        this.environmentVariables = builder.environmentVariables == null ? null : ApplicationManifest.createUnmodifiableMap(false, false, builder.environmentVariables);
        this.healthCheckHttpEndpoint = builder.healthCheckHttpEndpoint;
        this.healthCheckType = builder.healthCheckType;
        this.hosts = builder.hosts == null ? null : ApplicationManifest.createUnmodifiableList(true, builder.hosts);
        this.instances = builder.instances;
        this.memory = builder.memory;
        this.name = builder.name;
        this.noHostname = builder.noHostname;
        this.noRoute = builder.noRoute;
        this.path = builder.path;
        this.randomRoute = builder.randomRoute;
        this.routePath = builder.routePath;
        this.routes = builder.routes == null ? null : ApplicationManifest.createUnmodifiableList(true, builder.routes);
        this.services = builder.services == null ? null : ApplicationManifest.createUnmodifiableList(true, builder.services);
        this.stack = builder.stack;
        this.timeout = builder.timeout;
    }

    @Override
    @Nullable
    public String getBuildpack() {
        return this.buildpack;
    }

    @Override
    @Nullable
    public String getCommand() {
        return this.command;
    }

    @Override
    @Nullable
    public Integer getDisk() {
        return this.disk;
    }

    @Override
    @Nullable
    public String getDockerImage() {
        return this.dockerImage;
    }

    @Override
    @Nullable
    public List<String> getDomains() {
        return this.domains;
    }

    @Override
    @Nullable
    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    @Nullable
    public String getHealthCheckHttpEndpoint() {
        return this.healthCheckHttpEndpoint;
    }

    @Override
    @Nullable
    public ApplicationHealthCheck getHealthCheckType() {
        return this.healthCheckType;
    }

    @Override
    @Nullable
    public List<String> getHosts() {
        return this.hosts;
    }

    @Override
    @Nullable
    public Integer getInstances() {
        return this.instances;
    }

    @Override
    @Nullable
    public Integer getMemory() {
        return this.memory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Boolean getNoHostname() {
        return this.noHostname;
    }

    @Override
    @Nullable
    public Boolean getNoRoute() {
        return this.noRoute;
    }

    @Override
    @Nullable
    public Path getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public Boolean getRandomRoute() {
        return this.randomRoute;
    }

    @Override
    @Nullable
    public String getRoutePath() {
        return this.routePath;
    }

    @Override
    @Nullable
    public List<Route> getRoutes() {
        return this.routes;
    }

    @Override
    @Nullable
    public List<String> getServices() {
        return this.services;
    }

    @Override
    @Nullable
    public String getStack() {
        return this.stack;
    }

    @Override
    @Nullable
    public Integer getTimeout() {
        return this.timeout;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ApplicationManifest && this.equalTo((ApplicationManifest)another);
    }

    private boolean equalTo(ApplicationManifest another) {
        return Objects.equals(this.buildpack, another.buildpack) && Objects.equals(this.command, another.command) && Objects.equals(this.disk, another.disk) && Objects.equals(this.dockerImage, another.dockerImage) && Objects.equals(this.domains, another.domains) && Objects.equals(this.environmentVariables, another.environmentVariables) && Objects.equals(this.healthCheckHttpEndpoint, another.healthCheckHttpEndpoint) && Objects.equals((Object)this.healthCheckType, (Object)another.healthCheckType) && Objects.equals(this.hosts, another.hosts) && Objects.equals(this.instances, another.instances) && Objects.equals(this.memory, another.memory) && this.name.equals(another.name) && Objects.equals(this.noHostname, another.noHostname) && Objects.equals(this.noRoute, another.noRoute) && Objects.equals(this.path, another.path) && Objects.equals(this.randomRoute, another.randomRoute) && Objects.equals(this.routePath, another.routePath) && Objects.equals(this.routes, another.routes) && Objects.equals(this.services, another.services) && Objects.equals(this.stack, another.stack) && Objects.equals(this.timeout, another.timeout);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.buildpack);
        h += (h << 5) + Objects.hashCode(this.command);
        h += (h << 5) + Objects.hashCode(this.disk);
        h += (h << 5) + Objects.hashCode(this.dockerImage);
        h += (h << 5) + Objects.hashCode(this.domains);
        h += (h << 5) + Objects.hashCode(this.environmentVariables);
        h += (h << 5) + Objects.hashCode(this.healthCheckHttpEndpoint);
        h += (h << 5) + Objects.hashCode((Object)this.healthCheckType);
        h += (h << 5) + Objects.hashCode(this.hosts);
        h += (h << 5) + Objects.hashCode(this.instances);
        h += (h << 5) + Objects.hashCode(this.memory);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.noHostname);
        h += (h << 5) + Objects.hashCode(this.noRoute);
        h += (h << 5) + Objects.hashCode(this.path);
        h += (h << 5) + Objects.hashCode(this.randomRoute);
        h += (h << 5) + Objects.hashCode(this.routePath);
        h += (h << 5) + Objects.hashCode(this.routes);
        h += (h << 5) + Objects.hashCode(this.services);
        h += (h << 5) + Objects.hashCode(this.stack);
        h += (h << 5) + Objects.hashCode(this.timeout);
        return h;
    }

    public String toString() {
        return "ApplicationManifest{buildpack=" + this.buildpack + ", command=" + this.command + ", disk=" + this.disk + ", dockerImage=" + this.dockerImage + ", domains=" + this.domains + ", environmentVariables=" + this.environmentVariables + ", healthCheckHttpEndpoint=" + this.healthCheckHttpEndpoint + ", healthCheckType=" + (Object)((Object)this.healthCheckType) + ", hosts=" + this.hosts + ", instances=" + this.instances + ", memory=" + this.memory + ", name=" + this.name + ", noHostname=" + this.noHostname + ", noRoute=" + this.noRoute + ", path=" + this.path + ", randomRoute=" + this.randomRoute + ", routePath=" + this.routePath + ", routes=" + this.routes + ", services=" + this.services + ", stack=" + this.stack + ", timeout=" + this.timeout + "}";
    }

    private static ApplicationManifest validate(ApplicationManifest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String buildpack;
        private String command;
        private Integer disk;
        private String dockerImage;
        private List<String> domains = null;
        private Map<String, Object> environmentVariables = null;
        private String healthCheckHttpEndpoint;
        private ApplicationHealthCheck healthCheckType;
        private List<String> hosts = null;
        private Integer instances;
        private Integer memory;
        private String name;
        private Boolean noHostname;
        private Boolean noRoute;
        private Path path;
        private Boolean randomRoute;
        private String routePath;
        private List<Route> routes = null;
        private List<String> services = null;
        private String stack;
        private Integer timeout;

        private Builder() {
        }

        public final Builder from(ApplicationManifest instance) {
            return this.from((_ApplicationManifest)instance);
        }

        final Builder from(_ApplicationManifest instance) {
            Integer timeoutValue;
            String stackValue;
            List<String> servicesValue;
            List<Route> routesValue;
            String routePathValue;
            Boolean randomRouteValue;
            Path pathValue;
            Boolean noRouteValue;
            Integer memoryValue;
            Integer instancesValue;
            List<String> hostsValue;
            ApplicationHealthCheck healthCheckTypeValue;
            String healthCheckHttpEndpointValue;
            Map<String, Object> environmentVariablesValue;
            List<String> domainsValue;
            String dockerImageValue;
            Integer diskValue;
            String commandValue;
            Objects.requireNonNull(instance, "instance");
            String buildpackValue = instance.getBuildpack();
            if (buildpackValue != null) {
                this.buildpack(buildpackValue);
            }
            if ((commandValue = instance.getCommand()) != null) {
                this.command(commandValue);
            }
            if ((diskValue = instance.getDisk()) != null) {
                this.disk(diskValue);
            }
            if ((dockerImageValue = instance.getDockerImage()) != null) {
                this.dockerImage(dockerImageValue);
            }
            if ((domainsValue = instance.getDomains()) != null) {
                this.addAllDomains(domainsValue);
            }
            if ((environmentVariablesValue = instance.getEnvironmentVariables()) != null) {
                this.putAllEnvironmentVariables(environmentVariablesValue);
            }
            if ((healthCheckHttpEndpointValue = instance.getHealthCheckHttpEndpoint()) != null) {
                this.healthCheckHttpEndpoint(healthCheckHttpEndpointValue);
            }
            if ((healthCheckTypeValue = instance.getHealthCheckType()) != null) {
                this.healthCheckType(healthCheckTypeValue);
            }
            if ((hostsValue = instance.getHosts()) != null) {
                this.addAllHosts(hostsValue);
            }
            if ((instancesValue = instance.getInstances()) != null) {
                this.instances(instancesValue);
            }
            if ((memoryValue = instance.getMemory()) != null) {
                this.memory(memoryValue);
            }
            this.name(instance.getName());
            Boolean noHostnameValue = instance.getNoHostname();
            if (noHostnameValue != null) {
                this.noHostname(noHostnameValue);
            }
            if ((noRouteValue = instance.getNoRoute()) != null) {
                this.noRoute(noRouteValue);
            }
            if ((pathValue = instance.getPath()) != null) {
                this.path(pathValue);
            }
            if ((randomRouteValue = instance.getRandomRoute()) != null) {
                this.randomRoute(randomRouteValue);
            }
            if ((routePathValue = instance.getRoutePath()) != null) {
                this.routePath(routePathValue);
            }
            if ((routesValue = instance.getRoutes()) != null) {
                this.addAllRoutes(routesValue);
            }
            if ((servicesValue = instance.getServices()) != null) {
                this.addAllServices(servicesValue);
            }
            if ((stackValue = instance.getStack()) != null) {
                this.stack(stackValue);
            }
            if ((timeoutValue = instance.getTimeout()) != null) {
                this.timeout(timeoutValue);
            }
            return this;
        }

        public final Builder buildpack(@Nullable String buildpack) {
            this.buildpack = buildpack;
            return this;
        }

        public final Builder command(@Nullable String command) {
            this.command = command;
            return this;
        }

        public final Builder disk(@Nullable Integer disk) {
            this.disk = disk;
            return this;
        }

        public final Builder dockerImage(@Nullable String dockerImage) {
            this.dockerImage = dockerImage;
            return this;
        }

        public final Builder domain(String element) {
            if (this.domains == null) {
                this.domains = new ArrayList<String>();
            }
            this.domains.add(Objects.requireNonNull(element, "domains element"));
            return this;
        }

        public final Builder domain(String ... elements) {
            if (this.domains == null) {
                this.domains = new ArrayList<String>();
            }
            for (String element : elements) {
                this.domains.add(Objects.requireNonNull(element, "domains element"));
            }
            return this;
        }

        public final Builder domains(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.domains = null;
                return this;
            }
            this.domains = new ArrayList<String>();
            return this.addAllDomains(elements);
        }

        public final Builder addAllDomains(Iterable<String> elements) {
            Objects.requireNonNull(elements, "domains element");
            if (this.domains == null) {
                this.domains = new ArrayList<String>();
            }
            for (String element : elements) {
                this.domains.add(Objects.requireNonNull(element, "domains element"));
            }
            return this;
        }

        public final Builder environmentVariable(String key, Object value) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, Object>();
            }
            this.environmentVariables.put(key, value);
            return this;
        }

        public final Builder environmentVariable(Map.Entry<String, ? extends Object> entry) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.environmentVariables.put(k, v);
            return this;
        }

        public final Builder environmentVariables(@Nullable Map<String, ? extends Object> environmentVariables) {
            if (environmentVariables == null) {
                this.environmentVariables = null;
                return this;
            }
            this.environmentVariables = new LinkedHashMap<String, Object>();
            return this.putAllEnvironmentVariables(environmentVariables);
        }

        public final Builder putAllEnvironmentVariables(Map<String, ? extends Object> environmentVariables) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : environmentVariables.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.environmentVariables.put(k, v);
            }
            return this;
        }

        public final Builder healthCheckHttpEndpoint(@Nullable String healthCheckHttpEndpoint) {
            this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
            return this;
        }

        public final Builder healthCheckType(@Nullable ApplicationHealthCheck healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final Builder host(String element) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<String>();
            }
            this.hosts.add(Objects.requireNonNull(element, "hosts element"));
            return this;
        }

        public final Builder host(String ... elements) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<String>();
            }
            for (String element : elements) {
                this.hosts.add(Objects.requireNonNull(element, "hosts element"));
            }
            return this;
        }

        public final Builder hosts(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.hosts = null;
                return this;
            }
            this.hosts = new ArrayList<String>();
            return this.addAllHosts(elements);
        }

        public final Builder addAllHosts(Iterable<String> elements) {
            Objects.requireNonNull(elements, "hosts element");
            if (this.hosts == null) {
                this.hosts = new ArrayList<String>();
            }
            for (String element : elements) {
                this.hosts.add(Objects.requireNonNull(element, "hosts element"));
            }
            return this;
        }

        public final Builder instances(@Nullable Integer instances) {
            this.instances = instances;
            return this;
        }

        public final Builder memory(@Nullable Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder noHostname(@Nullable Boolean noHostname) {
            this.noHostname = noHostname;
            return this;
        }

        public final Builder noRoute(@Nullable Boolean noRoute) {
            this.noRoute = noRoute;
            return this;
        }

        public final Builder path(@Nullable Path path) {
            this.path = path;
            return this;
        }

        public final Builder randomRoute(@Nullable Boolean randomRoute) {
            this.randomRoute = randomRoute;
            return this;
        }

        public final Builder routePath(@Nullable String routePath) {
            this.routePath = routePath;
            return this;
        }

        public final Builder route(Route element) {
            if (this.routes == null) {
                this.routes = new ArrayList<Route>();
            }
            this.routes.add(Objects.requireNonNull(element, "routes element"));
            return this;
        }

        public final Builder route(Route ... elements) {
            if (this.routes == null) {
                this.routes = new ArrayList<Route>();
            }
            for (Route element : elements) {
                this.routes.add(Objects.requireNonNull(element, "routes element"));
            }
            return this;
        }

        public final Builder routes(@Nullable Iterable<? extends Route> elements) {
            if (elements == null) {
                this.routes = null;
                return this;
            }
            this.routes = new ArrayList<Route>();
            return this.addAllRoutes(elements);
        }

        public final Builder addAllRoutes(Iterable<? extends Route> elements) {
            Objects.requireNonNull(elements, "routes element");
            if (this.routes == null) {
                this.routes = new ArrayList<Route>();
            }
            for (Route route : elements) {
                this.routes.add(Objects.requireNonNull(route, "routes element"));
            }
            return this;
        }

        public final Builder service(String element) {
            if (this.services == null) {
                this.services = new ArrayList<String>();
            }
            this.services.add(Objects.requireNonNull(element, "services element"));
            return this;
        }

        public final Builder service(String ... elements) {
            if (this.services == null) {
                this.services = new ArrayList<String>();
            }
            for (String element : elements) {
                this.services.add(Objects.requireNonNull(element, "services element"));
            }
            return this;
        }

        public final Builder services(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.services = null;
                return this;
            }
            this.services = new ArrayList<String>();
            return this.addAllServices(elements);
        }

        public final Builder addAllServices(Iterable<String> elements) {
            Objects.requireNonNull(elements, "services element");
            if (this.services == null) {
                this.services = new ArrayList<String>();
            }
            for (String element : elements) {
                this.services.add(Objects.requireNonNull(element, "services element"));
            }
            return this;
        }

        public final Builder stack(@Nullable String stack) {
            this.stack = stack;
            return this;
        }

        public final Builder timeout(@Nullable Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public ApplicationManifest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ApplicationManifest.validate(new ApplicationManifest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build ApplicationManifest, some of required attributes are not set " + attributes;
        }
    }
}

