/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.cloudfoundry.operations.applications.ApplicationManifest;
import org.cloudfoundry.operations.applications.Route;
import org.cloudfoundry.util.tuple.Consumer2;
import reactor.core.Exceptions;

public final class ApplicationManifestUtils {
    private static final int GIBI = 1024;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES)).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    private ApplicationManifestUtils() {
    }

    public static List<ApplicationManifest> read(Path path) {
        return ApplicationManifestUtils.doRead(path.toAbsolutePath()).values().stream().map(ApplicationManifest.Builder::build).collect(Collectors.toList());
    }

    public static void write(Path path, ApplicationManifest ... applicationManifests) {
        ApplicationManifestUtils.write(path, Arrays.asList(applicationManifests));
    }

    public static void write(Path path, List<ApplicationManifest> applicationManifests) {
        try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            ApplicationManifestUtils.write(out, applicationManifests);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static void write(OutputStream out, ApplicationManifest ... applicationManifests) {
        ApplicationManifestUtils.write(out, Arrays.asList(applicationManifests));
    }

    public static void write(OutputStream out, List<ApplicationManifest> applicationManifests) {
        try {
            OBJECT_MAPPER.writeValue(out, Collections.singletonMap("applications", applicationManifests));
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static <T> void as(JsonNode payload, String key, Function<JsonNode, T> mapper, Consumer<T> consumer) {
        Optional.ofNullable(payload.get(key)).map(mapper).ifPresent(consumer);
    }

    private static void asBoolean(JsonNode payload, String key, Consumer<Boolean> consumer) {
        ApplicationManifestUtils.as(payload, key, JsonNode::asBoolean, consumer);
    }

    private static void asInteger(JsonNode payload, String key, Consumer<Integer> consumer) {
        ApplicationManifestUtils.as(payload, key, JsonNode::asInt, consumer);
    }

    private static <T> void asList(JsonNode payload, String key, Function<JsonNode, T> mapper, Consumer<T> consumer) {
        ApplicationManifestUtils.as(payload, key, ApplicationManifestUtils::streamOf, domains -> domains.map(mapper).forEach(consumer));
    }

    private static void asListOfString(JsonNode payload, String key, Consumer<String> consumer) {
        ApplicationManifestUtils.asList(payload, key, JsonNode::asText, consumer);
    }

    private static <T> void asMap(JsonNode payload, String key, Function<JsonNode, T> valueMapper, Consumer2<String, T> consumer) {
        ApplicationManifestUtils.as(payload, key, environmentVariables -> ApplicationManifestUtils.streamOf(environmentVariables.fields()), environmentVariables -> environmentVariables.forEach(entry -> consumer.accept(entry.getKey(), valueMapper.apply((JsonNode)entry.getValue()))));
    }

    private static void asMapOfStringString(JsonNode payload, String key, Consumer2<String, String> consumer) {
        ApplicationManifestUtils.asMap(payload, key, JsonNode::asText, consumer);
    }

    private static void asMemoryInteger(JsonNode payload, String key, Consumer<Integer> consumer) {
        ApplicationManifestUtils.as(payload, key, raw -> {
            if (raw.isNumber()) {
                return raw.asInt();
            }
            if (raw.isTextual()) {
                String text = raw.asText().toUpperCase();
                if (text.endsWith("G")) {
                    return Integer.parseInt(text.substring(0, text.length() - 1)) * 1024;
                }
                if (text.endsWith("GB")) {
                    return Integer.parseInt(text.substring(0, text.length() - 2)) * 1024;
                }
                if (text.endsWith("M")) {
                    return Integer.parseInt(text.substring(0, text.length() - 1));
                }
                if (text.endsWith("MB")) {
                    return Integer.parseInt(text.substring(0, text.length() - 2));
                }
                return 0;
            }
            return 0;
        }, consumer);
    }

    private static void asString(JsonNode payload, String key, Consumer<String> consumer) {
        ApplicationManifestUtils.as(payload, key, JsonNode::asText, consumer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonNode deserialize(Path path) {
        try (InputStream in = Files.newInputStream(path, StandardOpenOption.READ);){
            JsonNode jsonNode = OBJECT_MAPPER.readTree(in);
            return jsonNode;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static Map<String, ApplicationManifest.Builder> doRead(Path path) {
        TreeMap<String, ApplicationManifest.Builder> applicationManifests = new TreeMap<String, ApplicationManifest.Builder>();
        JsonNode root = ApplicationManifestUtils.deserialize(path);
        ApplicationManifestUtils.asString(root, "inherit", inherit -> applicationManifests.putAll(ApplicationManifestUtils.doRead(path.getParent().resolve((String)inherit))));
        applicationManifests.forEach((name, builder) -> applicationManifests.put((String)name, ApplicationManifestUtils.toApplicationManifest(root, builder, path)));
        ApplicationManifest template = ApplicationManifestUtils.getTemplate(path, root);
        Optional.ofNullable(root.get("applications")).map(ApplicationManifestUtils::streamOf).ifPresent(applications -> applications.forEach(application -> {
            String name = ApplicationManifestUtils.getName(application);
            ApplicationManifest.Builder builder = ApplicationManifestUtils.getBuilder(applicationManifests, template, name);
            applicationManifests.put(name, ApplicationManifestUtils.toApplicationManifest(application, builder, path));
        }));
        return applicationManifests;
    }

    private static ApplicationManifest.Builder getBuilder(Map<String, ApplicationManifest.Builder> applicationManifests, ApplicationManifest template, String name) {
        ApplicationManifest.Builder builder = applicationManifests.get(name);
        if (builder == null) {
            builder = ApplicationManifest.builder().from(template);
        }
        return builder;
    }

    private static String getName(JsonNode raw) {
        return Optional.ofNullable(raw.get("name")).map(JsonNode::asText).orElseThrow(() -> new IllegalStateException("Application does not contain required 'name' value"));
    }

    private static Route getRoute(JsonNode raw) {
        String route = Optional.ofNullable(raw.get("route")).map(JsonNode::asText).orElseThrow(() -> new IllegalStateException("Route does not contain required 'route' value"));
        return Route.builder().route(route).build();
    }

    private static ApplicationManifest getTemplate(Path path, JsonNode root) {
        return ApplicationManifestUtils.toApplicationManifest(root, ApplicationManifest.builder(), path).name("template").build();
    }

    private static <T> Stream<T> streamOf(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    private static <T> Stream<T> streamOf(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private static ApplicationManifest.Builder toApplicationManifest(JsonNode application, ApplicationManifest.Builder builder, Path root) {
        ApplicationManifestUtils.asString(application, "buildpack", builder::buildpack);
        ApplicationManifestUtils.asString(application, "command", builder::command);
        ApplicationManifestUtils.asMemoryInteger(application, "disk_quota", builder::disk);
        ApplicationManifestUtils.asString(application, "domain", builder::domain);
        ApplicationManifestUtils.asListOfString(application, "domains", builder::domain);
        ApplicationManifestUtils.asMapOfStringString(application, "env", (Consumer2<String, String>)((Consumer2)builder::environmentVariable));
        ApplicationManifestUtils.asString(application, "health-check-http-endpoint", builder::healthCheckHttpEndpoint);
        ApplicationManifestUtils.asString(application, "health-check-type", healthCheckType -> builder.healthCheckType(ApplicationHealthCheck.from(healthCheckType)));
        ApplicationManifestUtils.asString(application, "host", builder::host);
        ApplicationManifestUtils.asListOfString(application, "hosts", builder::host);
        ApplicationManifestUtils.asInteger(application, "instances", builder::instances);
        ApplicationManifestUtils.asMemoryInteger(application, "memory", builder::memory);
        ApplicationManifestUtils.asString(application, "name", builder::name);
        ApplicationManifestUtils.asBoolean(application, "no-hostname", builder::noHostname);
        ApplicationManifestUtils.asBoolean(application, "no-route", builder::noRoute);
        ApplicationManifestUtils.asString(application, "path", path -> builder.path(root.getParent().resolve((String)path)));
        ApplicationManifestUtils.asBoolean(application, "random-route", builder::randomRoute);
        ApplicationManifestUtils.asList(application, "routes", ApplicationManifestUtils::getRoute, builder::route);
        ApplicationManifestUtils.asListOfString(application, "services", builder::service);
        ApplicationManifestUtils.asString(application, "stack", builder::stack);
        ApplicationManifestUtils.asInteger(application, "timeout", builder::timeout);
        return builder;
    }
}

