package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request options for the get application events operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetApplicationEventsRequest"})
public final class GetApplicationEventsRequest
    extends org.cloudfoundry.operations.applications._GetApplicationEventsRequest {
  private final @Nullable Integer maxNumberOfEvents;
  private final String name;

  private GetApplicationEventsRequest(GetApplicationEventsRequest.Builder builder) {
    this.maxNumberOfEvents = builder.maxNumberOfEvents;
    this.name = builder.name;
  }

  /**
   * The maximum number of events
   */
  @Override
  public @Nullable Integer getMaxNumberOfEvents() {
    return maxNumberOfEvents;
  }

  /**
   * The application name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code GetApplicationEventsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetApplicationEventsRequest
        && equalTo((GetApplicationEventsRequest) another);
  }

  private boolean equalTo(GetApplicationEventsRequest another) {
    return Objects.equals(maxNumberOfEvents, another.maxNumberOfEvents)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code maxNumberOfEvents}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(maxNumberOfEvents);
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetApplicationEventsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetApplicationEventsRequest{"
        + "maxNumberOfEvents=" + maxNumberOfEvents
        + ", name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link GetApplicationEventsRequest GetApplicationEventsRequest}.
   * @return A new GetApplicationEventsRequest builder
   */
  public static GetApplicationEventsRequest.Builder builder() {
    return new GetApplicationEventsRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetApplicationEventsRequest GetApplicationEventsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private Integer maxNumberOfEvents;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetApplicationEventsRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetApplicationEventsRequest instance) {
      return from((_GetApplicationEventsRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetApplicationEventsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetApplicationEventsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Integer maxNumberOfEventsValue = instance.getMaxNumberOfEvents();
      if (maxNumberOfEventsValue != null) {
        maxNumberOfEvents(maxNumberOfEventsValue);
      }
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link _GetApplicationEventsRequest#getMaxNumberOfEvents() maxNumberOfEvents} attribute.
     * @param maxNumberOfEvents The value for maxNumberOfEvents (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder maxNumberOfEvents(@Nullable Integer maxNumberOfEvents) {
      this.maxNumberOfEvents = maxNumberOfEvents;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetApplicationEventsRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link GetApplicationEventsRequest GetApplicationEventsRequest}.
     * @return An immutable instance of GetApplicationEventsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetApplicationEventsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetApplicationEventsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build GetApplicationEventsRequest, some of required attributes are not set " + attributes;
    }
  }
}
