/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.useradmin;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.operations.useradmin.OrganizationRole;
import org.cloudfoundry.operations.useradmin._SetOrganizationRoleRequest;

public final class SetOrganizationRoleRequest
extends _SetOrganizationRoleRequest {
    private final String organizationName;
    private final OrganizationRole organizationRole;
    private final String username;

    private SetOrganizationRoleRequest(Builder builder) {
        this.organizationName = builder.organizationName;
        this.organizationRole = builder.organizationRole;
        this.username = builder.username;
    }

    @Override
    public String getOrganizationName() {
        return this.organizationName;
    }

    @Override
    public OrganizationRole getOrganizationRole() {
        return this.organizationRole;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SetOrganizationRoleRequest && this.equalTo((SetOrganizationRoleRequest)another);
    }

    private boolean equalTo(SetOrganizationRoleRequest another) {
        return this.organizationName.equals(another.organizationName) && this.organizationRole.equals((Object)another.organizationRole) && this.username.equals(another.username);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.organizationName.hashCode();
        h += (h << 5) + this.organizationRole.hashCode();
        h += (h << 5) + this.username.hashCode();
        return h;
    }

    public String toString() {
        return "SetOrganizationRoleRequest{organizationName=" + this.organizationName + ", organizationRole=" + (Object)((Object)this.organizationRole) + ", username=" + this.username + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ORGANIZATION_NAME = 1L;
        private static final long INIT_BIT_ORGANIZATION_ROLE = 2L;
        private static final long INIT_BIT_USERNAME = 4L;
        private long initBits = 7L;
        private String organizationName;
        private OrganizationRole organizationRole;
        private String username;

        private Builder() {
        }

        public final Builder from(SetOrganizationRoleRequest instance) {
            return this.from((_SetOrganizationRoleRequest)instance);
        }

        final Builder from(_SetOrganizationRoleRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.organizationName(instance.getOrganizationName());
            this.organizationRole(instance.getOrganizationRole());
            this.username(instance.getUsername());
            return this;
        }

        public final Builder organizationName(String organizationName) {
            this.organizationName = Objects.requireNonNull(organizationName, "organizationName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder organizationRole(OrganizationRole organizationRole) {
            this.organizationRole = Objects.requireNonNull(organizationRole, "organizationRole");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public SetOrganizationRoleRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new SetOrganizationRoleRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("organizationName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("organizationRole");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("username");
            }
            return "Cannot build SetOrganizationRoleRequest, some of required attributes are not set " + attributes;
        }
    }
}

