package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The components of a manifest route
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_DecomposedRoute", generator = "Immutables")
public final class DecomposedRoute extends org.cloudfoundry.operations.applications._DecomposedRoute {
  private final String domain;
  private final @Nullable String host;
  private final @Nullable String path;
  private final @Nullable Integer port;

  private DecomposedRoute(DecomposedRoute.Builder builder) {
    this.domain = builder.domain;
    this.host = builder.host;
    this.path = builder.path;
    this.port = builder.port;
  }

  /**
   * The domain
   */
  @Override
  public String getDomain() {
    return domain;
  }

  /**
   * The host
   */
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The path
   */
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * The port
   */
  @Override
  public @Nullable Integer getPort() {
    return port;
  }

  /**
   * This instance is equal to all instances of {@code DecomposedRoute} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DecomposedRoute
        && equalTo((DecomposedRoute) another);
  }

  private boolean equalTo(DecomposedRoute another) {
    return domain.equals(another.domain)
        && Objects.equals(host, another.host)
        && Objects.equals(path, another.path)
        && Objects.equals(port, another.port);
  }

  /**
   * Computes a hash code from attributes: {@code domain}, {@code host}, {@code path}, {@code port}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + domain.hashCode();
    h += (h << 5) + Objects.hashCode(host);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(port);
    return h;
  }

  /**
   * Prints the immutable value {@code DecomposedRoute} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DecomposedRoute{"
        + "domain=" + domain
        + ", host=" + host
        + ", path=" + path
        + ", port=" + port
        + "}";
  }

  /**
   * Creates a builder for {@link DecomposedRoute DecomposedRoute}.
   * @return A new DecomposedRoute builder
   */
  public static DecomposedRoute.Builder builder() {
    return new DecomposedRoute.Builder();
  }

  /**
   * Builds instances of type {@link DecomposedRoute DecomposedRoute}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN = 0x1L;
    private long initBits = 0x1L;

    private String domain;
    private String host;
    private String path;
    private Integer port;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DecomposedRoute} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DecomposedRoute instance) {
      return from((_DecomposedRoute) instance);
    }

    /**
     * Copy abstract value type {@code _DecomposedRoute} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DecomposedRoute instance) {
      Objects.requireNonNull(instance, "instance");
      domain(instance.getDomain());
      String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      Integer portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DecomposedRoute#getDomain() domain} attribute.
     * @param domain The value for domain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String domain) {
      this.domain = Objects.requireNonNull(domain, "domain");
      initBits &= ~INIT_BIT_DOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link DecomposedRoute#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link DecomposedRoute#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link DecomposedRoute#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }

    /**
     * Builds a new {@link DecomposedRoute DecomposedRoute}.
     * @return An immutable instance of DecomposedRoute
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DecomposedRoute build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DecomposedRoute(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOMAIN) != 0) attributes.add("domain");
      return "Cannot build DecomposedRoute, some of required attributes are not set " + attributes;
    }
  }
}
