package org.cloudfoundry.operations.useradmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request options for the create user operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_CreateUserRequest", generator = "Immutables")
public final class CreateUserRequest extends org.cloudfoundry.operations.useradmin._CreateUserRequest {
  private final @Nullable String origin;
  private final @Nullable String password;
  private final String username;

  private CreateUserRequest(CreateUserRequest.Builder builder) {
    this.origin = builder.origin;
    this.password = builder.password;
    this.username = builder.username;
  }

  /**
   * The identity provider that authenticated the new user
   */
  @Override
  public @Nullable String getOrigin() {
    return origin;
  }

  /**
   * The password of the new user
   */
  @Override
  public @Nullable String getPassword() {
    return password;
  }

  /**
   * The username of the new user
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code CreateUserRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateUserRequest
        && equalTo((CreateUserRequest) another);
  }

  private boolean equalTo(CreateUserRequest another) {
    return Objects.equals(origin, another.origin)
        && Objects.equals(password, another.password)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code origin}, {@code password}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(origin);
    h += (h << 5) + Objects.hashCode(password);
    h += (h << 5) + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateUserRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateUserRequest{"
        + "origin=" + origin
        + ", password=" + password
        + ", username=" + username
        + "}";
  }


  private static CreateUserRequest validate(CreateUserRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link CreateUserRequest CreateUserRequest}.
   * @return A new CreateUserRequest builder
   */
  public static CreateUserRequest.Builder builder() {
    return new CreateUserRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateUserRequest CreateUserRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_USERNAME = 0x1L;
    private long initBits = 0x1L;

    private String origin;
    private String password;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateUserRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateUserRequest instance) {
      return from((_CreateUserRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateUserRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String originValue = instance.getOrigin();
      if (originValue != null) {
        origin(originValue);
      }
      String passwordValue = instance.getPassword();
      if (passwordValue != null) {
        password(passwordValue);
      }
      username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateUserRequest#getOrigin() origin} attribute.
     * @param origin The value for origin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(@Nullable String origin) {
      this.origin = origin;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateUserRequest#getPassword() password} attribute.
     * @param password The value for password (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(@Nullable String password) {
      this.password = password;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateUserRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link CreateUserRequest CreateUserRequest}.
     * @return An immutable instance of CreateUserRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateUserRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return CreateUserRequest.validate(new CreateUserRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build CreateUserRequest, some of required attributes are not set " + attributes;
    }
  }
}
