package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request options for the set environment variable of an application operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UnsetEnvironmentVariableApplicationRequest"})
public final class UnsetEnvironmentVariableApplicationRequest
    extends org.cloudfoundry.operations.applications._UnsetEnvironmentVariableApplicationRequest {
  private final String name;
  private final String variableName;

  private UnsetEnvironmentVariableApplicationRequest(UnsetEnvironmentVariableApplicationRequest.Builder builder) {
    this.name = builder.name;
    this.variableName = builder.variableName;
  }

  /**
   * The application name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The variable name
   */
  @Override
  public String getVariableName() {
    return variableName;
  }

  /**
   * This instance is equal to all instances of {@code UnsetEnvironmentVariableApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UnsetEnvironmentVariableApplicationRequest
        && equalTo((UnsetEnvironmentVariableApplicationRequest) another);
  }

  private boolean equalTo(UnsetEnvironmentVariableApplicationRequest another) {
    return name.equals(another.name)
        && variableName.equals(another.variableName);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code variableName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + variableName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UnsetEnvironmentVariableApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UnsetEnvironmentVariableApplicationRequest{"
        + "name=" + name
        + ", variableName=" + variableName
        + "}";
  }

  /**
   * Creates a builder for {@link UnsetEnvironmentVariableApplicationRequest UnsetEnvironmentVariableApplicationRequest}.
   * @return A new UnsetEnvironmentVariableApplicationRequest builder
   */
  public static UnsetEnvironmentVariableApplicationRequest.Builder builder() {
    return new UnsetEnvironmentVariableApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link UnsetEnvironmentVariableApplicationRequest UnsetEnvironmentVariableApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_VARIABLE_NAME = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private String variableName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnsetEnvironmentVariableApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UnsetEnvironmentVariableApplicationRequest instance) {
      return from((_UnsetEnvironmentVariableApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UnsetEnvironmentVariableApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UnsetEnvironmentVariableApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      variableName(instance.getVariableName());
      return this;
    }

    /**
     * Initializes the value for the {@link _UnsetEnvironmentVariableApplicationRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _UnsetEnvironmentVariableApplicationRequest#getVariableName() variableName} attribute.
     * @param variableName The value for variableName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder variableName(String variableName) {
      this.variableName = Objects.requireNonNull(variableName, "variableName");
      initBits &= ~INIT_BIT_VARIABLE_NAME;
      return this;
    }

    /**
     * Builds a new {@link UnsetEnvironmentVariableApplicationRequest UnsetEnvironmentVariableApplicationRequest}.
     * @return An immutable instance of UnsetEnvironmentVariableApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UnsetEnvironmentVariableApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UnsetEnvironmentVariableApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_VARIABLE_NAME) != 0) attributes.add("variableName");
      return "Cannot build UnsetEnvironmentVariableApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
