/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.AllowNulls;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.cloudfoundry.operations.applications.Docker;
import org.cloudfoundry.operations.applications.Route;
import org.immutables.value.Value;

@Value.Immutable
abstract class _ApplicationManifest {
    _ApplicationManifest() {
    }

    @Value.Check
    void check() {
        if (this.getRoutes() != null) {
            if (this.getHosts() != null) {
                throw new IllegalStateException("routes and hosts cannot both be set");
            }
            if (this.getDomains() != null) {
                throw new IllegalStateException("routes and domains cannot both be set");
            }
            if (this.getNoHostname() != null) {
                throw new IllegalStateException("routes and noHostname cannot both be set");
            }
        }
        if (this.getDocker() != null) {
            if (this.getDocker().getImage() != null && this.getBuildpack() != null) {
                throw new IllegalStateException("docker image and buildpack cannot both be set");
            }
            if (this.getDocker().getImage() != null && this.getPath() != null) {
                throw new IllegalStateException("docker image and path cannot both be set");
            }
            if (this.getDocker().getImage() == null && (this.getDocker().getUsername() != null || this.getDocker().getPassword() != null)) {
                throw new IllegalStateException("docker credentials require docker image to be set");
            }
        }
    }

    @JsonProperty(value="buildpack")
    @Nullable
    abstract String getBuildpack();

    @JsonProperty(value="command")
    @Nullable
    abstract String getCommand();

    @JsonProperty(value="disk_quota")
    @Nullable
    abstract Integer getDisk();

    @JsonProperty(value="docker")
    @Nullable
    abstract Docker getDocker();

    @JsonProperty(value="domains")
    @Nullable
    abstract List<String> getDomains();

    @AllowNulls
    @JsonProperty(value="env")
    @Nullable
    abstract Map<String, Object> getEnvironmentVariables();

    @JsonProperty(value="health-check-http-endpoint")
    @Nullable
    abstract String getHealthCheckHttpEndpoint();

    @JsonProperty(value="health-check-type")
    @Nullable
    abstract ApplicationHealthCheck getHealthCheckType();

    @JsonProperty(value="hosts")
    @Nullable
    abstract List<String> getHosts();

    @JsonProperty(value="instances")
    @Nullable
    abstract Integer getInstances();

    @JsonProperty(value="memory")
    @Nullable
    abstract Integer getMemory();

    @JsonProperty(value="name")
    abstract String getName();

    @JsonProperty(value="no-hostname")
    @Nullable
    abstract Boolean getNoHostname();

    @JsonProperty(value="no-route")
    @Nullable
    abstract Boolean getNoRoute();

    @JsonProperty(value="path")
    @Nullable
    abstract Path getPath();

    @JsonProperty(value="random-route")
    @Nullable
    abstract Boolean getRandomRoute();

    @JsonProperty(value="route-path")
    @Nullable
    abstract String getRoutePath();

    @JsonProperty(value="routes")
    @Nullable
    abstract List<Route> getRoutes();

    @JsonProperty(value="services")
    @Nullable
    abstract List<String> getServices();

    @JsonProperty(value="stack")
    @Nullable
    abstract String getStack();

    @JsonProperty(value="timeout")
    @Nullable
    abstract Integer getTimeout();
}

